/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CoverageCost;
import software.amazon.awssdk.services.costexplorer.model.CoverageHours;
import software.amazon.awssdk.services.costexplorer.model.CoverageNormalizedUnits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Coverage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Coverage> {
    private static final SdkField<CoverageHours> COVERAGE_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Coverage.getter(Coverage::coverageHours)).setter(Coverage.setter(Builder::coverageHours)).constructor(CoverageHours::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageHours").build()}).build();
    private static final SdkField<CoverageNormalizedUnits> COVERAGE_NORMALIZED_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Coverage.getter(Coverage::coverageNormalizedUnits)).setter(Coverage.setter(Builder::coverageNormalizedUnits)).constructor(CoverageNormalizedUnits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageNormalizedUnits").build()}).build();
    private static final SdkField<CoverageCost> COVERAGE_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Coverage.getter(Coverage::coverageCost)).setter(Coverage.setter(Builder::coverageCost)).constructor(CoverageCost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageCost").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERAGE_HOURS_FIELD, COVERAGE_NORMALIZED_UNITS_FIELD, COVERAGE_COST_FIELD));
    private static final long serialVersionUID = 1L;
    private final CoverageHours coverageHours;
    private final CoverageNormalizedUnits coverageNormalizedUnits;
    private final CoverageCost coverageCost;

    private Coverage(BuilderImpl builder) {
        this.coverageHours = builder.coverageHours;
        this.coverageNormalizedUnits = builder.coverageNormalizedUnits;
        this.coverageCost = builder.coverageCost;
    }

    public CoverageHours coverageHours() {
        return this.coverageHours;
    }

    public CoverageNormalizedUnits coverageNormalizedUnits() {
        return this.coverageNormalizedUnits;
    }

    public CoverageCost coverageCost() {
        return this.coverageCost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coverageHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.coverageNormalizedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.coverageCost());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coverage)) {
            return false;
        }
        Coverage other = (Coverage)obj;
        return Objects.equals(this.coverageHours(), other.coverageHours()) && Objects.equals(this.coverageNormalizedUnits(), other.coverageNormalizedUnits()) && Objects.equals(this.coverageCost(), other.coverageCost());
    }

    public String toString() {
        return ToString.builder((String)"Coverage").add("CoverageHours", (Object)this.coverageHours()).add("CoverageNormalizedUnits", (Object)this.coverageNormalizedUnits()).add("CoverageCost", (Object)this.coverageCost()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoverageHours": {
                return Optional.ofNullable(clazz.cast(this.coverageHours()));
            }
            case "CoverageNormalizedUnits": {
                return Optional.ofNullable(clazz.cast(this.coverageNormalizedUnits()));
            }
            case "CoverageCost": {
                return Optional.ofNullable(clazz.cast(this.coverageCost()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Coverage, T> g) {
        return obj -> g.apply((Coverage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CoverageHours coverageHours;
        private CoverageNormalizedUnits coverageNormalizedUnits;
        private CoverageCost coverageCost;

        private BuilderImpl() {
        }

        private BuilderImpl(Coverage model) {
            this.coverageHours(model.coverageHours);
            this.coverageNormalizedUnits(model.coverageNormalizedUnits);
            this.coverageCost(model.coverageCost);
        }

        public final CoverageHours.Builder getCoverageHours() {
            return this.coverageHours != null ? this.coverageHours.toBuilder() : null;
        }

        @Override
        public final Builder coverageHours(CoverageHours coverageHours) {
            this.coverageHours = coverageHours;
            return this;
        }

        public final void setCoverageHours(CoverageHours.BuilderImpl coverageHours) {
            this.coverageHours = coverageHours != null ? coverageHours.build() : null;
        }

        public final CoverageNormalizedUnits.Builder getCoverageNormalizedUnits() {
            return this.coverageNormalizedUnits != null ? this.coverageNormalizedUnits.toBuilder() : null;
        }

        @Override
        public final Builder coverageNormalizedUnits(CoverageNormalizedUnits coverageNormalizedUnits) {
            this.coverageNormalizedUnits = coverageNormalizedUnits;
            return this;
        }

        public final void setCoverageNormalizedUnits(CoverageNormalizedUnits.BuilderImpl coverageNormalizedUnits) {
            this.coverageNormalizedUnits = coverageNormalizedUnits != null ? coverageNormalizedUnits.build() : null;
        }

        public final CoverageCost.Builder getCoverageCost() {
            return this.coverageCost != null ? this.coverageCost.toBuilder() : null;
        }

        @Override
        public final Builder coverageCost(CoverageCost coverageCost) {
            this.coverageCost = coverageCost;
            return this;
        }

        public final void setCoverageCost(CoverageCost.BuilderImpl coverageCost) {
            this.coverageCost = coverageCost != null ? coverageCost.build() : null;
        }

        public Coverage build() {
            return new Coverage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Coverage> {
        public Builder coverageHours(CoverageHours var1);

        default public Builder coverageHours(Consumer<CoverageHours.Builder> coverageHours) {
            return this.coverageHours((CoverageHours)((CoverageHours.Builder)CoverageHours.builder().applyMutation(coverageHours)).build());
        }

        public Builder coverageNormalizedUnits(CoverageNormalizedUnits var1);

        default public Builder coverageNormalizedUnits(Consumer<CoverageNormalizedUnits.Builder> coverageNormalizedUnits) {
            return this.coverageNormalizedUnits((CoverageNormalizedUnits)((CoverageNormalizedUnits.Builder)CoverageNormalizedUnits.builder().applyMutation(coverageNormalizedUnits)).build());
        }

        public Builder coverageCost(CoverageCost var1);

        default public Builder coverageCost(Consumer<CoverageCost.Builder> coverageCost) {
            return this.coverageCost((CoverageCost)((CoverageCost.Builder)CoverageCost.builder().applyMutation(coverageCost)).build());
        }
    }
}

