/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElastiCacheInstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElastiCacheInstanceDetails> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElastiCacheInstanceDetails.getter(ElastiCacheInstanceDetails::family)).setter(ElastiCacheInstanceDetails.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElastiCacheInstanceDetails.getter(ElastiCacheInstanceDetails::nodeType)).setter(ElastiCacheInstanceDetails.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElastiCacheInstanceDetails.getter(ElastiCacheInstanceDetails::region)).setter(ElastiCacheInstanceDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElastiCacheInstanceDetails.getter(ElastiCacheInstanceDetails::productDescription)).setter(ElastiCacheInstanceDetails.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build()}).build();
    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ElastiCacheInstanceDetails.getter(ElastiCacheInstanceDetails::currentGeneration)).setter(ElastiCacheInstanceDetails.setter(Builder::currentGeneration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()}).build();
    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ElastiCacheInstanceDetails.getter(ElastiCacheInstanceDetails::sizeFlexEligible)).setter(ElastiCacheInstanceDetails.setter(Builder::sizeFlexEligible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, NODE_TYPE_FIELD, REGION_FIELD, PRODUCT_DESCRIPTION_FIELD, CURRENT_GENERATION_FIELD, SIZE_FLEX_ELIGIBLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String family;
    private final String nodeType;
    private final String region;
    private final String productDescription;
    private final Boolean currentGeneration;
    private final Boolean sizeFlexEligible;

    private ElastiCacheInstanceDetails(BuilderImpl builder) {
        this.family = builder.family;
        this.nodeType = builder.nodeType;
        this.region = builder.region;
        this.productDescription = builder.productDescription;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    public String family() {
        return this.family;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public String region() {
        return this.region;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public Boolean currentGeneration() {
        return this.currentGeneration;
    }

    public Boolean sizeFlexEligible() {
        return this.sizeFlexEligible;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeFlexEligible());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElastiCacheInstanceDetails)) {
            return false;
        }
        ElastiCacheInstanceDetails other = (ElastiCacheInstanceDetails)obj;
        return Objects.equals(this.family(), other.family()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.currentGeneration(), other.currentGeneration()) && Objects.equals(this.sizeFlexEligible(), other.sizeFlexEligible());
    }

    public String toString() {
        return ToString.builder((String)"ElastiCacheInstanceDetails").add("Family", (Object)this.family()).add("NodeType", (Object)this.nodeType()).add("Region", (Object)this.region()).add("ProductDescription", (Object)this.productDescription()).add("CurrentGeneration", (Object)this.currentGeneration()).add("SizeFlexEligible", (Object)this.sizeFlexEligible()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescription()));
            }
            case "CurrentGeneration": {
                return Optional.ofNullable(clazz.cast(this.currentGeneration()));
            }
            case "SizeFlexEligible": {
                return Optional.ofNullable(clazz.cast(this.sizeFlexEligible()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElastiCacheInstanceDetails, T> g) {
        return obj -> g.apply((ElastiCacheInstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String family;
        private String nodeType;
        private String region;
        private String productDescription;
        private Boolean currentGeneration;
        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(ElastiCacheInstanceDetails model) {
            this.family(model.family);
            this.nodeType(model.nodeType);
            this.region(model.region);
            this.productDescription(model.productDescription);
            this.currentGeneration(model.currentGeneration);
            this.sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getFamily() {
            return this.family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final Boolean getCurrentGeneration() {
            return this.currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        public final Boolean getSizeFlexEligible() {
            return this.sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        public ElastiCacheInstanceDetails build() {
            return new ElastiCacheInstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElastiCacheInstanceDetails> {
        public Builder family(String var1);

        public Builder nodeType(String var1);

        public Builder region(String var1);

        public Builder productDescription(String var1);

        public Builder currentGeneration(Boolean var1);

        public Builder sizeFlexEligible(Boolean var1);
    }
}

