/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OfferingClass {
    STANDARD("STANDARD"),
    CONVERTIBLE("CONVERTIBLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OfferingClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OfferingClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OfferingClass.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OfferingClass> knownValues() {
        return Stream.of(OfferingClass.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

