/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryResourceAssociation;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryResourceAssociationsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryResourceAssociationsResponse;

public class ListCostCategoryResourceAssociationsPublisher
implements SdkPublisher<ListCostCategoryResourceAssociationsResponse> {
    private final CostExplorerAsyncClient client;
    private final ListCostCategoryResourceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCostCategoryResourceAssociationsPublisher(CostExplorerAsyncClient client, ListCostCategoryResourceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCostCategoryResourceAssociationsPublisher(CostExplorerAsyncClient client, ListCostCategoryResourceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCostCategoryResourceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCostCategoryResourceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CostCategoryResourceAssociation> costCategoryResourceAssociations() {
        return this.flatMapIterable(response -> response.costCategoryResourceAssociations());
    }

    private class ListCostCategoryResourceAssociationsResponseFetcher
    implements AsyncPageFetcher<ListCostCategoryResourceAssociationsResponse> {
        private ListCostCategoryResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCostCategoryResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCostCategoryResourceAssociationsResponse> nextPage(ListCostCategoryResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCostCategoryResourceAssociationsPublisher.this.client.listCostCategoryResourceAssociations(ListCostCategoryResourceAssociationsPublisher.this.firstRequest);
            }
            return ListCostCategoryResourceAssociationsPublisher.this.client.listCostCategoryResourceAssociations((ListCostCategoryResourceAssociationsRequest)((Object)ListCostCategoryResourceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

