/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation;

public class GetReservationPurchaseRecommendationPublisher
implements SdkPublisher<GetReservationPurchaseRecommendationResponse> {
    private final CostExplorerAsyncClient client;
    private final GetReservationPurchaseRecommendationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetReservationPurchaseRecommendationPublisher(CostExplorerAsyncClient client, GetReservationPurchaseRecommendationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetReservationPurchaseRecommendationPublisher(CostExplorerAsyncClient client, GetReservationPurchaseRecommendationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetReservationPurchaseRecommendationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetReservationPurchaseRecommendationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservationPurchaseRecommendation> recommendations() {
        return this.flatMapIterable(response -> response.recommendations());
    }

    private class GetReservationPurchaseRecommendationResponseFetcher
    implements AsyncPageFetcher<GetReservationPurchaseRecommendationResponse> {
        private GetReservationPurchaseRecommendationResponseFetcher() {
        }

        public boolean hasNextPage(GetReservationPurchaseRecommendationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetReservationPurchaseRecommendationResponse> nextPage(GetReservationPurchaseRecommendationResponse previousPage) {
            if (previousPage == null) {
                return GetReservationPurchaseRecommendationPublisher.this.client.getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationPublisher.this.firstRequest);
            }
            return GetReservationPurchaseRecommendationPublisher.this.client.getReservationPurchaseRecommendation((GetReservationPurchaseRecommendationRequest)((Object)GetReservationPurchaseRecommendationPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

