/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.GenerationSummary;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationResponse;

public class ListSavingsPlansPurchaseRecommendationGenerationPublisher
implements SdkPublisher<ListSavingsPlansPurchaseRecommendationGenerationResponse> {
    private final CostExplorerAsyncClient client;
    private final ListSavingsPlansPurchaseRecommendationGenerationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSavingsPlansPurchaseRecommendationGenerationPublisher(CostExplorerAsyncClient client, ListSavingsPlansPurchaseRecommendationGenerationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSavingsPlansPurchaseRecommendationGenerationPublisher(CostExplorerAsyncClient client, ListSavingsPlansPurchaseRecommendationGenerationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSavingsPlansPurchaseRecommendationGenerationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSavingsPlansPurchaseRecommendationGenerationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GenerationSummary> generationSummaryList() {
        Function<ListSavingsPlansPurchaseRecommendationGenerationResponse, Iterator> getIterator = response -> {
            if (response != null && response.generationSummaryList() != null) {
                return response.generationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSavingsPlansPurchaseRecommendationGenerationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSavingsPlansPurchaseRecommendationGenerationResponseFetcher
    implements AsyncPageFetcher<ListSavingsPlansPurchaseRecommendationGenerationResponse> {
        private ListSavingsPlansPurchaseRecommendationGenerationResponseFetcher() {
        }

        public boolean hasNextPage(ListSavingsPlansPurchaseRecommendationGenerationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListSavingsPlansPurchaseRecommendationGenerationResponse> nextPage(ListSavingsPlansPurchaseRecommendationGenerationResponse previousPage) {
            if (previousPage == null) {
                return ListSavingsPlansPurchaseRecommendationGenerationPublisher.this.client.listSavingsPlansPurchaseRecommendationGeneration(ListSavingsPlansPurchaseRecommendationGenerationPublisher.this.firstRequest);
            }
            return ListSavingsPlansPurchaseRecommendationGenerationPublisher.this.client.listSavingsPlansPurchaseRecommendationGeneration((ListSavingsPlansPurchaseRecommendationGenerationRequest)((Object)ListSavingsPlansPurchaseRecommendationGenerationPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

