/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation;

public class GetReservationPurchaseRecommendationIterable
implements SdkIterable<GetReservationPurchaseRecommendationResponse> {
    private final CostExplorerClient client;
    private final GetReservationPurchaseRecommendationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetReservationPurchaseRecommendationIterable(CostExplorerClient client, GetReservationPurchaseRecommendationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetReservationPurchaseRecommendationResponseFetcher();
    }

    public Iterator<GetReservationPurchaseRecommendationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservationPurchaseRecommendation> recommendations() {
        Function<GetReservationPurchaseRecommendationResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendations() != null) {
                return response.recommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetReservationPurchaseRecommendationResponseFetcher
    implements SyncPageFetcher<GetReservationPurchaseRecommendationResponse> {
        private GetReservationPurchaseRecommendationResponseFetcher() {
        }

        public boolean hasNextPage(GetReservationPurchaseRecommendationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetReservationPurchaseRecommendationResponse nextPage(GetReservationPurchaseRecommendationResponse previousPage) {
            if (previousPage == null) {
                return GetReservationPurchaseRecommendationIterable.this.client.getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationIterable.this.firstRequest);
            }
            return GetReservationPurchaseRecommendationIterable.this.client.getReservationPurchaseRecommendation((GetReservationPurchaseRecommendationRequest)((Object)GetReservationPurchaseRecommendationIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

