/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SupportedSavingsPlansType {
    COMPUTE_SP("COMPUTE_SP"),
    EC2_INSTANCE_SP("EC2_INSTANCE_SP"),
    SAGEMAKER_SP("SAGEMAKER_SP"),
    DATABASE_SP("DATABASE_SP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SupportedSavingsPlansType> VALUE_MAP;
    private final String value;

    private SupportedSavingsPlansType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SupportedSavingsPlansType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SupportedSavingsPlansType> knownValues() {
        EnumSet<SupportedSavingsPlansType> knownValues = EnumSet.allOf(SupportedSavingsPlansType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SupportedSavingsPlansType.class, SupportedSavingsPlansType::toString);
    }
}

