/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinition;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostAndUsageComparisonsRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetCostAndUsageComparisonsRequest> {
    private static final SdkField<String> BILLING_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingViewArn").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::billingViewArn)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::billingViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingViewArn").build()}).build();
    private static final SdkField<DateInterval> BASELINE_TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaselineTimePeriod").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::baselineTimePeriod)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::baselineTimePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineTimePeriod").build()}).build();
    private static final SdkField<DateInterval> COMPARISON_TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComparisonTimePeriod").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::comparisonTimePeriod)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::comparisonTimePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonTimePeriod").build()}).build();
    private static final SdkField<String> METRIC_FOR_COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricForComparison").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::metricForComparison)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::metricForComparison)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricForComparison").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::filter)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<GroupDefinition>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupBy").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::groupBy)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::maxResults)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetCostAndUsageComparisonsRequest.getter(GetCostAndUsageComparisonsRequest::nextPageToken)).setter(GetCostAndUsageComparisonsRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_VIEW_ARN_FIELD, BASELINE_TIME_PERIOD_FIELD, COMPARISON_TIME_PERIOD_FIELD, METRIC_FOR_COMPARISON_FIELD, FILTER_FIELD, GROUP_BY_FIELD, MAX_RESULTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCostAndUsageComparisonsRequest.memberNameToFieldInitializer();
    private final String billingViewArn;
    private final DateInterval baselineTimePeriod;
    private final DateInterval comparisonTimePeriod;
    private final String metricForComparison;
    private final Expression filter;
    private final List<GroupDefinition> groupBy;
    private final Integer maxResults;
    private final String nextPageToken;

    private GetCostAndUsageComparisonsRequest(BuilderImpl builder) {
        super(builder);
        this.billingViewArn = builder.billingViewArn;
        this.baselineTimePeriod = builder.baselineTimePeriod;
        this.comparisonTimePeriod = builder.comparisonTimePeriod;
        this.metricForComparison = builder.metricForComparison;
        this.filter = builder.filter;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.nextPageToken = builder.nextPageToken;
    }

    public final String billingViewArn() {
        return this.billingViewArn;
    }

    public final DateInterval baselineTimePeriod() {
        return this.baselineTimePeriod;
    }

    public final DateInterval comparisonTimePeriod() {
        return this.comparisonTimePeriod;
    }

    public final String metricForComparison() {
        return this.metricForComparison;
    }

    public final Expression filter() {
        return this.filter;
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<GroupDefinition> groupBy() {
        return this.groupBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricForComparison());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostAndUsageComparisonsRequest)) {
            return false;
        }
        GetCostAndUsageComparisonsRequest other = (GetCostAndUsageComparisonsRequest)((Object)obj);
        return Objects.equals(this.billingViewArn(), other.billingViewArn()) && Objects.equals(this.baselineTimePeriod(), other.baselineTimePeriod()) && Objects.equals(this.comparisonTimePeriod(), other.comparisonTimePeriod()) && Objects.equals(this.metricForComparison(), other.metricForComparison()) && Objects.equals(this.filter(), other.filter()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupBy(), other.groupBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostAndUsageComparisonsRequest").add("BillingViewArn", (Object)this.billingViewArn()).add("BaselineTimePeriod", (Object)this.baselineTimePeriod()).add("ComparisonTimePeriod", (Object)this.comparisonTimePeriod()).add("MetricForComparison", (Object)this.metricForComparison()).add("Filter", (Object)this.filter()).add("GroupBy", this.hasGroupBy() ? this.groupBy() : null).add("MaxResults", (Object)this.maxResults()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingViewArn": {
                return Optional.ofNullable(clazz.cast(this.billingViewArn()));
            }
            case "BaselineTimePeriod": {
                return Optional.ofNullable(clazz.cast(this.baselineTimePeriod()));
            }
            case "ComparisonTimePeriod": {
                return Optional.ofNullable(clazz.cast(this.comparisonTimePeriod()));
            }
            case "MetricForComparison": {
                return Optional.ofNullable(clazz.cast(this.metricForComparison()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BillingViewArn", BILLING_VIEW_ARN_FIELD);
        map.put("BaselineTimePeriod", BASELINE_TIME_PERIOD_FIELD);
        map.put("ComparisonTimePeriod", COMPARISON_TIME_PERIOD_FIELD);
        map.put("MetricForComparison", METRIC_FOR_COMPARISON_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostAndUsageComparisonsRequest, T> g) {
        return obj -> g.apply((GetCostAndUsageComparisonsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String billingViewArn;
        private DateInterval baselineTimePeriod;
        private DateInterval comparisonTimePeriod;
        private String metricForComparison;
        private Expression filter;
        private List<GroupDefinition> groupBy = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostAndUsageComparisonsRequest model) {
            super(model);
            this.billingViewArn(model.billingViewArn);
            this.baselineTimePeriod(model.baselineTimePeriod);
            this.comparisonTimePeriod(model.comparisonTimePeriod);
            this.metricForComparison(model.metricForComparison);
            this.filter(model.filter);
            this.groupBy(model.groupBy);
            this.maxResults(model.maxResults);
            this.nextPageToken(model.nextPageToken);
        }

        public final String getBillingViewArn() {
            return this.billingViewArn;
        }

        public final void setBillingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
        }

        @Override
        public final Builder billingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        public final DateInterval.Builder getBaselineTimePeriod() {
            return this.baselineTimePeriod != null ? this.baselineTimePeriod.toBuilder() : null;
        }

        public final void setBaselineTimePeriod(DateInterval.BuilderImpl baselineTimePeriod) {
            this.baselineTimePeriod = baselineTimePeriod != null ? baselineTimePeriod.build() : null;
        }

        @Override
        public final Builder baselineTimePeriod(DateInterval baselineTimePeriod) {
            this.baselineTimePeriod = baselineTimePeriod;
            return this;
        }

        public final DateInterval.Builder getComparisonTimePeriod() {
            return this.comparisonTimePeriod != null ? this.comparisonTimePeriod.toBuilder() : null;
        }

        public final void setComparisonTimePeriod(DateInterval.BuilderImpl comparisonTimePeriod) {
            this.comparisonTimePeriod = comparisonTimePeriod != null ? comparisonTimePeriod.build() : null;
        }

        @Override
        public final Builder comparisonTimePeriod(DateInterval comparisonTimePeriod) {
            this.comparisonTimePeriod = comparisonTimePeriod;
            return this;
        }

        public final String getMetricForComparison() {
            return this.metricForComparison;
        }

        public final void setMetricForComparison(String metricForComparison) {
            this.metricForComparison = metricForComparison;
        }

        @Override
        public final Builder metricForComparison(String metricForComparison) {
            this.metricForComparison = metricForComparison;
            return this;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupBy() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<GroupDefinition.BuilderImpl> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<GroupDefinition> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupDefinition ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<GroupDefinition.Builder> ... groupBy) {
            this.groupBy(Stream.of(groupBy).map(c -> (GroupDefinition)((GroupDefinition.Builder)GroupDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCostAndUsageComparisonsRequest build() {
            return new GetCostAndUsageComparisonsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostAndUsageComparisonsRequest> {
        public Builder billingViewArn(String var1);

        public Builder baselineTimePeriod(DateInterval var1);

        default public Builder baselineTimePeriod(Consumer<DateInterval.Builder> baselineTimePeriod) {
            return this.baselineTimePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(baselineTimePeriod)).build());
        }

        public Builder comparisonTimePeriod(DateInterval var1);

        default public Builder comparisonTimePeriod(Consumer<DateInterval.Builder> comparisonTimePeriod) {
            return this.comparisonTimePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(comparisonTimePeriod)).build());
        }

        public Builder metricForComparison(String var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder groupBy(Collection<GroupDefinition> var1);

        public Builder groupBy(GroupDefinition ... var1);

        public Builder groupBy(Consumer<GroupDefinition.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

