/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryResourceAssociation;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryResourceAssociationsCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCostCategoryResourceAssociationsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, ListCostCategoryResourceAssociationsResponse> {
    private static final SdkField<List<CostCategoryResourceAssociation>> COST_CATEGORY_RESOURCE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostCategoryResourceAssociations").getter(ListCostCategoryResourceAssociationsResponse.getter(ListCostCategoryResourceAssociationsResponse::costCategoryResourceAssociations)).setter(ListCostCategoryResourceAssociationsResponse.setter(Builder::costCategoryResourceAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryResourceAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryResourceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCostCategoryResourceAssociationsResponse.getter(ListCostCategoryResourceAssociationsResponse::nextToken)).setter(ListCostCategoryResourceAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_RESOURCE_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCostCategoryResourceAssociationsResponse.memberNameToFieldInitializer();
    private final List<CostCategoryResourceAssociation> costCategoryResourceAssociations;
    private final String nextToken;

    private ListCostCategoryResourceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.costCategoryResourceAssociations = builder.costCategoryResourceAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCostCategoryResourceAssociations() {
        return this.costCategoryResourceAssociations != null && !(this.costCategoryResourceAssociations instanceof SdkAutoConstructList);
    }

    public final List<CostCategoryResourceAssociation> costCategoryResourceAssociations() {
        return this.costCategoryResourceAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostCategoryResourceAssociations() ? this.costCategoryResourceAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostCategoryResourceAssociationsResponse)) {
            return false;
        }
        ListCostCategoryResourceAssociationsResponse other = (ListCostCategoryResourceAssociationsResponse)((Object)obj);
        return this.hasCostCategoryResourceAssociations() == other.hasCostCategoryResourceAssociations() && Objects.equals(this.costCategoryResourceAssociations(), other.costCategoryResourceAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCostCategoryResourceAssociationsResponse").add("CostCategoryResourceAssociations", this.hasCostCategoryResourceAssociations() ? this.costCategoryResourceAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostCategoryResourceAssociations": {
                return Optional.ofNullable(clazz.cast(this.costCategoryResourceAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CostCategoryResourceAssociations", COST_CATEGORY_RESOURCE_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCostCategoryResourceAssociationsResponse, T> g) {
        return obj -> g.apply((ListCostCategoryResourceAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<CostCategoryResourceAssociation> costCategoryResourceAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostCategoryResourceAssociationsResponse model) {
            super(model);
            this.costCategoryResourceAssociations(model.costCategoryResourceAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<CostCategoryResourceAssociation.Builder> getCostCategoryResourceAssociations() {
            List<CostCategoryResourceAssociation.Builder> result = CostCategoryResourceAssociationsCopier.copyToBuilder(this.costCategoryResourceAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostCategoryResourceAssociations(Collection<CostCategoryResourceAssociation.BuilderImpl> costCategoryResourceAssociations) {
            this.costCategoryResourceAssociations = CostCategoryResourceAssociationsCopier.copyFromBuilder(costCategoryResourceAssociations);
        }

        @Override
        public final Builder costCategoryResourceAssociations(Collection<CostCategoryResourceAssociation> costCategoryResourceAssociations) {
            this.costCategoryResourceAssociations = CostCategoryResourceAssociationsCopier.copy(costCategoryResourceAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryResourceAssociations(CostCategoryResourceAssociation ... costCategoryResourceAssociations) {
            this.costCategoryResourceAssociations(Arrays.asList(costCategoryResourceAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryResourceAssociations(Consumer<CostCategoryResourceAssociation.Builder> ... costCategoryResourceAssociations) {
            this.costCategoryResourceAssociations(Stream.of(costCategoryResourceAssociations).map(c -> (CostCategoryResourceAssociation)((CostCategoryResourceAssociation.Builder)CostCategoryResourceAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCostCategoryResourceAssociationsResponse build() {
            return new ListCostCategoryResourceAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCostCategoryResourceAssociationsResponse> {
        public Builder costCategoryResourceAssociations(Collection<CostCategoryResourceAssociation> var1);

        public Builder costCategoryResourceAssociations(CostCategoryResourceAssociation ... var1);

        public Builder costCategoryResourceAssociations(Consumer<CostCategoryResourceAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

