/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostAllocationTagBackfillRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryResponse;

public class ListCostAllocationTagBackfillHistoryPublisher
implements SdkPublisher<ListCostAllocationTagBackfillHistoryResponse> {
    private final CostExplorerAsyncClient client;
    private final ListCostAllocationTagBackfillHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCostAllocationTagBackfillHistoryPublisher(CostExplorerAsyncClient client, ListCostAllocationTagBackfillHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCostAllocationTagBackfillHistoryPublisher(CostExplorerAsyncClient client, ListCostAllocationTagBackfillHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCostAllocationTagBackfillHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCostAllocationTagBackfillHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CostAllocationTagBackfillRequest> backfillRequests() {
        Function<ListCostAllocationTagBackfillHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.backfillRequests() != null) {
                return response.backfillRequests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCostAllocationTagBackfillHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCostAllocationTagBackfillHistoryResponseFetcher
    implements AsyncPageFetcher<ListCostAllocationTagBackfillHistoryResponse> {
        private ListCostAllocationTagBackfillHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListCostAllocationTagBackfillHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCostAllocationTagBackfillHistoryResponse> nextPage(ListCostAllocationTagBackfillHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListCostAllocationTagBackfillHistoryPublisher.this.client.listCostAllocationTagBackfillHistory(ListCostAllocationTagBackfillHistoryPublisher.this.firstRequest);
            }
            return ListCostAllocationTagBackfillHistoryPublisher.this.client.listCostAllocationTagBackfillHistory((ListCostAllocationTagBackfillHistoryRequest)((Object)ListCostAllocationTagBackfillHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

