/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryResourceAssociation;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryResourceAssociationsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryResourceAssociationsResponse;

public class ListCostCategoryResourceAssociationsIterable
implements SdkIterable<ListCostCategoryResourceAssociationsResponse> {
    private final CostExplorerClient client;
    private final ListCostCategoryResourceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCostCategoryResourceAssociationsIterable(CostExplorerClient client, ListCostCategoryResourceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCostCategoryResourceAssociationsResponseFetcher();
    }

    public Iterator<ListCostCategoryResourceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CostCategoryResourceAssociation> costCategoryResourceAssociations() {
        Function<ListCostCategoryResourceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.costCategoryResourceAssociations() != null) {
                return response.costCategoryResourceAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCostCategoryResourceAssociationsResponseFetcher
    implements SyncPageFetcher<ListCostCategoryResourceAssociationsResponse> {
        private ListCostCategoryResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCostCategoryResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCostCategoryResourceAssociationsResponse nextPage(ListCostCategoryResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCostCategoryResourceAssociationsIterable.this.client.listCostCategoryResourceAssociations(ListCostCategoryResourceAssociationsIterable.this.firstRequest);
            }
            return ListCostCategoryResourceAssociationsIterable.this.client.listCostCategoryResourceAssociations((ListCostCategoryResourceAssociationsRequest)((Object)ListCostCategoryResourceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

