/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnomalySubscriptionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<UpdateAnomalySubscriptionRequest.Builder, UpdateAnomalySubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionArn").getter(getter(UpdateAnomalySubscriptionRequest::subscriptionArn))
            .setter(setter(Builder::subscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()).build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Threshold").getter(getter(UpdateAnomalySubscriptionRequest::threshold))
            .setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Frequency").getter(getter(UpdateAnomalySubscriptionRequest::frequencyAsString))
            .setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()).build();

    private static final SdkField<List<String>> MONITOR_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MonitorArnList")
            .getter(getter(UpdateAnomalySubscriptionRequest::monitorArnList))
            .setter(setter(Builder::monitorArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField
            .<List<Subscriber>> builder(MarshallingType.LIST)
            .memberName("Subscribers")
            .getter(getter(UpdateAnomalySubscriptionRequest::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscriber> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscriber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionName").getter(getter(UpdateAnomalySubscriptionRequest::subscriptionName))
            .setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<Expression> THRESHOLD_EXPRESSION_FIELD = SdkField
            .<Expression> builder(MarshallingType.SDK_POJO).memberName("ThresholdExpression")
            .getter(getter(UpdateAnomalySubscriptionRequest::thresholdExpression)).setter(setter(Builder::thresholdExpression))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD,
            THRESHOLD_FIELD, FREQUENCY_FIELD, MONITOR_ARN_LIST_FIELD, SUBSCRIBERS_FIELD, SUBSCRIPTION_NAME_FIELD,
            THRESHOLD_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String subscriptionArn;

    private final Double threshold;

    private final String frequency;

    private final List<String> monitorArnList;

    private final List<Subscriber> subscribers;

    private final String subscriptionName;

    private final Expression thresholdExpression;

    private UpdateAnomalySubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArn = builder.subscriptionArn;
        this.threshold = builder.threshold;
        this.frequency = builder.frequency;
        this.monitorArnList = builder.monitorArnList;
        this.subscribers = builder.subscribers;
        this.subscriptionName = builder.subscriptionName;
        this.thresholdExpression = builder.thresholdExpression;
    }

    /**
     * <p>
     * A cost anomaly subscription Amazon Resource Name (ARN).
     * </p>
     * 
     * @return A cost anomaly subscription Amazon Resource Name (ARN).
     */
    public final String subscriptionArn() {
        return subscriptionArn;
    }

    /**
     * <p>
     * (deprecated)
     * </p>
     * <p>
     * The update to the threshold value for receiving notifications.
     * </p>
     * <p>
     * This field has been deprecated. To update a threshold, use ThresholdExpression. Continued use of Threshold will
     * be treated as shorthand syntax for a ThresholdExpression.
     * </p>
     * <p>
     * You can specify either Threshold or ThresholdExpression, but not both.
     * </p>
     * 
     * @return (deprecated)</p>
     *         <p>
     *         The update to the threshold value for receiving notifications.
     *         </p>
     *         <p>
     *         This field has been deprecated. To update a threshold, use ThresholdExpression. Continued use of
     *         Threshold will be treated as shorthand syntax for a ThresholdExpression.
     *         </p>
     *         <p>
     *         You can specify either Threshold or ThresholdExpression, but not both.
     * @deprecated Threshold has been deprecated in favor of ThresholdExpression
     */
    @Deprecated
    public final Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * The update to the frequency value that subscribers receive notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AnomalySubscriptionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The update to the frequency value that subscribers receive notifications.
     * @see AnomalySubscriptionFrequency
     */
    public final AnomalySubscriptionFrequency frequency() {
        return AnomalySubscriptionFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * The update to the frequency value that subscribers receive notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AnomalySubscriptionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The update to the frequency value that subscribers receive notifications.
     * @see AnomalySubscriptionFrequency
     */
    public final String frequencyAsString() {
        return frequency;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitorArnList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMonitorArnList() {
        return monitorArnList != null && !(monitorArnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cost anomaly monitor ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitorArnList} method.
     * </p>
     * 
     * @return A list of cost anomaly monitor ARNs.
     */
    public final List<String> monitorArnList() {
        return monitorArnList;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscribers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribers() {
        return subscribers != null && !(subscribers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The update to the subscriber list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribers} method.
     * </p>
     * 
     * @return The update to the subscriber list.
     */
    public final List<Subscriber> subscribers() {
        return subscribers;
    }

    /**
     * <p>
     * The new name of the subscription.
     * </p>
     * 
     * @return The new name of the subscription.
     */
    public final String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The update to the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
     * object used to specify the anomalies that you want to generate alerts for. This supports dimensions and nested
     * expressions. The supported dimensions are <code>ANOMALY_TOTAL_IMPACT_ABSOLUTE</code> and
     * <code>ANOMALY_TOTAL_IMPACT_PERCENTAGE</code>, corresponding to an anomaly’s TotalImpact and
     * TotalImpactPercentage, respectively (see <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html">Impact</a> for more
     * details). The supported nested expression types are <code>AND</code> and <code>OR</code>. The match option
     * <code>GREATER_THAN_OR_EQUAL</code> is required. Values must be numbers between 0 and 10,000,000,000 in string
     * format.
     * </p>
     * <p>
     * You can specify either Threshold or ThresholdExpression, but not both.
     * </p>
     * <p>
     * The following are examples of valid ThresholdExpressions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Absolute threshold:
     * <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Percentage threshold:
     * <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AND</code> two thresholds together:
     * <code>{ "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OR</code> two thresholds together:
     * <code>{ "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The update to the <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
     *         >Expression</a> object used to specify the anomalies that you want to generate alerts for. This supports
     *         dimensions and nested expressions. The supported dimensions are
     *         <code>ANOMALY_TOTAL_IMPACT_ABSOLUTE</code> and <code>ANOMALY_TOTAL_IMPACT_PERCENTAGE</code>,
     *         corresponding to an anomaly’s TotalImpact and TotalImpactPercentage, respectively (see <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html">Impact</a> for
     *         more details). The supported nested expression types are <code>AND</code> and <code>OR</code>. The match
     *         option <code>GREATER_THAN_OR_EQUAL</code> is required. Values must be numbers between 0 and
     *         10,000,000,000 in string format.</p>
     *         <p>
     *         You can specify either Threshold or ThresholdExpression, but not both.
     *         </p>
     *         <p>
     *         The following are examples of valid ThresholdExpressions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Absolute threshold:
     *         <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Percentage threshold:
     *         <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AND</code> two thresholds together:
     *         <code>{ "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OR</code> two thresholds together:
     *         <code>{ "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
     *         </p>
     *         </li>
     */
    public final Expression thresholdExpression() {
        return thresholdExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitorArnList() ? monitorArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribers() ? subscribers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalySubscriptionRequest)) {
            return false;
        }
        UpdateAnomalySubscriptionRequest other = (UpdateAnomalySubscriptionRequest) obj;
        return Objects.equals(subscriptionArn(), other.subscriptionArn()) && Objects.equals(threshold(), other.threshold())
                && Objects.equals(frequencyAsString(), other.frequencyAsString())
                && hasMonitorArnList() == other.hasMonitorArnList() && Objects.equals(monitorArnList(), other.monitorArnList())
                && hasSubscribers() == other.hasSubscribers() && Objects.equals(subscribers(), other.subscribers())
                && Objects.equals(subscriptionName(), other.subscriptionName())
                && Objects.equals(thresholdExpression(), other.thresholdExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnomalySubscriptionRequest").add("SubscriptionArn", subscriptionArn())
                .add("Threshold", threshold()).add("Frequency", frequencyAsString())
                .add("MonitorArnList", hasMonitorArnList() ? monitorArnList() : null)
                .add("Subscribers", hasSubscribers() ? subscribers() : null).add("SubscriptionName", subscriptionName())
                .add("ThresholdExpression", thresholdExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionArn":
            return Optional.ofNullable(clazz.cast(subscriptionArn()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "MonitorArnList":
            return Optional.ofNullable(clazz.cast(monitorArnList()));
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "ThresholdExpression":
            return Optional.ofNullable(clazz.cast(thresholdExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubscriptionArn", SUBSCRIPTION_ARN_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("Frequency", FREQUENCY_FIELD);
        map.put("MonitorArnList", MONITOR_ARN_LIST_FIELD);
        map.put("Subscribers", SUBSCRIBERS_FIELD);
        map.put("SubscriptionName", SUBSCRIPTION_NAME_FIELD);
        map.put("ThresholdExpression", THRESHOLD_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalySubscriptionRequest, T> g) {
        return obj -> g.apply((UpdateAnomalySubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAnomalySubscriptionRequest> {
        /**
         * <p>
         * A cost anomaly subscription Amazon Resource Name (ARN).
         * </p>
         * 
         * @param subscriptionArn
         *        A cost anomaly subscription Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);

        /**
         * <p>
         * (deprecated)
         * </p>
         * <p>
         * The update to the threshold value for receiving notifications.
         * </p>
         * <p>
         * This field has been deprecated. To update a threshold, use ThresholdExpression. Continued use of Threshold
         * will be treated as shorthand syntax for a ThresholdExpression.
         * </p>
         * <p>
         * You can specify either Threshold or ThresholdExpression, but not both.
         * </p>
         * 
         * @param threshold
         *        (deprecated)</p>
         *        <p>
         *        The update to the threshold value for receiving notifications.
         *        </p>
         *        <p>
         *        This field has been deprecated. To update a threshold, use ThresholdExpression. Continued use of
         *        Threshold will be treated as shorthand syntax for a ThresholdExpression.
         *        </p>
         *        <p>
         *        You can specify either Threshold or ThresholdExpression, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Threshold has been deprecated in favor of ThresholdExpression
         */
        @Deprecated
        Builder threshold(Double threshold);

        /**
         * <p>
         * The update to the frequency value that subscribers receive notifications.
         * </p>
         * 
         * @param frequency
         *        The update to the frequency value that subscribers receive notifications.
         * @see AnomalySubscriptionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalySubscriptionFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The update to the frequency value that subscribers receive notifications.
         * </p>
         * 
         * @param frequency
         *        The update to the frequency value that subscribers receive notifications.
         * @see AnomalySubscriptionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalySubscriptionFrequency
         */
        Builder frequency(AnomalySubscriptionFrequency frequency);

        /**
         * <p>
         * A list of cost anomaly monitor ARNs.
         * </p>
         * 
         * @param monitorArnList
         *        A list of cost anomaly monitor ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArnList(Collection<String> monitorArnList);

        /**
         * <p>
         * A list of cost anomaly monitor ARNs.
         * </p>
         * 
         * @param monitorArnList
         *        A list of cost anomaly monitor ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArnList(String... monitorArnList);

        /**
         * <p>
         * The update to the subscriber list.
         * </p>
         * 
         * @param subscribers
         *        The update to the subscriber list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         * <p>
         * The update to the subscriber list.
         * </p>
         * 
         * @param subscribers
         *        The update to the subscriber list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);

        /**
         * <p>
         * The update to the subscriber list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.Subscriber.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.costexplorer.model.Subscriber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.Subscriber.Builder#build()} is called immediately
         * and its result is passed to {@link #subscribers(List<Subscriber>)}.
         * 
         * @param subscribers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.Subscriber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribers(java.util.Collection<Subscriber>)
         */
        Builder subscribers(Consumer<Subscriber.Builder>... subscribers);

        /**
         * <p>
         * The new name of the subscription.
         * </p>
         * 
         * @param subscriptionName
         *        The new name of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The update to the <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object used to specify the anomalies that you want to generate alerts for. This supports dimensions and
         * nested expressions. The supported dimensions are <code>ANOMALY_TOTAL_IMPACT_ABSOLUTE</code> and
         * <code>ANOMALY_TOTAL_IMPACT_PERCENTAGE</code>, corresponding to an anomaly’s TotalImpact and
         * TotalImpactPercentage, respectively (see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html">Impact</a> for
         * more details). The supported nested expression types are <code>AND</code> and <code>OR</code>. The match
         * option <code>GREATER_THAN_OR_EQUAL</code> is required. Values must be numbers between 0 and 10,000,000,000 in
         * string format.
         * </p>
         * <p>
         * You can specify either Threshold or ThresholdExpression, but not both.
         * </p>
         * <p>
         * The following are examples of valid ThresholdExpressions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Absolute threshold:
         * <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Percentage threshold:
         * <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AND</code> two thresholds together:
         * <code>{ "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OR</code> two thresholds together:
         * <code>{ "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param thresholdExpression
         *        The update to the <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
         *        >Expression</a> object used to specify the anomalies that you want to generate alerts for. This
         *        supports dimensions and nested expressions. The supported dimensions are
         *        <code>ANOMALY_TOTAL_IMPACT_ABSOLUTE</code> and <code>ANOMALY_TOTAL_IMPACT_PERCENTAGE</code>,
         *        corresponding to an anomaly’s TotalImpact and TotalImpactPercentage, respectively (see <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html">Impact</a>
         *        for more details). The supported nested expression types are <code>AND</code> and <code>OR</code>. The
         *        match option <code>GREATER_THAN_OR_EQUAL</code> is required. Values must be numbers between 0 and
         *        10,000,000,000 in string format.</p>
         *        <p>
         *        You can specify either Threshold or ThresholdExpression, but not both.
         *        </p>
         *        <p>
         *        The following are examples of valid ThresholdExpressions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Absolute threshold:
         *        <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Percentage threshold:
         *        <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AND</code> two thresholds together:
         *        <code>{ "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OR</code> two thresholds together:
         *        <code>{ "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdExpression(Expression thresholdExpression);

        /**
         * <p>
         * The update to the <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object used to specify the anomalies that you want to generate alerts for. This supports dimensions and
         * nested expressions. The supported dimensions are <code>ANOMALY_TOTAL_IMPACT_ABSOLUTE</code> and
         * <code>ANOMALY_TOTAL_IMPACT_PERCENTAGE</code>, corresponding to an anomaly’s TotalImpact and
         * TotalImpactPercentage, respectively (see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html">Impact</a> for
         * more details). The supported nested expression types are <code>AND</code> and <code>OR</code>. The match
         * option <code>GREATER_THAN_OR_EQUAL</code> is required. Values must be numbers between 0 and 10,000,000,000 in
         * string format.
         * </p>
         * <p>
         * You can specify either Threshold or ThresholdExpression, but not both.
         * </p>
         * <p>
         * The following are examples of valid ThresholdExpressions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Absolute threshold:
         * <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Percentage threshold:
         * <code>{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AND</code> two thresholds together:
         * <code>{ "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OR</code> two thresholds together:
         * <code>{ "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #thresholdExpression(Expression)}.
         * 
         * @param thresholdExpression
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thresholdExpression(Expression)
         */
        default Builder thresholdExpression(Consumer<Expression.Builder> thresholdExpression) {
            return thresholdExpression(Expression.builder().applyMutation(thresholdExpression).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String subscriptionArn;

        private Double threshold;

        private String frequency;

        private List<String> monitorArnList = DefaultSdkAutoConstructList.getInstance();

        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();

        private String subscriptionName;

        private Expression thresholdExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalySubscriptionRequest model) {
            super(model);
            subscriptionArn(model.subscriptionArn);
            threshold(model.threshold);
            frequency(model.frequency);
            monitorArnList(model.monitorArnList);
            subscribers(model.subscribers);
            subscriptionName(model.subscriptionName);
            thresholdExpression(model.thresholdExpression);
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        @Deprecated
        public final Double getThreshold() {
            return threshold;
        }

        @Deprecated
        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        @Deprecated
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getFrequency() {
            return frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AnomalySubscriptionFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final Collection<String> getMonitorArnList() {
            if (monitorArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return monitorArnList;
        }

        public final void setMonitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = MonitorArnListCopier.copy(monitorArnList);
        }

        @Override
        public final Builder monitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = MonitorArnListCopier.copy(monitorArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitorArnList(String... monitorArnList) {
            monitorArnList(Arrays.asList(monitorArnList));
            return this;
        }

        public final List<Subscriber.Builder> getSubscribers() {
            List<Subscriber.Builder> result = SubscribersCopier.copyToBuilder(this.subscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder>... subscribers) {
            subscribers(Stream.of(subscribers).map(c -> Subscriber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final Expression.Builder getThresholdExpression() {
            return thresholdExpression != null ? thresholdExpression.toBuilder() : null;
        }

        public final void setThresholdExpression(Expression.BuilderImpl thresholdExpression) {
            this.thresholdExpression = thresholdExpression != null ? thresholdExpression.build() : null;
        }

        @Override
        public final Builder thresholdExpression(Expression thresholdExpression) {
            this.thresholdExpression = thresholdExpression;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalySubscriptionRequest build() {
            return new UpdateAnomalySubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
