/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSavingsPlansPurchaseRecommendationGenerationResponse extends CostExplorerResponse
        implements
        ToCopyableBuilder<StartSavingsPlansPurchaseRecommendationGenerationResponse.Builder, StartSavingsPlansPurchaseRecommendationGenerationResponse> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId")
            .getter(getter(StartSavingsPlansPurchaseRecommendationGenerationResponse::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> GENERATION_STARTED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationStartedTime")
            .getter(getter(StartSavingsPlansPurchaseRecommendationGenerationResponse::generationStartedTime))
            .setter(setter(Builder::generationStartedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStartedTime").build())
            .build();

    private static final SdkField<String> ESTIMATED_COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedCompletionTime")
            .getter(getter(StartSavingsPlansPurchaseRecommendationGenerationResponse::estimatedCompletionTime))
            .setter(setter(Builder::estimatedCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCompletionTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            GENERATION_STARTED_TIME_FIELD, ESTIMATED_COMPLETION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String recommendationId;

    private final String generationStartedTime;

    private final String estimatedCompletionTime;

    private StartSavingsPlansPurchaseRecommendationGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationId = builder.recommendationId;
        this.generationStartedTime = builder.generationStartedTime;
        this.estimatedCompletionTime = builder.estimatedCompletionTime;
    }

    /**
     * <p>
     * The ID for this specific recommendation.
     * </p>
     * 
     * @return The ID for this specific recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The start time of the recommendation generation.
     * </p>
     * 
     * @return The start time of the recommendation generation.
     */
    public final String generationStartedTime() {
        return generationStartedTime;
    }

    /**
     * <p>
     * The estimated time for when the recommendation generation will complete.
     * </p>
     * 
     * @return The estimated time for when the recommendation generation will complete.
     */
    public final String estimatedCompletionTime() {
        return estimatedCompletionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(generationStartedTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCompletionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSavingsPlansPurchaseRecommendationGenerationResponse)) {
            return false;
        }
        StartSavingsPlansPurchaseRecommendationGenerationResponse other = (StartSavingsPlansPurchaseRecommendationGenerationResponse) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(generationStartedTime(), other.generationStartedTime())
                && Objects.equals(estimatedCompletionTime(), other.estimatedCompletionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSavingsPlansPurchaseRecommendationGenerationResponse")
                .add("RecommendationId", recommendationId()).add("GenerationStartedTime", generationStartedTime())
                .add("EstimatedCompletionTime", estimatedCompletionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "GenerationStartedTime":
            return Optional.ofNullable(clazz.cast(generationStartedTime()));
        case "EstimatedCompletionTime":
            return Optional.ofNullable(clazz.cast(estimatedCompletionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("GenerationStartedTime", GENERATION_STARTED_TIME_FIELD);
        map.put("EstimatedCompletionTime", ESTIMATED_COMPLETION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSavingsPlansPurchaseRecommendationGenerationResponse, T> g) {
        return obj -> g.apply((StartSavingsPlansPurchaseRecommendationGenerationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartSavingsPlansPurchaseRecommendationGenerationResponse> {
        /**
         * <p>
         * The ID for this specific recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The ID for this specific recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The start time of the recommendation generation.
         * </p>
         * 
         * @param generationStartedTime
         *        The start time of the recommendation generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationStartedTime(String generationStartedTime);

        /**
         * <p>
         * The estimated time for when the recommendation generation will complete.
         * </p>
         * 
         * @param estimatedCompletionTime
         *        The estimated time for when the recommendation generation will complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCompletionTime(String estimatedCompletionTime);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String recommendationId;

        private String generationStartedTime;

        private String estimatedCompletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSavingsPlansPurchaseRecommendationGenerationResponse model) {
            super(model);
            recommendationId(model.recommendationId);
            generationStartedTime(model.generationStartedTime);
            estimatedCompletionTime(model.estimatedCompletionTime);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getGenerationStartedTime() {
            return generationStartedTime;
        }

        public final void setGenerationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
        }

        @Override
        public final Builder generationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
            return this;
        }

        public final String getEstimatedCompletionTime() {
            return estimatedCompletionTime;
        }

        public final void setEstimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
        }

        @Override
        public final Builder estimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
            return this;
        }

        @Override
        public StartSavingsPlansPurchaseRecommendationGenerationResponse build() {
            return new StartSavingsPlansPurchaseRecommendationGenerationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
