/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the Savings Plans purchase analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPurchaseAnalysisConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPurchaseAnalysisConfiguration.Builder, SavingsPlansPurchaseAnalysisConfiguration> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountScope").getter(getter(SavingsPlansPurchaseAnalysisConfiguration::accountScopeAsString))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(SavingsPlansPurchaseAnalysisConfiguration::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisType").getter(getter(SavingsPlansPurchaseAnalysisConfiguration::analysisTypeAsString))
            .setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()).build();

    private static final SdkField<List<SavingsPlans>> SAVINGS_PLANS_TO_ADD_FIELD = SdkField
            .<List<SavingsPlans>> builder(MarshallingType.LIST)
            .memberName("SavingsPlansToAdd")
            .getter(getter(SavingsPlansPurchaseAnalysisConfiguration::savingsPlansToAdd))
            .setter(setter(Builder::savingsPlansToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlans> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlans::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAVINGS_PLANS_TO_EXCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SavingsPlansToExclude")
            .getter(getter(SavingsPlansPurchaseAnalysisConfiguration::savingsPlansToExclude))
            .setter(setter(Builder::savingsPlansToExclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansToExclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DateInterval> LOOK_BACK_TIME_PERIOD_FIELD = SdkField
            .<DateInterval> builder(MarshallingType.SDK_POJO).memberName("LookBackTimePeriod")
            .getter(getter(SavingsPlansPurchaseAnalysisConfiguration::lookBackTimePeriod))
            .setter(setter(Builder::lookBackTimePeriod)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookBackTimePeriod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            ACCOUNT_ID_FIELD, ANALYSIS_TYPE_FIELD, SAVINGS_PLANS_TO_ADD_FIELD, SAVINGS_PLANS_TO_EXCLUDE_FIELD,
            LOOK_BACK_TIME_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String accountId;

    private final String analysisType;

    private final List<SavingsPlans> savingsPlansToAdd;

    private final List<String> savingsPlansToExclude;

    private final DateInterval lookBackTimePeriod;

    private SavingsPlansPurchaseAnalysisConfiguration(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.accountId = builder.accountId;
        this.analysisType = builder.analysisType;
        this.savingsPlansToAdd = builder.savingsPlansToAdd;
        this.savingsPlansToExclude = builder.savingsPlansToExclude;
        this.lookBackTimePeriod = builder.lookBackTimePeriod;
    }

    /**
     * <p>
     * The account scope that you want your analysis for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that you want your analysis for.
     * @see AccountScope
     */
    public final AccountScope accountScope() {
        return AccountScope.fromValue(accountScope);
    }

    /**
     * <p>
     * The account scope that you want your analysis for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that you want your analysis for.
     * @see AccountScope
     */
    public final String accountScopeAsString() {
        return accountScope;
    }

    /**
     * <p>
     * The account that the analysis is for.
     * </p>
     * 
     * @return The account that the analysis is for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The type of analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis.
     * @see AnalysisType
     */
    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * The type of analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis.
     * @see AnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SavingsPlansToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSavingsPlansToAdd() {
        return savingsPlansToAdd != null && !(savingsPlansToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Savings Plans to include in the analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSavingsPlansToAdd} method.
     * </p>
     * 
     * @return Savings Plans to include in the analysis.
     */
    public final List<SavingsPlans> savingsPlansToAdd() {
        return savingsPlansToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the SavingsPlansToExclude property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSavingsPlansToExclude() {
        return savingsPlansToExclude != null && !(savingsPlansToExclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Savings Plans to exclude from the analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSavingsPlansToExclude} method.
     * </p>
     * 
     * @return Savings Plans to exclude from the analysis.
     */
    public final List<String> savingsPlansToExclude() {
        return savingsPlansToExclude;
    }

    /**
     * <p>
     * The time period associated with the analysis.
     * </p>
     * 
     * @return The time period associated with the analysis.
     */
    public final DateInterval lookBackTimePeriod() {
        return lookBackTimePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlansToAdd() ? savingsPlansToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlansToExclude() ? savingsPlansToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lookBackTimePeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseAnalysisConfiguration)) {
            return false;
        }
        SavingsPlansPurchaseAnalysisConfiguration other = (SavingsPlansPurchaseAnalysisConfiguration) obj;
        return Objects.equals(accountScopeAsString(), other.accountScopeAsString())
                && Objects.equals(accountId(), other.accountId())
                && Objects.equals(analysisTypeAsString(), other.analysisTypeAsString())
                && hasSavingsPlansToAdd() == other.hasSavingsPlansToAdd()
                && Objects.equals(savingsPlansToAdd(), other.savingsPlansToAdd())
                && hasSavingsPlansToExclude() == other.hasSavingsPlansToExclude()
                && Objects.equals(savingsPlansToExclude(), other.savingsPlansToExclude())
                && Objects.equals(lookBackTimePeriod(), other.lookBackTimePeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansPurchaseAnalysisConfiguration").add("AccountScope", accountScopeAsString())
                .add("AccountId", accountId()).add("AnalysisType", analysisTypeAsString())
                .add("SavingsPlansToAdd", hasSavingsPlansToAdd() ? savingsPlansToAdd() : null)
                .add("SavingsPlansToExclude", hasSavingsPlansToExclude() ? savingsPlansToExclude() : null)
                .add("LookBackTimePeriod", lookBackTimePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountScope":
            return Optional.ofNullable(clazz.cast(accountScopeAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AnalysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        case "SavingsPlansToAdd":
            return Optional.ofNullable(clazz.cast(savingsPlansToAdd()));
        case "SavingsPlansToExclude":
            return Optional.ofNullable(clazz.cast(savingsPlansToExclude()));
        case "LookBackTimePeriod":
            return Optional.ofNullable(clazz.cast(lookBackTimePeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountScope", ACCOUNT_SCOPE_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AnalysisType", ANALYSIS_TYPE_FIELD);
        map.put("SavingsPlansToAdd", SAVINGS_PLANS_TO_ADD_FIELD);
        map.put("SavingsPlansToExclude", SAVINGS_PLANS_TO_EXCLUDE_FIELD);
        map.put("LookBackTimePeriod", LOOK_BACK_TIME_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseAnalysisConfiguration, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseAnalysisConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPurchaseAnalysisConfiguration> {
        /**
         * <p>
         * The account scope that you want your analysis for.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your analysis for.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The account scope that you want your analysis for.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your analysis for.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(AccountScope accountScope);

        /**
         * <p>
         * The account that the analysis is for.
         * </p>
         * 
         * @param accountId
         *        The account that the analysis is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The type of analysis.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * The type of analysis.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(AnalysisType analysisType);

        /**
         * <p>
         * Savings Plans to include in the analysis.
         * </p>
         * 
         * @param savingsPlansToAdd
         *        Savings Plans to include in the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansToAdd(Collection<SavingsPlans> savingsPlansToAdd);

        /**
         * <p>
         * Savings Plans to include in the analysis.
         * </p>
         * 
         * @param savingsPlansToAdd
         *        Savings Plans to include in the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansToAdd(SavingsPlans... savingsPlansToAdd);

        /**
         * <p>
         * Savings Plans to include in the analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlans.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlans#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlans.Builder#build()} is called immediately
         * and its result is passed to {@link #savingsPlansToAdd(List<SavingsPlans>)}.
         * 
         * @param savingsPlansToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlans.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansToAdd(java.util.Collection<SavingsPlans>)
         */
        Builder savingsPlansToAdd(Consumer<SavingsPlans.Builder>... savingsPlansToAdd);

        /**
         * <p>
         * Savings Plans to exclude from the analysis.
         * </p>
         * 
         * @param savingsPlansToExclude
         *        Savings Plans to exclude from the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansToExclude(Collection<String> savingsPlansToExclude);

        /**
         * <p>
         * Savings Plans to exclude from the analysis.
         * </p>
         * 
         * @param savingsPlansToExclude
         *        Savings Plans to exclude from the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansToExclude(String... savingsPlansToExclude);

        /**
         * <p>
         * The time period associated with the analysis.
         * </p>
         * 
         * @param lookBackTimePeriod
         *        The time period associated with the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookBackTimePeriod(DateInterval lookBackTimePeriod);

        /**
         * <p>
         * The time period associated with the analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #lookBackTimePeriod(DateInterval)}.
         * 
         * @param lookBackTimePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lookBackTimePeriod(DateInterval)
         */
        default Builder lookBackTimePeriod(Consumer<DateInterval.Builder> lookBackTimePeriod) {
            return lookBackTimePeriod(DateInterval.builder().applyMutation(lookBackTimePeriod).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String accountId;

        private String analysisType;

        private List<SavingsPlans> savingsPlansToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> savingsPlansToExclude = DefaultSdkAutoConstructList.getInstance();

        private DateInterval lookBackTimePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseAnalysisConfiguration model) {
            accountScope(model.accountScope);
            accountId(model.accountId);
            analysisType(model.analysisType);
            savingsPlansToAdd(model.savingsPlansToAdd);
            savingsPlansToExclude(model.savingsPlansToExclude);
            lookBackTimePeriod(model.lookBackTimePeriod);
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final List<SavingsPlans.Builder> getSavingsPlansToAdd() {
            List<SavingsPlans.Builder> result = SavingsPlansToAddCopier.copyToBuilder(this.savingsPlansToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSavingsPlansToAdd(Collection<SavingsPlans.BuilderImpl> savingsPlansToAdd) {
            this.savingsPlansToAdd = SavingsPlansToAddCopier.copyFromBuilder(savingsPlansToAdd);
        }

        @Override
        public final Builder savingsPlansToAdd(Collection<SavingsPlans> savingsPlansToAdd) {
            this.savingsPlansToAdd = SavingsPlansToAddCopier.copy(savingsPlansToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansToAdd(SavingsPlans... savingsPlansToAdd) {
            savingsPlansToAdd(Arrays.asList(savingsPlansToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansToAdd(Consumer<SavingsPlans.Builder>... savingsPlansToAdd) {
            savingsPlansToAdd(Stream.of(savingsPlansToAdd).map(c -> SavingsPlans.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSavingsPlansToExclude() {
            if (savingsPlansToExclude instanceof SdkAutoConstructList) {
                return null;
            }
            return savingsPlansToExclude;
        }

        public final void setSavingsPlansToExclude(Collection<String> savingsPlansToExclude) {
            this.savingsPlansToExclude = SavingsPlansToExcludeCopier.copy(savingsPlansToExclude);
        }

        @Override
        public final Builder savingsPlansToExclude(Collection<String> savingsPlansToExclude) {
            this.savingsPlansToExclude = SavingsPlansToExcludeCopier.copy(savingsPlansToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansToExclude(String... savingsPlansToExclude) {
            savingsPlansToExclude(Arrays.asList(savingsPlansToExclude));
            return this;
        }

        public final DateInterval.Builder getLookBackTimePeriod() {
            return lookBackTimePeriod != null ? lookBackTimePeriod.toBuilder() : null;
        }

        public final void setLookBackTimePeriod(DateInterval.BuilderImpl lookBackTimePeriod) {
            this.lookBackTimePeriod = lookBackTimePeriod != null ? lookBackTimePeriod.build() : null;
        }

        @Override
        public final Builder lookBackTimePeriod(DateInterval lookBackTimePeriod) {
            this.lookBackTimePeriod = lookBackTimePeriod;
            return this;
        }

        @Override
        public SavingsPlansPurchaseAnalysisConfiguration build() {
            return new SavingsPlansPurchaseAnalysisConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
