/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommitmentPurchaseAnalysisResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetCommitmentPurchaseAnalysisResponse.Builder, GetCommitmentPurchaseAnalysisResponse> {
    private static final SdkField<String> ESTIMATED_COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedCompletionTime").getter(getter(GetCommitmentPurchaseAnalysisResponse::estimatedCompletionTime))
            .setter(setter(Builder::estimatedCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCompletionTime").build())
            .build();

    private static final SdkField<String> ANALYSIS_COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisCompletionTime").getter(getter(GetCommitmentPurchaseAnalysisResponse::analysisCompletionTime))
            .setter(setter(Builder::analysisCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisCompletionTime").build())
            .build();

    private static final SdkField<String> ANALYSIS_STARTED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisStartedTime").getter(getter(GetCommitmentPurchaseAnalysisResponse::analysisStartedTime))
            .setter(setter(Builder::analysisStartedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartedTime").build())
            .build();

    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(GetCommitmentPurchaseAnalysisResponse::analysisId))
            .setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisStatus").getter(getter(GetCommitmentPurchaseAnalysisResponse::analysisStatusAsString))
            .setter(setter(Builder::analysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStatus").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(GetCommitmentPurchaseAnalysisResponse::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<AnalysisDetails> ANALYSIS_DETAILS_FIELD = SdkField
            .<AnalysisDetails> builder(MarshallingType.SDK_POJO).memberName("AnalysisDetails")
            .getter(getter(GetCommitmentPurchaseAnalysisResponse::analysisDetails)).setter(setter(Builder::analysisDetails))
            .constructor(AnalysisDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisDetails").build()).build();

    private static final SdkField<CommitmentPurchaseAnalysisConfiguration> COMMITMENT_PURCHASE_ANALYSIS_CONFIGURATION_FIELD = SdkField
            .<CommitmentPurchaseAnalysisConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CommitmentPurchaseAnalysisConfiguration")
            .getter(getter(GetCommitmentPurchaseAnalysisResponse::commitmentPurchaseAnalysisConfiguration))
            .setter(setter(Builder::commitmentPurchaseAnalysisConfiguration))
            .constructor(CommitmentPurchaseAnalysisConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CommitmentPurchaseAnalysisConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_COMPLETION_TIME_FIELD, ANALYSIS_COMPLETION_TIME_FIELD, ANALYSIS_STARTED_TIME_FIELD, ANALYSIS_ID_FIELD,
            ANALYSIS_STATUS_FIELD, ERROR_CODE_FIELD, ANALYSIS_DETAILS_FIELD, COMMITMENT_PURCHASE_ANALYSIS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String estimatedCompletionTime;

    private final String analysisCompletionTime;

    private final String analysisStartedTime;

    private final String analysisId;

    private final String analysisStatus;

    private final String errorCode;

    private final AnalysisDetails analysisDetails;

    private final CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration;

    private GetCommitmentPurchaseAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.estimatedCompletionTime = builder.estimatedCompletionTime;
        this.analysisCompletionTime = builder.analysisCompletionTime;
        this.analysisStartedTime = builder.analysisStartedTime;
        this.analysisId = builder.analysisId;
        this.analysisStatus = builder.analysisStatus;
        this.errorCode = builder.errorCode;
        this.analysisDetails = builder.analysisDetails;
        this.commitmentPurchaseAnalysisConfiguration = builder.commitmentPurchaseAnalysisConfiguration;
    }

    /**
     * <p>
     * The estimated time for when the analysis will complete.
     * </p>
     * 
     * @return The estimated time for when the analysis will complete.
     */
    public final String estimatedCompletionTime() {
        return estimatedCompletionTime;
    }

    /**
     * <p>
     * The completion time of the analysis.
     * </p>
     * 
     * @return The completion time of the analysis.
     */
    public final String analysisCompletionTime() {
        return analysisCompletionTime;
    }

    /**
     * <p>
     * The start time of the analysis.
     * </p>
     * 
     * @return The start time of the analysis.
     */
    public final String analysisStartedTime() {
        return analysisStartedTime;
    }

    /**
     * <p>
     * The analysis ID that's associated with the commitment purchase analysis.
     * </p>
     * 
     * @return The analysis ID that's associated with the commitment purchase analysis.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The status of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of the analysis.
     * @see AnalysisStatus
     */
    public final AnalysisStatus analysisStatus() {
        return AnalysisStatus.fromValue(analysisStatus);
    }

    /**
     * <p>
     * The status of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of the analysis.
     * @see AnalysisStatus
     */
    public final String analysisStatusAsString() {
        return analysisStatus;
    }

    /**
     * <p>
     * The error code used for the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code used for the analysis.
     * @see ErrorCode
     */
    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code used for the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code used for the analysis.
     * @see ErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * Details about the analysis.
     * </p>
     * 
     * @return Details about the analysis.
     */
    public final AnalysisDetails analysisDetails() {
        return analysisDetails;
    }

    /**
     * <p>
     * The configuration for the commitment purchase analysis.
     * </p>
     * 
     * @return The configuration for the commitment purchase analysis.
     */
    public final CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration() {
        return commitmentPurchaseAnalysisConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(analysisCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(analysisStartedTime());
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysisDetails());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentPurchaseAnalysisConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommitmentPurchaseAnalysisResponse)) {
            return false;
        }
        GetCommitmentPurchaseAnalysisResponse other = (GetCommitmentPurchaseAnalysisResponse) obj;
        return Objects.equals(estimatedCompletionTime(), other.estimatedCompletionTime())
                && Objects.equals(analysisCompletionTime(), other.analysisCompletionTime())
                && Objects.equals(analysisStartedTime(), other.analysisStartedTime())
                && Objects.equals(analysisId(), other.analysisId())
                && Objects.equals(analysisStatusAsString(), other.analysisStatusAsString())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(analysisDetails(), other.analysisDetails())
                && Objects.equals(commitmentPurchaseAnalysisConfiguration(), other.commitmentPurchaseAnalysisConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommitmentPurchaseAnalysisResponse")
                .add("EstimatedCompletionTime", estimatedCompletionTime())
                .add("AnalysisCompletionTime", analysisCompletionTime()).add("AnalysisStartedTime", analysisStartedTime())
                .add("AnalysisId", analysisId()).add("AnalysisStatus", analysisStatusAsString())
                .add("ErrorCode", errorCodeAsString()).add("AnalysisDetails", analysisDetails())
                .add("CommitmentPurchaseAnalysisConfiguration", commitmentPurchaseAnalysisConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EstimatedCompletionTime":
            return Optional.ofNullable(clazz.cast(estimatedCompletionTime()));
        case "AnalysisCompletionTime":
            return Optional.ofNullable(clazz.cast(analysisCompletionTime()));
        case "AnalysisStartedTime":
            return Optional.ofNullable(clazz.cast(analysisStartedTime()));
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "AnalysisStatus":
            return Optional.ofNullable(clazz.cast(analysisStatusAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "AnalysisDetails":
            return Optional.ofNullable(clazz.cast(analysisDetails()));
        case "CommitmentPurchaseAnalysisConfiguration":
            return Optional.ofNullable(clazz.cast(commitmentPurchaseAnalysisConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EstimatedCompletionTime", ESTIMATED_COMPLETION_TIME_FIELD);
        map.put("AnalysisCompletionTime", ANALYSIS_COMPLETION_TIME_FIELD);
        map.put("AnalysisStartedTime", ANALYSIS_STARTED_TIME_FIELD);
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("AnalysisStatus", ANALYSIS_STATUS_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("AnalysisDetails", ANALYSIS_DETAILS_FIELD);
        map.put("CommitmentPurchaseAnalysisConfiguration", COMMITMENT_PURCHASE_ANALYSIS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommitmentPurchaseAnalysisResponse, T> g) {
        return obj -> g.apply((GetCommitmentPurchaseAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCommitmentPurchaseAnalysisResponse> {
        /**
         * <p>
         * The estimated time for when the analysis will complete.
         * </p>
         * 
         * @param estimatedCompletionTime
         *        The estimated time for when the analysis will complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCompletionTime(String estimatedCompletionTime);

        /**
         * <p>
         * The completion time of the analysis.
         * </p>
         * 
         * @param analysisCompletionTime
         *        The completion time of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisCompletionTime(String analysisCompletionTime);

        /**
         * <p>
         * The start time of the analysis.
         * </p>
         * 
         * @param analysisStartedTime
         *        The start time of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisStartedTime(String analysisStartedTime);

        /**
         * <p>
         * The analysis ID that's associated with the commitment purchase analysis.
         * </p>
         * 
         * @param analysisId
         *        The analysis ID that's associated with the commitment purchase analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The status of the analysis.
         * </p>
         * 
         * @param analysisStatus
         *        The status of the analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder analysisStatus(String analysisStatus);

        /**
         * <p>
         * The status of the analysis.
         * </p>
         * 
         * @param analysisStatus
         *        The status of the analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder analysisStatus(AnalysisStatus analysisStatus);

        /**
         * <p>
         * The error code used for the analysis.
         * </p>
         * 
         * @param errorCode
         *        The error code used for the analysis.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code used for the analysis.
         * </p>
         * 
         * @param errorCode
         *        The error code used for the analysis.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(ErrorCode errorCode);

        /**
         * <p>
         * Details about the analysis.
         * </p>
         * 
         * @param analysisDetails
         *        Details about the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisDetails(AnalysisDetails analysisDetails);

        /**
         * <p>
         * Details about the analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisDetails.Builder} avoiding the
         * need to create one manually via {@link AnalysisDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #analysisDetails(AnalysisDetails)}.
         * 
         * @param analysisDetails
         *        a consumer that will call methods on {@link AnalysisDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisDetails(AnalysisDetails)
         */
        default Builder analysisDetails(Consumer<AnalysisDetails.Builder> analysisDetails) {
            return analysisDetails(AnalysisDetails.builder().applyMutation(analysisDetails).build());
        }

        /**
         * <p>
         * The configuration for the commitment purchase analysis.
         * </p>
         * 
         * @param commitmentPurchaseAnalysisConfiguration
         *        The configuration for the commitment purchase analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentPurchaseAnalysisConfiguration(
                CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration);

        /**
         * <p>
         * The configuration for the commitment purchase analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CommitmentPurchaseAnalysisConfiguration.Builder} avoiding the need to create one manually via
         * {@link CommitmentPurchaseAnalysisConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommitmentPurchaseAnalysisConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #commitmentPurchaseAnalysisConfiguration(CommitmentPurchaseAnalysisConfiguration)}.
         * 
         * @param commitmentPurchaseAnalysisConfiguration
         *        a consumer that will call methods on {@link CommitmentPurchaseAnalysisConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentPurchaseAnalysisConfiguration(CommitmentPurchaseAnalysisConfiguration)
         */
        default Builder commitmentPurchaseAnalysisConfiguration(
                Consumer<CommitmentPurchaseAnalysisConfiguration.Builder> commitmentPurchaseAnalysisConfiguration) {
            return commitmentPurchaseAnalysisConfiguration(CommitmentPurchaseAnalysisConfiguration.builder()
                    .applyMutation(commitmentPurchaseAnalysisConfiguration).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String estimatedCompletionTime;

        private String analysisCompletionTime;

        private String analysisStartedTime;

        private String analysisId;

        private String analysisStatus;

        private String errorCode;

        private AnalysisDetails analysisDetails;

        private CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommitmentPurchaseAnalysisResponse model) {
            super(model);
            estimatedCompletionTime(model.estimatedCompletionTime);
            analysisCompletionTime(model.analysisCompletionTime);
            analysisStartedTime(model.analysisStartedTime);
            analysisId(model.analysisId);
            analysisStatus(model.analysisStatus);
            errorCode(model.errorCode);
            analysisDetails(model.analysisDetails);
            commitmentPurchaseAnalysisConfiguration(model.commitmentPurchaseAnalysisConfiguration);
        }

        public final String getEstimatedCompletionTime() {
            return estimatedCompletionTime;
        }

        public final void setEstimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
        }

        @Override
        public final Builder estimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
            return this;
        }

        public final String getAnalysisCompletionTime() {
            return analysisCompletionTime;
        }

        public final void setAnalysisCompletionTime(String analysisCompletionTime) {
            this.analysisCompletionTime = analysisCompletionTime;
        }

        @Override
        public final Builder analysisCompletionTime(String analysisCompletionTime) {
            this.analysisCompletionTime = analysisCompletionTime;
            return this;
        }

        public final String getAnalysisStartedTime() {
            return analysisStartedTime;
        }

        public final void setAnalysisStartedTime(String analysisStartedTime) {
            this.analysisStartedTime = analysisStartedTime;
        }

        @Override
        public final Builder analysisStartedTime(String analysisStartedTime) {
            this.analysisStartedTime = analysisStartedTime;
            return this;
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getAnalysisStatus() {
            return analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final AnalysisDetails.Builder getAnalysisDetails() {
            return analysisDetails != null ? analysisDetails.toBuilder() : null;
        }

        public final void setAnalysisDetails(AnalysisDetails.BuilderImpl analysisDetails) {
            this.analysisDetails = analysisDetails != null ? analysisDetails.build() : null;
        }

        @Override
        public final Builder analysisDetails(AnalysisDetails analysisDetails) {
            this.analysisDetails = analysisDetails;
            return this;
        }

        public final CommitmentPurchaseAnalysisConfiguration.Builder getCommitmentPurchaseAnalysisConfiguration() {
            return commitmentPurchaseAnalysisConfiguration != null ? commitmentPurchaseAnalysisConfiguration.toBuilder() : null;
        }

        public final void setCommitmentPurchaseAnalysisConfiguration(
                CommitmentPurchaseAnalysisConfiguration.BuilderImpl commitmentPurchaseAnalysisConfiguration) {
            this.commitmentPurchaseAnalysisConfiguration = commitmentPurchaseAnalysisConfiguration != null ? commitmentPurchaseAnalysisConfiguration
                    .build() : null;
        }

        @Override
        public final Builder commitmentPurchaseAnalysisConfiguration(
                CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration) {
            this.commitmentPurchaseAnalysisConfiguration = commitmentPurchaseAnalysisConfiguration;
            return this;
        }

        @Override
        public GetCommitmentPurchaseAnalysisResponse build() {
            return new GetCommitmentPurchaseAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
