/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2Specification implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2Specification.Builder, EC2Specification> {
    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingClass").getter(getter(EC2Specification::offeringClassAsString))
            .setter(setter(Builder::offeringClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_CLASS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String offeringClass;

    private EC2Specification(BuilderImpl builder) {
        this.offeringClass = builder.offeringClass;
    }

    /**
     * <p>
     * Indicates whether you want a recommendation for standard or convertible reservations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringClassAsString}.
     * </p>
     * 
     * @return Indicates whether you want a recommendation for standard or convertible reservations.
     * @see OfferingClass
     */
    public final OfferingClass offeringClass() {
        return OfferingClass.fromValue(offeringClass);
    }

    /**
     * <p>
     * Indicates whether you want a recommendation for standard or convertible reservations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringClassAsString}.
     * </p>
     * 
     * @return Indicates whether you want a recommendation for standard or convertible reservations.
     * @see OfferingClass
     */
    public final String offeringClassAsString() {
        return offeringClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2Specification)) {
            return false;
        }
        EC2Specification other = (EC2Specification) obj;
        return Objects.equals(offeringClassAsString(), other.offeringClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2Specification").add("OfferingClass", offeringClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OfferingClass":
            return Optional.ofNullable(clazz.cast(offeringClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OfferingClass", OFFERING_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2Specification, T> g) {
        return obj -> g.apply((EC2Specification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2Specification> {
        /**
         * <p>
         * Indicates whether you want a recommendation for standard or convertible reservations.
         * </p>
         * 
         * @param offeringClass
         *        Indicates whether you want a recommendation for standard or convertible reservations.
         * @see OfferingClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClass
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * Indicates whether you want a recommendation for standard or convertible reservations.
         * </p>
         * 
         * @param offeringClass
         *        Indicates whether you want a recommendation for standard or convertible reservations.
         * @see OfferingClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClass
         */
        Builder offeringClass(OfferingClass offeringClass);
    }

    static final class BuilderImpl implements Builder {
        private String offeringClass;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2Specification model) {
            offeringClass(model.offeringClass);
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClass offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        @Override
        public EC2Specification build() {
            return new EC2Specification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
