/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is
 * used to determine that Cost Category value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategoryRule implements SdkPojo, Serializable,
        ToCopyableBuilder<CostCategoryRule.Builder, CostCategoryRule> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(CostCategoryRule::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Expression> RULE_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Rule").getter(getter(CostCategoryRule::rule)).setter(setter(Builder::rule))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final SdkField<CostCategoryInheritedValueDimension> INHERITED_VALUE_FIELD = SdkField
            .<CostCategoryInheritedValueDimension> builder(MarshallingType.SDK_POJO).memberName("InheritedValue")
            .getter(getter(CostCategoryRule::inheritedValue)).setter(setter(Builder::inheritedValue))
            .constructor(CostCategoryInheritedValueDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InheritedValue").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CostCategoryRule::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, RULE_FIELD,
            INHERITED_VALUE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final Expression rule;

    private final CostCategoryInheritedValueDimension inheritedValue;

    private final String type;

    private CostCategoryRule(BuilderImpl builder) {
        this.value = builder.value;
        this.rule = builder.rule;
        this.inheritedValue = builder.inheritedValue;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * An <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
     * object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only
     * dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>,
     * <code>LINKED_ACCOUNT_NAME</code>, <code>REGION</code>, and <code>USAGE_TYPE</code>.
     * </p>
     * <p>
     * <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost Category
     * expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON
     * editor. For a detailed comparison, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms"
     * >Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * 
     * @return An <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression
     *         </a> object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently
     *         the only dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>,
     *         <code>RECORD_TYPE</code>, <code>LINKED_ACCOUNT_NAME</code>, <code>REGION</code>, and
     *         <code>USAGE_TYPE</code>.</p>
     *         <p>
     *         <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost
     *         Category expressions. This dimension uses different terms, depending on whether you're using the console
     *         or API/JSON editor. For a detailed comparison, see <a href=
     *         "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms"
     *         >Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.
     */
    public final Expression rule() {
        return rule;
    }

    /**
     * <p>
     * The value the line item is categorized as if the line item contains the matched dimension.
     * </p>
     * 
     * @return The value the line item is categorized as if the line item contains the matched dimension.
     */
    public final CostCategoryInheritedValueDimension inheritedValue() {
        return inheritedValue;
    }

    /**
     * <p>
     * You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
     * <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to define a rule
     * that dynamically inherits the cost category value. This value is from the dimension value that's defined by
     * <code>CostCategoryInheritedValueDimension</code>. For example, suppose that you want to costs to be dynamically
     * grouped based on the value of a specific tag key. First, choose an inherited value rule type, and then choose the
     * tag dimension and specify the tag key to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CostCategoryRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
     *         <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to define a
     *         rule that dynamically inherits the cost category value. This value is from the dimension value that's
     *         defined by <code>CostCategoryInheritedValueDimension</code>. For example, suppose that you want to costs
     *         to be dynamically grouped based on the value of a specific tag key. First, choose an inherited value rule
     *         type, and then choose the tag dimension and specify the tag key to use.
     * @see CostCategoryRuleType
     */
    public final CostCategoryRuleType type() {
        return CostCategoryRuleType.fromValue(type);
    }

    /**
     * <p>
     * You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
     * <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to define a rule
     * that dynamically inherits the cost category value. This value is from the dimension value that's defined by
     * <code>CostCategoryInheritedValueDimension</code>. For example, suppose that you want to costs to be dynamically
     * grouped based on the value of a specific tag key. First, choose an inherited value rule type, and then choose the
     * tag dimension and specify the tag key to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CostCategoryRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
     *         <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to define a
     *         rule that dynamically inherits the cost category value. This value is from the dimension value that's
     *         defined by <code>CostCategoryInheritedValueDimension</code>. For example, suppose that you want to costs
     *         to be dynamically grouped based on the value of a specific tag key. First, choose an inherited value rule
     *         type, and then choose the tag dimension and specify the tag key to use.
     * @see CostCategoryRuleType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(inheritedValue());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryRule)) {
            return false;
        }
        CostCategoryRule other = (CostCategoryRule) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(rule(), other.rule())
                && Objects.equals(inheritedValue(), other.inheritedValue())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostCategoryRule").add("Value", value()).add("Rule", rule())
                .add("InheritedValue", inheritedValue()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "InheritedValue":
            return Optional.ofNullable(clazz.cast(inheritedValue()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("InheritedValue", INHERITED_VALUE_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryRule, T> g) {
        return obj -> g.apply((CostCategoryRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategoryRule> {
        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * An <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only
         * dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>,
         * <code>LINKED_ACCOUNT_NAME</code>, <code>REGION</code>, and <code>USAGE_TYPE</code>.
         * </p>
         * <p>
         * <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost Category
         * expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON
         * editor. For a detailed comparison, see <a href=
         * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms"
         * >Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param rule
         *        An <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">
         *        Expression</a> object used to categorize costs. This supports dimensions, tags, and nested
         *        expressions. Currently the only dimensions supported are <code>LINKED_ACCOUNT</code>,
         *        <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>, <code>LINKED_ACCOUNT_NAME</code>,
         *        <code>REGION</code>, and <code>USAGE_TYPE</code>.</p>
         *        <p>
         *        <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost
         *        Category expressions. This dimension uses different terms, depending on whether you're using the
         *        console or API/JSON editor. For a detailed comparison, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms"
         *        >Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(Expression rule);

        /**
         * <p>
         * An <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only
         * dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>,
         * <code>LINKED_ACCOUNT_NAME</code>, <code>REGION</code>, and <code>USAGE_TYPE</code>.
         * </p>
         * <p>
         * <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost Category
         * expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON
         * editor. For a detailed comparison, see <a href=
         * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms"
         * >Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #rule(Expression)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(Expression)
         */
        default Builder rule(Consumer<Expression.Builder> rule) {
            return rule(Expression.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * The value the line item is categorized as if the line item contains the matched dimension.
         * </p>
         * 
         * @param inheritedValue
         *        The value the line item is categorized as if the line item contains the matched dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inheritedValue(CostCategoryInheritedValueDimension inheritedValue);

        /**
         * <p>
         * The value the line item is categorized as if the line item contains the matched dimension.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CostCategoryInheritedValueDimension.Builder} avoiding the need to create one manually via
         * {@link CostCategoryInheritedValueDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostCategoryInheritedValueDimension.Builder#build()} is called
         * immediately and its result is passed to {@link #inheritedValue(CostCategoryInheritedValueDimension)}.
         * 
         * @param inheritedValue
         *        a consumer that will call methods on {@link CostCategoryInheritedValueDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inheritedValue(CostCategoryInheritedValueDimension)
         */
        default Builder inheritedValue(Consumer<CostCategoryInheritedValueDimension.Builder> inheritedValue) {
            return inheritedValue(CostCategoryInheritedValueDimension.builder().applyMutation(inheritedValue).build());
        }

        /**
         * <p>
         * You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
         * <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to define a
         * rule that dynamically inherits the cost category value. This value is from the dimension value that's defined
         * by <code>CostCategoryInheritedValueDimension</code>. For example, suppose that you want to costs to be
         * dynamically grouped based on the value of a specific tag key. First, choose an inherited value rule type, and
         * then choose the tag dimension and specify the tag key to use.
         * </p>
         * 
         * @param type
         *        You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
         *        <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to
         *        define a rule that dynamically inherits the cost category value. This value is from the dimension
         *        value that's defined by <code>CostCategoryInheritedValueDimension</code>. For example, suppose that
         *        you want to costs to be dynamically grouped based on the value of a specific tag key. First, choose an
         *        inherited value rule type, and then choose the tag dimension and specify the tag key to use.
         * @see CostCategoryRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
         * <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to define a
         * rule that dynamically inherits the cost category value. This value is from the dimension value that's defined
         * by <code>CostCategoryInheritedValueDimension</code>. For example, suppose that you want to costs to be
         * dynamically grouped based on the value of a specific tag key. First, choose an inherited value rule type, and
         * then choose the tag dimension and specify the tag key to use.
         * </p>
         * 
         * @param type
         *        You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or
         *        <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility to
         *        define a rule that dynamically inherits the cost category value. This value is from the dimension
         *        value that's defined by <code>CostCategoryInheritedValueDimension</code>. For example, suppose that
         *        you want to costs to be dynamically grouped based on the value of a specific tag key. First, choose an
         *        inherited value rule type, and then choose the tag dimension and specify the tag key to use.
         * @see CostCategoryRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleType
         */
        Builder type(CostCategoryRuleType type);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private Expression rule;

        private CostCategoryInheritedValueDimension inheritedValue;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryRule model) {
            value(model.value);
            rule(model.rule);
            inheritedValue(model.inheritedValue);
            type(model.type);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Expression.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(Expression.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Expression rule) {
            this.rule = rule;
            return this;
        }

        public final CostCategoryInheritedValueDimension.Builder getInheritedValue() {
            return inheritedValue != null ? inheritedValue.toBuilder() : null;
        }

        public final void setInheritedValue(CostCategoryInheritedValueDimension.BuilderImpl inheritedValue) {
            this.inheritedValue = inheritedValue != null ? inheritedValue.build() : null;
        }

        @Override
        public final Builder inheritedValue(CostCategoryInheritedValueDimension inheritedValue) {
            this.inheritedValue = inheritedValue;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CostCategoryRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public CostCategoryRule build() {
            return new CostCategoryRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
