/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains cost or usage metric values for comparing two time periods. Each value includes amounts for the baseline and
 * comparison time periods, their difference, and the unit of measurement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComparisonMetricValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ComparisonMetricValue.Builder, ComparisonMetricValue> {
    private static final SdkField<String> BASELINE_TIME_PERIOD_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaselineTimePeriodAmount").getter(getter(ComparisonMetricValue::baselineTimePeriodAmount))
            .setter(setter(Builder::baselineTimePeriodAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineTimePeriodAmount").build())
            .build();

    private static final SdkField<String> COMPARISON_TIME_PERIOD_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ComparisonTimePeriodAmount")
            .getter(getter(ComparisonMetricValue::comparisonTimePeriodAmount))
            .setter(setter(Builder::comparisonTimePeriodAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonTimePeriodAmount").build())
            .build();

    private static final SdkField<String> DIFFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Difference").getter(getter(ComparisonMetricValue::difference)).setter(setter(Builder::difference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Difference").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(ComparisonMetricValue::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BASELINE_TIME_PERIOD_AMOUNT_FIELD, COMPARISON_TIME_PERIOD_AMOUNT_FIELD, DIFFERENCE_FIELD, UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baselineTimePeriodAmount;

    private final String comparisonTimePeriodAmount;

    private final String difference;

    private final String unit;

    private ComparisonMetricValue(BuilderImpl builder) {
        this.baselineTimePeriodAmount = builder.baselineTimePeriodAmount;
        this.comparisonTimePeriodAmount = builder.comparisonTimePeriodAmount;
        this.difference = builder.difference;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The numeric value for the baseline time period measurement.
     * </p>
     * 
     * @return The numeric value for the baseline time period measurement.
     */
    public final String baselineTimePeriodAmount() {
        return baselineTimePeriodAmount;
    }

    /**
     * <p>
     * The numeric value for the comparison time period measurement.
     * </p>
     * 
     * @return The numeric value for the comparison time period measurement.
     */
    public final String comparisonTimePeriodAmount() {
        return comparisonTimePeriodAmount;
    }

    /**
     * <p>
     * The calculated difference between <code>ComparisonTimePeriodAmount</code> and
     * <code>BaselineTimePeriodAmount</code>.
     * </p>
     * 
     * @return The calculated difference between <code>ComparisonTimePeriodAmount</code> and
     *         <code>BaselineTimePeriodAmount</code>.
     */
    public final String difference() {
        return difference;
    }

    /**
     * <p>
     * The unit of measurement applicable to all numeric values in this comparison.
     * </p>
     * 
     * @return The unit of measurement applicable to all numeric values in this comparison.
     */
    public final String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineTimePeriodAmount());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonTimePeriodAmount());
        hashCode = 31 * hashCode + Objects.hashCode(difference());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparisonMetricValue)) {
            return false;
        }
        ComparisonMetricValue other = (ComparisonMetricValue) obj;
        return Objects.equals(baselineTimePeriodAmount(), other.baselineTimePeriodAmount())
                && Objects.equals(comparisonTimePeriodAmount(), other.comparisonTimePeriodAmount())
                && Objects.equals(difference(), other.difference()) && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComparisonMetricValue").add("BaselineTimePeriodAmount", baselineTimePeriodAmount())
                .add("ComparisonTimePeriodAmount", comparisonTimePeriodAmount()).add("Difference", difference())
                .add("Unit", unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineTimePeriodAmount":
            return Optional.ofNullable(clazz.cast(baselineTimePeriodAmount()));
        case "ComparisonTimePeriodAmount":
            return Optional.ofNullable(clazz.cast(comparisonTimePeriodAmount()));
        case "Difference":
            return Optional.ofNullable(clazz.cast(difference()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaselineTimePeriodAmount", BASELINE_TIME_PERIOD_AMOUNT_FIELD);
        map.put("ComparisonTimePeriodAmount", COMPARISON_TIME_PERIOD_AMOUNT_FIELD);
        map.put("Difference", DIFFERENCE_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComparisonMetricValue, T> g) {
        return obj -> g.apply((ComparisonMetricValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComparisonMetricValue> {
        /**
         * <p>
         * The numeric value for the baseline time period measurement.
         * </p>
         * 
         * @param baselineTimePeriodAmount
         *        The numeric value for the baseline time period measurement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineTimePeriodAmount(String baselineTimePeriodAmount);

        /**
         * <p>
         * The numeric value for the comparison time period measurement.
         * </p>
         * 
         * @param comparisonTimePeriodAmount
         *        The numeric value for the comparison time period measurement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonTimePeriodAmount(String comparisonTimePeriodAmount);

        /**
         * <p>
         * The calculated difference between <code>ComparisonTimePeriodAmount</code> and
         * <code>BaselineTimePeriodAmount</code>.
         * </p>
         * 
         * @param difference
         *        The calculated difference between <code>ComparisonTimePeriodAmount</code> and
         *        <code>BaselineTimePeriodAmount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder difference(String difference);

        /**
         * <p>
         * The unit of measurement applicable to all numeric values in this comparison.
         * </p>
         * 
         * @param unit
         *        The unit of measurement applicable to all numeric values in this comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private String baselineTimePeriodAmount;

        private String comparisonTimePeriodAmount;

        private String difference;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparisonMetricValue model) {
            baselineTimePeriodAmount(model.baselineTimePeriodAmount);
            comparisonTimePeriodAmount(model.comparisonTimePeriodAmount);
            difference(model.difference);
            unit(model.unit);
        }

        public final String getBaselineTimePeriodAmount() {
            return baselineTimePeriodAmount;
        }

        public final void setBaselineTimePeriodAmount(String baselineTimePeriodAmount) {
            this.baselineTimePeriodAmount = baselineTimePeriodAmount;
        }

        @Override
        public final Builder baselineTimePeriodAmount(String baselineTimePeriodAmount) {
            this.baselineTimePeriodAmount = baselineTimePeriodAmount;
            return this;
        }

        public final String getComparisonTimePeriodAmount() {
            return comparisonTimePeriodAmount;
        }

        public final void setComparisonTimePeriodAmount(String comparisonTimePeriodAmount) {
            this.comparisonTimePeriodAmount = comparisonTimePeriodAmount;
        }

        @Override
        public final Builder comparisonTimePeriodAmount(String comparisonTimePeriodAmount) {
            this.comparisonTimePeriodAmount = comparisonTimePeriodAmount;
            return this;
        }

        public final String getDifference() {
            return difference;
        }

        public final void setDifference(String difference) {
            this.difference = difference;
        }

        @Override
        public final Builder difference(String difference) {
            this.difference = difference;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public ComparisonMetricValue build() {
            return new ComparisonMetricValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
