/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisDetails implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisDetails.Builder, AnalysisDetails> {
    private static final SdkField<SavingsPlansPurchaseAnalysisDetails> SAVINGS_PLANS_PURCHASE_ANALYSIS_DETAILS_FIELD = SdkField
            .<SavingsPlansPurchaseAnalysisDetails> builder(MarshallingType.SDK_POJO)
            .memberName("SavingsPlansPurchaseAnalysisDetails")
            .getter(getter(AnalysisDetails::savingsPlansPurchaseAnalysisDetails))
            .setter(setter(Builder::savingsPlansPurchaseAnalysisDetails))
            .constructor(SavingsPlansPurchaseAnalysisDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SavingsPlansPurchaseAnalysisDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SAVINGS_PLANS_PURCHASE_ANALYSIS_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SavingsPlansPurchaseAnalysisDetails savingsPlansPurchaseAnalysisDetails;

    private AnalysisDetails(BuilderImpl builder) {
        this.savingsPlansPurchaseAnalysisDetails = builder.savingsPlansPurchaseAnalysisDetails;
    }

    /**
     * <p>
     * Details about the Savings Plans purchase analysis.
     * </p>
     * 
     * @return Details about the Savings Plans purchase analysis.
     */
    public final SavingsPlansPurchaseAnalysisDetails savingsPlansPurchaseAnalysisDetails() {
        return savingsPlansPurchaseAnalysisDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansPurchaseAnalysisDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisDetails)) {
            return false;
        }
        AnalysisDetails other = (AnalysisDetails) obj;
        return Objects.equals(savingsPlansPurchaseAnalysisDetails(), other.savingsPlansPurchaseAnalysisDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisDetails")
                .add("SavingsPlansPurchaseAnalysisDetails", savingsPlansPurchaseAnalysisDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansPurchaseAnalysisDetails":
            return Optional.ofNullable(clazz.cast(savingsPlansPurchaseAnalysisDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SavingsPlansPurchaseAnalysisDetails", SAVINGS_PLANS_PURCHASE_ANALYSIS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisDetails, T> g) {
        return obj -> g.apply((AnalysisDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisDetails> {
        /**
         * <p>
         * Details about the Savings Plans purchase analysis.
         * </p>
         * 
         * @param savingsPlansPurchaseAnalysisDetails
         *        Details about the Savings Plans purchase analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansPurchaseAnalysisDetails(SavingsPlansPurchaseAnalysisDetails savingsPlansPurchaseAnalysisDetails);

        /**
         * <p>
         * Details about the Savings Plans purchase analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SavingsPlansPurchaseAnalysisDetails.Builder} avoiding the need to create one manually via
         * {@link SavingsPlansPurchaseAnalysisDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansPurchaseAnalysisDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #savingsPlansPurchaseAnalysisDetails(SavingsPlansPurchaseAnalysisDetails)}.
         * 
         * @param savingsPlansPurchaseAnalysisDetails
         *        a consumer that will call methods on {@link SavingsPlansPurchaseAnalysisDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansPurchaseAnalysisDetails(SavingsPlansPurchaseAnalysisDetails)
         */
        default Builder savingsPlansPurchaseAnalysisDetails(
                Consumer<SavingsPlansPurchaseAnalysisDetails.Builder> savingsPlansPurchaseAnalysisDetails) {
            return savingsPlansPurchaseAnalysisDetails(SavingsPlansPurchaseAnalysisDetails.builder()
                    .applyMutation(savingsPlansPurchaseAnalysisDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SavingsPlansPurchaseAnalysisDetails savingsPlansPurchaseAnalysisDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisDetails model) {
            savingsPlansPurchaseAnalysisDetails(model.savingsPlansPurchaseAnalysisDetails);
        }

        public final SavingsPlansPurchaseAnalysisDetails.Builder getSavingsPlansPurchaseAnalysisDetails() {
            return savingsPlansPurchaseAnalysisDetails != null ? savingsPlansPurchaseAnalysisDetails.toBuilder() : null;
        }

        public final void setSavingsPlansPurchaseAnalysisDetails(
                SavingsPlansPurchaseAnalysisDetails.BuilderImpl savingsPlansPurchaseAnalysisDetails) {
            this.savingsPlansPurchaseAnalysisDetails = savingsPlansPurchaseAnalysisDetails != null ? savingsPlansPurchaseAnalysisDetails
                    .build() : null;
        }

        @Override
        public final Builder savingsPlansPurchaseAnalysisDetails(
                SavingsPlansPurchaseAnalysisDetails savingsPlansPurchaseAnalysisDetails) {
            this.savingsPlansPurchaseAnalysisDetails = savingsPlansPurchaseAnalysisDetails;
            return this;
        }

        @Override
        public AnalysisDetails build() {
            return new AnalysisDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
