/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostComparisonDriver;
import software.amazon.awssdk.services.costexplorer.model.GetCostComparisonDriversRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostComparisonDriversResponse;

public class GetCostComparisonDriversIterable
implements SdkIterable<GetCostComparisonDriversResponse> {
    private final CostExplorerClient client;
    private final GetCostComparisonDriversRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCostComparisonDriversIterable(CostExplorerClient client, GetCostComparisonDriversRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCostComparisonDriversResponseFetcher();
    }

    public Iterator<GetCostComparisonDriversResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CostComparisonDriver> costComparisonDrivers() {
        Function<GetCostComparisonDriversResponse, Iterator> getIterator = response -> {
            if (response != null && response.costComparisonDrivers() != null) {
                return response.costComparisonDrivers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCostComparisonDriversResponseFetcher
    implements SyncPageFetcher<GetCostComparisonDriversResponse> {
        private GetCostComparisonDriversResponseFetcher() {
        }

        public boolean hasNextPage(GetCostComparisonDriversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetCostComparisonDriversResponse nextPage(GetCostComparisonDriversResponse previousPage) {
            if (previousPage == null) {
                return GetCostComparisonDriversIterable.this.client.getCostComparisonDrivers(GetCostComparisonDriversIterable.this.firstRequest);
            }
            return GetCostComparisonDriversIterable.this.client.getCostComparisonDrivers((GetCostComparisonDriversRequest)((Object)GetCostComparisonDriversIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

