/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.ApproximateUsageRecordsPerServiceCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApproximateUsageRecordsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetApproximateUsageRecordsResponse> {
    private static final SdkField<Map<String, Long>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Services").getter(GetApproximateUsageRecordsResponse.getter(GetApproximateUsageRecordsResponse::services)).setter(GetApproximateUsageRecordsResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalRecords").getter(GetApproximateUsageRecordsResponse.getter(GetApproximateUsageRecordsResponse::totalRecords)).setter(GetApproximateUsageRecordsResponse.setter(Builder::totalRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecords").build()}).build();
    private static final SdkField<DateInterval> LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LookbackPeriod").getter(GetApproximateUsageRecordsResponse.getter(GetApproximateUsageRecordsResponse::lookbackPeriod)).setter(GetApproximateUsageRecordsResponse.setter(Builder::lookbackPeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD, TOTAL_RECORDS_FIELD, LOOKBACK_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApproximateUsageRecordsResponse.memberNameToFieldInitializer();
    private final Map<String, Long> services;
    private final Long totalRecords;
    private final DateInterval lookbackPeriod;

    private GetApproximateUsageRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.totalRecords = builder.totalRecords;
        this.lookbackPeriod = builder.lookbackPeriod;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> services() {
        return this.services;
    }

    public final Long totalRecords() {
        return this.totalRecords;
    }

    public final DateInterval lookbackPeriod() {
        return this.lookbackPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApproximateUsageRecordsResponse)) {
            return false;
        }
        GetApproximateUsageRecordsResponse other = (GetApproximateUsageRecordsResponse)((Object)obj);
        return this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.totalRecords(), other.totalRecords()) && Objects.equals(this.lookbackPeriod(), other.lookbackPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"GetApproximateUsageRecordsResponse").add("Services", this.hasServices() ? this.services() : null).add("TotalRecords", (Object)this.totalRecords()).add("LookbackPeriod", (Object)this.lookbackPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "TotalRecords": {
                return Optional.ofNullable(clazz.cast(this.totalRecords()));
            }
            case "LookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Services", SERVICES_FIELD);
        map.put("TotalRecords", TOTAL_RECORDS_FIELD);
        map.put("LookbackPeriod", LOOKBACK_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApproximateUsageRecordsResponse, T> g) {
        return obj -> g.apply((GetApproximateUsageRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private Map<String, Long> services = DefaultSdkAutoConstructMap.getInstance();
        private Long totalRecords;
        private DateInterval lookbackPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApproximateUsageRecordsResponse model) {
            super(model);
            this.services(model.services);
            this.totalRecords(model.totalRecords);
            this.lookbackPeriod(model.lookbackPeriod);
        }

        public final Map<String, Long> getServices() {
            if (this.services instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.services;
        }

        public final void setServices(Map<String, Long> services) {
            this.services = ApproximateUsageRecordsPerServiceCopier.copy(services);
        }

        @Override
        public final Builder services(Map<String, Long> services) {
            this.services = ApproximateUsageRecordsPerServiceCopier.copy(services);
            return this;
        }

        public final Long getTotalRecords() {
            return this.totalRecords;
        }

        public final void setTotalRecords(Long totalRecords) {
            this.totalRecords = totalRecords;
        }

        @Override
        public final Builder totalRecords(Long totalRecords) {
            this.totalRecords = totalRecords;
            return this;
        }

        public final DateInterval.Builder getLookbackPeriod() {
            return this.lookbackPeriod != null ? this.lookbackPeriod.toBuilder() : null;
        }

        public final void setLookbackPeriod(DateInterval.BuilderImpl lookbackPeriod) {
            this.lookbackPeriod = lookbackPeriod != null ? lookbackPeriod.build() : null;
        }

        @Override
        public final Builder lookbackPeriod(DateInterval lookbackPeriod) {
            this.lookbackPeriod = lookbackPeriod;
            return this;
        }

        @Override
        public GetApproximateUsageRecordsResponse build() {
            return new GetApproximateUsageRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApproximateUsageRecordsResponse> {
        public Builder services(Map<String, Long> var1);

        public Builder totalRecords(Long var1);

        public Builder lookbackPeriod(DateInterval var1);

        default public Builder lookbackPeriod(Consumer<DateInterval.Builder> lookbackPeriod) {
            return this.lookbackPeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(lookbackPeriod)).build());
        }
    }
}

