/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AccountScope;
import software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays;
import software.amazon.awssdk.services.costexplorer.model.PaymentOption;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetailListCopier;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary;
import software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType;
import software.amazon.awssdk.services.costexplorer.model.TermInYears;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansPurchaseRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansPurchaseRecommendation> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountScope").getter(SavingsPlansPurchaseRecommendation.getter(SavingsPlansPurchaseRecommendation::accountScopeAsString)).setter(SavingsPlansPurchaseRecommendation.setter(Builder::accountScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()}).build();
    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SavingsPlansType").getter(SavingsPlansPurchaseRecommendation.getter(SavingsPlansPurchaseRecommendation::savingsPlansTypeAsString)).setter(SavingsPlansPurchaseRecommendation.setter(Builder::savingsPlansType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()}).build();
    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermInYears").getter(SavingsPlansPurchaseRecommendation.getter(SavingsPlansPurchaseRecommendation::termInYearsAsString)).setter(SavingsPlansPurchaseRecommendation.setter(Builder::termInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(SavingsPlansPurchaseRecommendation.getter(SavingsPlansPurchaseRecommendation::paymentOptionAsString)).setter(SavingsPlansPurchaseRecommendation.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackPeriodInDays").getter(SavingsPlansPurchaseRecommendation.getter(SavingsPlansPurchaseRecommendation::lookbackPeriodInDaysAsString)).setter(SavingsPlansPurchaseRecommendation.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build()}).build();
    private static final SdkField<List<SavingsPlansPurchaseRecommendationDetail>> SAVINGS_PLANS_PURCHASE_RECOMMENDATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SavingsPlansPurchaseRecommendationDetails").getter(SavingsPlansPurchaseRecommendation.getter(SavingsPlansPurchaseRecommendation::savingsPlansPurchaseRecommendationDetails)).setter(SavingsPlansPurchaseRecommendation.setter(Builder::savingsPlansPurchaseRecommendationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansPurchaseRecommendationDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlansPurchaseRecommendationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SavingsPlansPurchaseRecommendationSummary> SAVINGS_PLANS_PURCHASE_RECOMMENDATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SavingsPlansPurchaseRecommendationSummary").getter(SavingsPlansPurchaseRecommendation.getter(SavingsPlansPurchaseRecommendation::savingsPlansPurchaseRecommendationSummary)).setter(SavingsPlansPurchaseRecommendation.setter(Builder::savingsPlansPurchaseRecommendationSummary)).constructor(SavingsPlansPurchaseRecommendationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansPurchaseRecommendationSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD, SAVINGS_PLANS_TYPE_FIELD, TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, SAVINGS_PLANS_PURCHASE_RECOMMENDATION_DETAILS_FIELD, SAVINGS_PLANS_PURCHASE_RECOMMENDATION_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SavingsPlansPurchaseRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountScope;
    private final String savingsPlansType;
    private final String termInYears;
    private final String paymentOption;
    private final String lookbackPeriodInDays;
    private final List<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails;
    private final SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary;

    private SavingsPlansPurchaseRecommendation(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.savingsPlansType = builder.savingsPlansType;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.savingsPlansPurchaseRecommendationDetails = builder.savingsPlansPurchaseRecommendationDetails;
        this.savingsPlansPurchaseRecommendationSummary = builder.savingsPlansPurchaseRecommendationSummary;
    }

    public final AccountScope accountScope() {
        return AccountScope.fromValue(this.accountScope);
    }

    public final String accountScopeAsString() {
        return this.accountScope;
    }

    public final SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(this.savingsPlansType);
    }

    public final String savingsPlansTypeAsString() {
        return this.savingsPlansType;
    }

    public final TermInYears termInYears() {
        return TermInYears.fromValue(this.termInYears);
    }

    public final String termInYearsAsString() {
        return this.termInYears;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(this.lookbackPeriodInDays);
    }

    public final String lookbackPeriodInDaysAsString() {
        return this.lookbackPeriodInDays;
    }

    public final boolean hasSavingsPlansPurchaseRecommendationDetails() {
        return this.savingsPlansPurchaseRecommendationDetails != null && !(this.savingsPlansPurchaseRecommendationDetails instanceof SdkAutoConstructList);
    }

    public final List<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails() {
        return this.savingsPlansPurchaseRecommendationDetails;
    }

    public final SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary() {
        return this.savingsPlansPurchaseRecommendationSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSavingsPlansPurchaseRecommendationDetails() ? this.savingsPlansPurchaseRecommendationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansPurchaseRecommendationSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseRecommendation)) {
            return false;
        }
        SavingsPlansPurchaseRecommendation other = (SavingsPlansPurchaseRecommendation)obj;
        return Objects.equals(this.accountScopeAsString(), other.accountScopeAsString()) && Objects.equals(this.savingsPlansTypeAsString(), other.savingsPlansTypeAsString()) && Objects.equals(this.termInYearsAsString(), other.termInYearsAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString()) && this.hasSavingsPlansPurchaseRecommendationDetails() == other.hasSavingsPlansPurchaseRecommendationDetails() && Objects.equals(this.savingsPlansPurchaseRecommendationDetails(), other.savingsPlansPurchaseRecommendationDetails()) && Objects.equals(this.savingsPlansPurchaseRecommendationSummary(), other.savingsPlansPurchaseRecommendationSummary());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlansPurchaseRecommendation").add("AccountScope", (Object)this.accountScopeAsString()).add("SavingsPlansType", (Object)this.savingsPlansTypeAsString()).add("TermInYears", (Object)this.termInYearsAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDaysAsString()).add("SavingsPlansPurchaseRecommendationDetails", this.hasSavingsPlansPurchaseRecommendationDetails() ? this.savingsPlansPurchaseRecommendationDetails() : null).add("SavingsPlansPurchaseRecommendationSummary", (Object)this.savingsPlansPurchaseRecommendationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScopeAsString()));
            }
            case "SavingsPlansType": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansTypeAsString()));
            }
            case "TermInYears": {
                return Optional.ofNullable(clazz.cast(this.termInYearsAsString()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "LookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDaysAsString()));
            }
            case "SavingsPlansPurchaseRecommendationDetails": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansPurchaseRecommendationDetails()));
            }
            case "SavingsPlansPurchaseRecommendationSummary": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansPurchaseRecommendationSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountScope", ACCOUNT_SCOPE_FIELD);
        map.put("SavingsPlansType", SAVINGS_PLANS_TYPE_FIELD);
        map.put("TermInYears", TERM_IN_YEARS_FIELD);
        map.put("PaymentOption", PAYMENT_OPTION_FIELD);
        map.put("LookbackPeriodInDays", LOOKBACK_PERIOD_IN_DAYS_FIELD);
        map.put("SavingsPlansPurchaseRecommendationDetails", SAVINGS_PLANS_PURCHASE_RECOMMENDATION_DETAILS_FIELD);
        map.put("SavingsPlansPurchaseRecommendationSummary", SAVINGS_PLANS_PURCHASE_RECOMMENDATION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseRecommendation, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountScope;
        private String savingsPlansType;
        private String termInYears;
        private String paymentOption;
        private String lookbackPeriodInDays;
        private List<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails = DefaultSdkAutoConstructList.getInstance();
        private SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseRecommendation model) {
            this.accountScope(model.accountScope);
            this.savingsPlansType(model.savingsPlansType);
            this.termInYears(model.termInYears);
            this.paymentOption(model.paymentOption);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.savingsPlansPurchaseRecommendationDetails(model.savingsPlansPurchaseRecommendationDetails);
            this.savingsPlansPurchaseRecommendationSummary(model.savingsPlansPurchaseRecommendationSummary);
        }

        public final String getAccountScope() {
            return this.accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final String getSavingsPlansType() {
            return this.savingsPlansType;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final String getTermInYears() {
            return this.termInYears;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final List<SavingsPlansPurchaseRecommendationDetail.Builder> getSavingsPlansPurchaseRecommendationDetails() {
            List<SavingsPlansPurchaseRecommendationDetail.Builder> result = SavingsPlansPurchaseRecommendationDetailListCopier.copyToBuilder(this.savingsPlansPurchaseRecommendationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSavingsPlansPurchaseRecommendationDetails(Collection<SavingsPlansPurchaseRecommendationDetail.BuilderImpl> savingsPlansPurchaseRecommendationDetails) {
            this.savingsPlansPurchaseRecommendationDetails = SavingsPlansPurchaseRecommendationDetailListCopier.copyFromBuilder(savingsPlansPurchaseRecommendationDetails);
        }

        @Override
        public final Builder savingsPlansPurchaseRecommendationDetails(Collection<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails) {
            this.savingsPlansPurchaseRecommendationDetails = SavingsPlansPurchaseRecommendationDetailListCopier.copy(savingsPlansPurchaseRecommendationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansPurchaseRecommendationDetails(SavingsPlansPurchaseRecommendationDetail ... savingsPlansPurchaseRecommendationDetails) {
            this.savingsPlansPurchaseRecommendationDetails(Arrays.asList(savingsPlansPurchaseRecommendationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansPurchaseRecommendationDetails(Consumer<SavingsPlansPurchaseRecommendationDetail.Builder> ... savingsPlansPurchaseRecommendationDetails) {
            this.savingsPlansPurchaseRecommendationDetails(Stream.of(savingsPlansPurchaseRecommendationDetails).map(c -> (SavingsPlansPurchaseRecommendationDetail)((SavingsPlansPurchaseRecommendationDetail.Builder)SavingsPlansPurchaseRecommendationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SavingsPlansPurchaseRecommendationSummary.Builder getSavingsPlansPurchaseRecommendationSummary() {
            return this.savingsPlansPurchaseRecommendationSummary != null ? this.savingsPlansPurchaseRecommendationSummary.toBuilder() : null;
        }

        public final void setSavingsPlansPurchaseRecommendationSummary(SavingsPlansPurchaseRecommendationSummary.BuilderImpl savingsPlansPurchaseRecommendationSummary) {
            this.savingsPlansPurchaseRecommendationSummary = savingsPlansPurchaseRecommendationSummary != null ? savingsPlansPurchaseRecommendationSummary.build() : null;
        }

        @Override
        public final Builder savingsPlansPurchaseRecommendationSummary(SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary) {
            this.savingsPlansPurchaseRecommendationSummary = savingsPlansPurchaseRecommendationSummary;
            return this;
        }

        public SavingsPlansPurchaseRecommendation build() {
            return new SavingsPlansPurchaseRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansPurchaseRecommendation> {
        public Builder accountScope(String var1);

        public Builder accountScope(AccountScope var1);

        public Builder savingsPlansType(String var1);

        public Builder savingsPlansType(SupportedSavingsPlansType var1);

        public Builder termInYears(String var1);

        public Builder termInYears(TermInYears var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder lookbackPeriodInDays(String var1);

        public Builder lookbackPeriodInDays(LookbackPeriodInDays var1);

        public Builder savingsPlansPurchaseRecommendationDetails(Collection<SavingsPlansPurchaseRecommendationDetail> var1);

        public Builder savingsPlansPurchaseRecommendationDetails(SavingsPlansPurchaseRecommendationDetail ... var1);

        public Builder savingsPlansPurchaseRecommendationDetails(Consumer<SavingsPlansPurchaseRecommendationDetail.Builder> ... var1);

        public Builder savingsPlansPurchaseRecommendationSummary(SavingsPlansPurchaseRecommendationSummary var1);

        default public Builder savingsPlansPurchaseRecommendationSummary(Consumer<SavingsPlansPurchaseRecommendationSummary.Builder> savingsPlansPurchaseRecommendationSummary) {
            return this.savingsPlansPurchaseRecommendationSummary((SavingsPlansPurchaseRecommendationSummary)((SavingsPlansPurchaseRecommendationSummary.Builder)SavingsPlansPurchaseRecommendationSummary.builder().applyMutation(savingsPlansPurchaseRecommendationSummary)).build());
        }
    }
}

