/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.InstanceDetails;
import software.amazon.awssdk.services.costexplorer.model.ReservedCapacityDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationPurchaseRecommendationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationPurchaseRecommendationDetail> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::accountId)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceDetails").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::instanceDetails)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::instanceDetails)).constructor(InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDetails").build()}).build();
    private static final SdkField<String> RECOMMENDED_NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendedNumberOfInstancesToPurchase").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::recommendedNumberOfInstancesToPurchase)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::recommendedNumberOfInstancesToPurchase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedNumberOfInstancesToPurchase").build()}).build();
    private static final SdkField<String> RECOMMENDED_NORMALIZED_UNITS_TO_PURCHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendedNormalizedUnitsToPurchase").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::recommendedNormalizedUnitsToPurchase)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::recommendedNormalizedUnitsToPurchase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedNormalizedUnitsToPurchase").build()}).build();
    private static final SdkField<String> MINIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumNumberOfInstancesUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::minimumNumberOfInstancesUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::minimumNumberOfInstancesUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumberOfInstancesUsedPerHour").build()}).build();
    private static final SdkField<String> MINIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumNormalizedUnitsUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::minimumNormalizedUnitsUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::minimumNormalizedUnitsUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNormalizedUnitsUsedPerHour").build()}).build();
    private static final SdkField<String> MAXIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumNumberOfInstancesUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::maximumNumberOfInstancesUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::maximumNumberOfInstancesUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNumberOfInstancesUsedPerHour").build()}).build();
    private static final SdkField<String> MAXIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumNormalizedUnitsUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::maximumNormalizedUnitsUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::maximumNormalizedUnitsUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNormalizedUnitsUsedPerHour").build()}).build();
    private static final SdkField<String> AVERAGE_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AverageNumberOfInstancesUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::averageNumberOfInstancesUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::averageNumberOfInstancesUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageNumberOfInstancesUsedPerHour").build()}).build();
    private static final SdkField<String> AVERAGE_NORMALIZED_UNITS_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AverageNormalizedUnitsUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::averageNormalizedUnitsUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::averageNormalizedUnitsUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageNormalizedUnitsUsedPerHour").build()}).build();
    private static final SdkField<String> AVERAGE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AverageUtilization").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::averageUtilization)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::averageUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUtilization").build()}).build();
    private static final SdkField<String> ESTIMATED_BREAK_EVEN_IN_MONTHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedBreakEvenInMonths").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::estimatedBreakEvenInMonths)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::estimatedBreakEvenInMonths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedBreakEvenInMonths").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::currencyCode)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlySavingsAmount").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::estimatedMonthlySavingsAmount)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::estimatedMonthlySavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount").build()}).build();
    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlySavingsPercentage").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::estimatedMonthlySavingsPercentage)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::estimatedMonthlySavingsPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsPercentage").build()}).build();
    private static final SdkField<String> ESTIMATED_MONTHLY_ON_DEMAND_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlyOnDemandCost").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::estimatedMonthlyOnDemandCost)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::estimatedMonthlyOnDemandCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlyOnDemandCost").build()}).build();
    private static final SdkField<String> ESTIMATED_RESERVATION_COST_FOR_LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedReservationCostForLookbackPeriod").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::estimatedReservationCostForLookbackPeriod)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::estimatedReservationCostForLookbackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedReservationCostForLookbackPeriod").build()}).build();
    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontCost").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::upfrontCost)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::upfrontCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontCost").build()}).build();
    private static final SdkField<String> RECURRING_STANDARD_MONTHLY_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecurringStandardMonthlyCost").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::recurringStandardMonthlyCost)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::recurringStandardMonthlyCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringStandardMonthlyCost").build()}).build();
    private static final SdkField<ReservedCapacityDetails> RESERVED_CAPACITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReservedCapacityDetails").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::reservedCapacityDetails)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::reservedCapacityDetails)).constructor(ReservedCapacityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityDetails").build()}).build();
    private static final SdkField<String> RECOMMENDED_NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendedNumberOfCapacityUnitsToPurchase").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::recommendedNumberOfCapacityUnitsToPurchase)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::recommendedNumberOfCapacityUnitsToPurchase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedNumberOfCapacityUnitsToPurchase").build()}).build();
    private static final SdkField<String> MINIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumNumberOfCapacityUnitsUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::minimumNumberOfCapacityUnitsUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::minimumNumberOfCapacityUnitsUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumberOfCapacityUnitsUsedPerHour").build()}).build();
    private static final SdkField<String> MAXIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumNumberOfCapacityUnitsUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::maximumNumberOfCapacityUnitsUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::maximumNumberOfCapacityUnitsUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNumberOfCapacityUnitsUsedPerHour").build()}).build();
    private static final SdkField<String> AVERAGE_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AverageNumberOfCapacityUnitsUsedPerHour").getter(ReservationPurchaseRecommendationDetail.getter(ReservationPurchaseRecommendationDetail::averageNumberOfCapacityUnitsUsedPerHour)).setter(ReservationPurchaseRecommendationDetail.setter(Builder::averageNumberOfCapacityUnitsUsedPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageNumberOfCapacityUnitsUsedPerHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, INSTANCE_DETAILS_FIELD, RECOMMENDED_NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD, RECOMMENDED_NORMALIZED_UNITS_TO_PURCHASE_FIELD, MINIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD, MINIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD, MAXIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD, MAXIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD, AVERAGE_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD, AVERAGE_NORMALIZED_UNITS_USED_PER_HOUR_FIELD, AVERAGE_UTILIZATION_FIELD, ESTIMATED_BREAK_EVEN_IN_MONTHS_FIELD, CURRENCY_CODE_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD, ESTIMATED_MONTHLY_SAVINGS_PERCENTAGE_FIELD, ESTIMATED_MONTHLY_ON_DEMAND_COST_FIELD, ESTIMATED_RESERVATION_COST_FOR_LOOKBACK_PERIOD_FIELD, UPFRONT_COST_FIELD, RECURRING_STANDARD_MONTHLY_COST_FIELD, RESERVED_CAPACITY_DETAILS_FIELD, RECOMMENDED_NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD, MINIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD, MAXIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD, AVERAGE_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservationPurchaseRecommendationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final InstanceDetails instanceDetails;
    private final String recommendedNumberOfInstancesToPurchase;
    private final String recommendedNormalizedUnitsToPurchase;
    private final String minimumNumberOfInstancesUsedPerHour;
    private final String minimumNormalizedUnitsUsedPerHour;
    private final String maximumNumberOfInstancesUsedPerHour;
    private final String maximumNormalizedUnitsUsedPerHour;
    private final String averageNumberOfInstancesUsedPerHour;
    private final String averageNormalizedUnitsUsedPerHour;
    private final String averageUtilization;
    private final String estimatedBreakEvenInMonths;
    private final String currencyCode;
    private final String estimatedMonthlySavingsAmount;
    private final String estimatedMonthlySavingsPercentage;
    private final String estimatedMonthlyOnDemandCost;
    private final String estimatedReservationCostForLookbackPeriod;
    private final String upfrontCost;
    private final String recurringStandardMonthlyCost;
    private final ReservedCapacityDetails reservedCapacityDetails;
    private final String recommendedNumberOfCapacityUnitsToPurchase;
    private final String minimumNumberOfCapacityUnitsUsedPerHour;
    private final String maximumNumberOfCapacityUnitsUsedPerHour;
    private final String averageNumberOfCapacityUnitsUsedPerHour;

    private ReservationPurchaseRecommendationDetail(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.instanceDetails = builder.instanceDetails;
        this.recommendedNumberOfInstancesToPurchase = builder.recommendedNumberOfInstancesToPurchase;
        this.recommendedNormalizedUnitsToPurchase = builder.recommendedNormalizedUnitsToPurchase;
        this.minimumNumberOfInstancesUsedPerHour = builder.minimumNumberOfInstancesUsedPerHour;
        this.minimumNormalizedUnitsUsedPerHour = builder.minimumNormalizedUnitsUsedPerHour;
        this.maximumNumberOfInstancesUsedPerHour = builder.maximumNumberOfInstancesUsedPerHour;
        this.maximumNormalizedUnitsUsedPerHour = builder.maximumNormalizedUnitsUsedPerHour;
        this.averageNumberOfInstancesUsedPerHour = builder.averageNumberOfInstancesUsedPerHour;
        this.averageNormalizedUnitsUsedPerHour = builder.averageNormalizedUnitsUsedPerHour;
        this.averageUtilization = builder.averageUtilization;
        this.estimatedBreakEvenInMonths = builder.estimatedBreakEvenInMonths;
        this.currencyCode = builder.currencyCode;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.estimatedMonthlySavingsPercentage = builder.estimatedMonthlySavingsPercentage;
        this.estimatedMonthlyOnDemandCost = builder.estimatedMonthlyOnDemandCost;
        this.estimatedReservationCostForLookbackPeriod = builder.estimatedReservationCostForLookbackPeriod;
        this.upfrontCost = builder.upfrontCost;
        this.recurringStandardMonthlyCost = builder.recurringStandardMonthlyCost;
        this.reservedCapacityDetails = builder.reservedCapacityDetails;
        this.recommendedNumberOfCapacityUnitsToPurchase = builder.recommendedNumberOfCapacityUnitsToPurchase;
        this.minimumNumberOfCapacityUnitsUsedPerHour = builder.minimumNumberOfCapacityUnitsUsedPerHour;
        this.maximumNumberOfCapacityUnitsUsedPerHour = builder.maximumNumberOfCapacityUnitsUsedPerHour;
        this.averageNumberOfCapacityUnitsUsedPerHour = builder.averageNumberOfCapacityUnitsUsedPerHour;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final InstanceDetails instanceDetails() {
        return this.instanceDetails;
    }

    public final String recommendedNumberOfInstancesToPurchase() {
        return this.recommendedNumberOfInstancesToPurchase;
    }

    public final String recommendedNormalizedUnitsToPurchase() {
        return this.recommendedNormalizedUnitsToPurchase;
    }

    public final String minimumNumberOfInstancesUsedPerHour() {
        return this.minimumNumberOfInstancesUsedPerHour;
    }

    public final String minimumNormalizedUnitsUsedPerHour() {
        return this.minimumNormalizedUnitsUsedPerHour;
    }

    public final String maximumNumberOfInstancesUsedPerHour() {
        return this.maximumNumberOfInstancesUsedPerHour;
    }

    public final String maximumNormalizedUnitsUsedPerHour() {
        return this.maximumNormalizedUnitsUsedPerHour;
    }

    public final String averageNumberOfInstancesUsedPerHour() {
        return this.averageNumberOfInstancesUsedPerHour;
    }

    public final String averageNormalizedUnitsUsedPerHour() {
        return this.averageNormalizedUnitsUsedPerHour;
    }

    public final String averageUtilization() {
        return this.averageUtilization;
    }

    public final String estimatedBreakEvenInMonths() {
        return this.estimatedBreakEvenInMonths;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final String estimatedMonthlySavingsAmount() {
        return this.estimatedMonthlySavingsAmount;
    }

    public final String estimatedMonthlySavingsPercentage() {
        return this.estimatedMonthlySavingsPercentage;
    }

    public final String estimatedMonthlyOnDemandCost() {
        return this.estimatedMonthlyOnDemandCost;
    }

    public final String estimatedReservationCostForLookbackPeriod() {
        return this.estimatedReservationCostForLookbackPeriod;
    }

    public final String upfrontCost() {
        return this.upfrontCost;
    }

    public final String recurringStandardMonthlyCost() {
        return this.recurringStandardMonthlyCost;
    }

    public final ReservedCapacityDetails reservedCapacityDetails() {
        return this.reservedCapacityDetails;
    }

    public final String recommendedNumberOfCapacityUnitsToPurchase() {
        return this.recommendedNumberOfCapacityUnitsToPurchase;
    }

    public final String minimumNumberOfCapacityUnitsUsedPerHour() {
        return this.minimumNumberOfCapacityUnitsUsedPerHour;
    }

    public final String maximumNumberOfCapacityUnitsUsedPerHour() {
        return this.maximumNumberOfCapacityUnitsUsedPerHour;
    }

    public final String averageNumberOfCapacityUnitsUsedPerHour() {
        return this.averageNumberOfCapacityUnitsUsedPerHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedNumberOfInstancesToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedNormalizedUnitsToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNumberOfInstancesUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNormalizedUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNumberOfInstancesUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNormalizedUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageNumberOfInstancesUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageNormalizedUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedBreakEvenInMonths());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlyOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedReservationCostForLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringStandardMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCapacityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedNumberOfCapacityUnitsToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNumberOfCapacityUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNumberOfCapacityUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageNumberOfCapacityUnitsUsedPerHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPurchaseRecommendationDetail)) {
            return false;
        }
        ReservationPurchaseRecommendationDetail other = (ReservationPurchaseRecommendationDetail)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.instanceDetails(), other.instanceDetails()) && Objects.equals(this.recommendedNumberOfInstancesToPurchase(), other.recommendedNumberOfInstancesToPurchase()) && Objects.equals(this.recommendedNormalizedUnitsToPurchase(), other.recommendedNormalizedUnitsToPurchase()) && Objects.equals(this.minimumNumberOfInstancesUsedPerHour(), other.minimumNumberOfInstancesUsedPerHour()) && Objects.equals(this.minimumNormalizedUnitsUsedPerHour(), other.minimumNormalizedUnitsUsedPerHour()) && Objects.equals(this.maximumNumberOfInstancesUsedPerHour(), other.maximumNumberOfInstancesUsedPerHour()) && Objects.equals(this.maximumNormalizedUnitsUsedPerHour(), other.maximumNormalizedUnitsUsedPerHour()) && Objects.equals(this.averageNumberOfInstancesUsedPerHour(), other.averageNumberOfInstancesUsedPerHour()) && Objects.equals(this.averageNormalizedUnitsUsedPerHour(), other.averageNormalizedUnitsUsedPerHour()) && Objects.equals(this.averageUtilization(), other.averageUtilization()) && Objects.equals(this.estimatedBreakEvenInMonths(), other.estimatedBreakEvenInMonths()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount()) && Objects.equals(this.estimatedMonthlySavingsPercentage(), other.estimatedMonthlySavingsPercentage()) && Objects.equals(this.estimatedMonthlyOnDemandCost(), other.estimatedMonthlyOnDemandCost()) && Objects.equals(this.estimatedReservationCostForLookbackPeriod(), other.estimatedReservationCostForLookbackPeriod()) && Objects.equals(this.upfrontCost(), other.upfrontCost()) && Objects.equals(this.recurringStandardMonthlyCost(), other.recurringStandardMonthlyCost()) && Objects.equals(this.reservedCapacityDetails(), other.reservedCapacityDetails()) && Objects.equals(this.recommendedNumberOfCapacityUnitsToPurchase(), other.recommendedNumberOfCapacityUnitsToPurchase()) && Objects.equals(this.minimumNumberOfCapacityUnitsUsedPerHour(), other.minimumNumberOfCapacityUnitsUsedPerHour()) && Objects.equals(this.maximumNumberOfCapacityUnitsUsedPerHour(), other.maximumNumberOfCapacityUnitsUsedPerHour()) && Objects.equals(this.averageNumberOfCapacityUnitsUsedPerHour(), other.averageNumberOfCapacityUnitsUsedPerHour());
    }

    public final String toString() {
        return ToString.builder((String)"ReservationPurchaseRecommendationDetail").add("AccountId", (Object)this.accountId()).add("InstanceDetails", (Object)this.instanceDetails()).add("RecommendedNumberOfInstancesToPurchase", (Object)this.recommendedNumberOfInstancesToPurchase()).add("RecommendedNormalizedUnitsToPurchase", (Object)this.recommendedNormalizedUnitsToPurchase()).add("MinimumNumberOfInstancesUsedPerHour", (Object)this.minimumNumberOfInstancesUsedPerHour()).add("MinimumNormalizedUnitsUsedPerHour", (Object)this.minimumNormalizedUnitsUsedPerHour()).add("MaximumNumberOfInstancesUsedPerHour", (Object)this.maximumNumberOfInstancesUsedPerHour()).add("MaximumNormalizedUnitsUsedPerHour", (Object)this.maximumNormalizedUnitsUsedPerHour()).add("AverageNumberOfInstancesUsedPerHour", (Object)this.averageNumberOfInstancesUsedPerHour()).add("AverageNormalizedUnitsUsedPerHour", (Object)this.averageNormalizedUnitsUsedPerHour()).add("AverageUtilization", (Object)this.averageUtilization()).add("EstimatedBreakEvenInMonths", (Object)this.estimatedBreakEvenInMonths()).add("CurrencyCode", (Object)this.currencyCode()).add("EstimatedMonthlySavingsAmount", (Object)this.estimatedMonthlySavingsAmount()).add("EstimatedMonthlySavingsPercentage", (Object)this.estimatedMonthlySavingsPercentage()).add("EstimatedMonthlyOnDemandCost", (Object)this.estimatedMonthlyOnDemandCost()).add("EstimatedReservationCostForLookbackPeriod", (Object)this.estimatedReservationCostForLookbackPeriod()).add("UpfrontCost", (Object)this.upfrontCost()).add("RecurringStandardMonthlyCost", (Object)this.recurringStandardMonthlyCost()).add("ReservedCapacityDetails", (Object)this.reservedCapacityDetails()).add("RecommendedNumberOfCapacityUnitsToPurchase", (Object)this.recommendedNumberOfCapacityUnitsToPurchase()).add("MinimumNumberOfCapacityUnitsUsedPerHour", (Object)this.minimumNumberOfCapacityUnitsUsedPerHour()).add("MaximumNumberOfCapacityUnitsUsedPerHour", (Object)this.maximumNumberOfCapacityUnitsUsedPerHour()).add("AverageNumberOfCapacityUnitsUsedPerHour", (Object)this.averageNumberOfCapacityUnitsUsedPerHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "InstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.instanceDetails()));
            }
            case "RecommendedNumberOfInstancesToPurchase": {
                return Optional.ofNullable(clazz.cast(this.recommendedNumberOfInstancesToPurchase()));
            }
            case "RecommendedNormalizedUnitsToPurchase": {
                return Optional.ofNullable(clazz.cast(this.recommendedNormalizedUnitsToPurchase()));
            }
            case "MinimumNumberOfInstancesUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.minimumNumberOfInstancesUsedPerHour()));
            }
            case "MinimumNormalizedUnitsUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.minimumNormalizedUnitsUsedPerHour()));
            }
            case "MaximumNumberOfInstancesUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.maximumNumberOfInstancesUsedPerHour()));
            }
            case "MaximumNormalizedUnitsUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.maximumNormalizedUnitsUsedPerHour()));
            }
            case "AverageNumberOfInstancesUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.averageNumberOfInstancesUsedPerHour()));
            }
            case "AverageNormalizedUnitsUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.averageNormalizedUnitsUsedPerHour()));
            }
            case "AverageUtilization": {
                return Optional.ofNullable(clazz.cast(this.averageUtilization()));
            }
            case "EstimatedBreakEvenInMonths": {
                return Optional.ofNullable(clazz.cast(this.estimatedBreakEvenInMonths()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "EstimatedMonthlySavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavingsAmount()));
            }
            case "EstimatedMonthlySavingsPercentage": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavingsPercentage()));
            }
            case "EstimatedMonthlyOnDemandCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlyOnDemandCost()));
            }
            case "EstimatedReservationCostForLookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.estimatedReservationCostForLookbackPeriod()));
            }
            case "UpfrontCost": {
                return Optional.ofNullable(clazz.cast(this.upfrontCost()));
            }
            case "RecurringStandardMonthlyCost": {
                return Optional.ofNullable(clazz.cast(this.recurringStandardMonthlyCost()));
            }
            case "ReservedCapacityDetails": {
                return Optional.ofNullable(clazz.cast(this.reservedCapacityDetails()));
            }
            case "RecommendedNumberOfCapacityUnitsToPurchase": {
                return Optional.ofNullable(clazz.cast(this.recommendedNumberOfCapacityUnitsToPurchase()));
            }
            case "MinimumNumberOfCapacityUnitsUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.minimumNumberOfCapacityUnitsUsedPerHour()));
            }
            case "MaximumNumberOfCapacityUnitsUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.maximumNumberOfCapacityUnitsUsedPerHour()));
            }
            case "AverageNumberOfCapacityUnitsUsedPerHour": {
                return Optional.ofNullable(clazz.cast(this.averageNumberOfCapacityUnitsUsedPerHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("InstanceDetails", INSTANCE_DETAILS_FIELD);
        map.put("RecommendedNumberOfInstancesToPurchase", RECOMMENDED_NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD);
        map.put("RecommendedNormalizedUnitsToPurchase", RECOMMENDED_NORMALIZED_UNITS_TO_PURCHASE_FIELD);
        map.put("MinimumNumberOfInstancesUsedPerHour", MINIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD);
        map.put("MinimumNormalizedUnitsUsedPerHour", MINIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD);
        map.put("MaximumNumberOfInstancesUsedPerHour", MAXIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD);
        map.put("MaximumNormalizedUnitsUsedPerHour", MAXIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD);
        map.put("AverageNumberOfInstancesUsedPerHour", AVERAGE_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD);
        map.put("AverageNormalizedUnitsUsedPerHour", AVERAGE_NORMALIZED_UNITS_USED_PER_HOUR_FIELD);
        map.put("AverageUtilization", AVERAGE_UTILIZATION_FIELD);
        map.put("EstimatedBreakEvenInMonths", ESTIMATED_BREAK_EVEN_IN_MONTHS_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("EstimatedMonthlySavingsAmount", ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedMonthlySavingsPercentage", ESTIMATED_MONTHLY_SAVINGS_PERCENTAGE_FIELD);
        map.put("EstimatedMonthlyOnDemandCost", ESTIMATED_MONTHLY_ON_DEMAND_COST_FIELD);
        map.put("EstimatedReservationCostForLookbackPeriod", ESTIMATED_RESERVATION_COST_FOR_LOOKBACK_PERIOD_FIELD);
        map.put("UpfrontCost", UPFRONT_COST_FIELD);
        map.put("RecurringStandardMonthlyCost", RECURRING_STANDARD_MONTHLY_COST_FIELD);
        map.put("ReservedCapacityDetails", RESERVED_CAPACITY_DETAILS_FIELD);
        map.put("RecommendedNumberOfCapacityUnitsToPurchase", RECOMMENDED_NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD);
        map.put("MinimumNumberOfCapacityUnitsUsedPerHour", MINIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD);
        map.put("MaximumNumberOfCapacityUnitsUsedPerHour", MAXIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD);
        map.put("AverageNumberOfCapacityUnitsUsedPerHour", AVERAGE_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservationPurchaseRecommendationDetail, T> g) {
        return obj -> g.apply((ReservationPurchaseRecommendationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private InstanceDetails instanceDetails;
        private String recommendedNumberOfInstancesToPurchase;
        private String recommendedNormalizedUnitsToPurchase;
        private String minimumNumberOfInstancesUsedPerHour;
        private String minimumNormalizedUnitsUsedPerHour;
        private String maximumNumberOfInstancesUsedPerHour;
        private String maximumNormalizedUnitsUsedPerHour;
        private String averageNumberOfInstancesUsedPerHour;
        private String averageNormalizedUnitsUsedPerHour;
        private String averageUtilization;
        private String estimatedBreakEvenInMonths;
        private String currencyCode;
        private String estimatedMonthlySavingsAmount;
        private String estimatedMonthlySavingsPercentage;
        private String estimatedMonthlyOnDemandCost;
        private String estimatedReservationCostForLookbackPeriod;
        private String upfrontCost;
        private String recurringStandardMonthlyCost;
        private ReservedCapacityDetails reservedCapacityDetails;
        private String recommendedNumberOfCapacityUnitsToPurchase;
        private String minimumNumberOfCapacityUnitsUsedPerHour;
        private String maximumNumberOfCapacityUnitsUsedPerHour;
        private String averageNumberOfCapacityUnitsUsedPerHour;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPurchaseRecommendationDetail model) {
            this.accountId(model.accountId);
            this.instanceDetails(model.instanceDetails);
            this.recommendedNumberOfInstancesToPurchase(model.recommendedNumberOfInstancesToPurchase);
            this.recommendedNormalizedUnitsToPurchase(model.recommendedNormalizedUnitsToPurchase);
            this.minimumNumberOfInstancesUsedPerHour(model.minimumNumberOfInstancesUsedPerHour);
            this.minimumNormalizedUnitsUsedPerHour(model.minimumNormalizedUnitsUsedPerHour);
            this.maximumNumberOfInstancesUsedPerHour(model.maximumNumberOfInstancesUsedPerHour);
            this.maximumNormalizedUnitsUsedPerHour(model.maximumNormalizedUnitsUsedPerHour);
            this.averageNumberOfInstancesUsedPerHour(model.averageNumberOfInstancesUsedPerHour);
            this.averageNormalizedUnitsUsedPerHour(model.averageNormalizedUnitsUsedPerHour);
            this.averageUtilization(model.averageUtilization);
            this.estimatedBreakEvenInMonths(model.estimatedBreakEvenInMonths);
            this.currencyCode(model.currencyCode);
            this.estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            this.estimatedMonthlySavingsPercentage(model.estimatedMonthlySavingsPercentage);
            this.estimatedMonthlyOnDemandCost(model.estimatedMonthlyOnDemandCost);
            this.estimatedReservationCostForLookbackPeriod(model.estimatedReservationCostForLookbackPeriod);
            this.upfrontCost(model.upfrontCost);
            this.recurringStandardMonthlyCost(model.recurringStandardMonthlyCost);
            this.reservedCapacityDetails(model.reservedCapacityDetails);
            this.recommendedNumberOfCapacityUnitsToPurchase(model.recommendedNumberOfCapacityUnitsToPurchase);
            this.minimumNumberOfCapacityUnitsUsedPerHour(model.minimumNumberOfCapacityUnitsUsedPerHour);
            this.maximumNumberOfCapacityUnitsUsedPerHour(model.maximumNumberOfCapacityUnitsUsedPerHour);
            this.averageNumberOfCapacityUnitsUsedPerHour(model.averageNumberOfCapacityUnitsUsedPerHour);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return this.instanceDetails != null ? this.instanceDetails.toBuilder() : null;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final String getRecommendedNumberOfInstancesToPurchase() {
            return this.recommendedNumberOfInstancesToPurchase;
        }

        public final void setRecommendedNumberOfInstancesToPurchase(String recommendedNumberOfInstancesToPurchase) {
            this.recommendedNumberOfInstancesToPurchase = recommendedNumberOfInstancesToPurchase;
        }

        @Override
        public final Builder recommendedNumberOfInstancesToPurchase(String recommendedNumberOfInstancesToPurchase) {
            this.recommendedNumberOfInstancesToPurchase = recommendedNumberOfInstancesToPurchase;
            return this;
        }

        public final String getRecommendedNormalizedUnitsToPurchase() {
            return this.recommendedNormalizedUnitsToPurchase;
        }

        public final void setRecommendedNormalizedUnitsToPurchase(String recommendedNormalizedUnitsToPurchase) {
            this.recommendedNormalizedUnitsToPurchase = recommendedNormalizedUnitsToPurchase;
        }

        @Override
        public final Builder recommendedNormalizedUnitsToPurchase(String recommendedNormalizedUnitsToPurchase) {
            this.recommendedNormalizedUnitsToPurchase = recommendedNormalizedUnitsToPurchase;
            return this;
        }

        public final String getMinimumNumberOfInstancesUsedPerHour() {
            return this.minimumNumberOfInstancesUsedPerHour;
        }

        public final void setMinimumNumberOfInstancesUsedPerHour(String minimumNumberOfInstancesUsedPerHour) {
            this.minimumNumberOfInstancesUsedPerHour = minimumNumberOfInstancesUsedPerHour;
        }

        @Override
        public final Builder minimumNumberOfInstancesUsedPerHour(String minimumNumberOfInstancesUsedPerHour) {
            this.minimumNumberOfInstancesUsedPerHour = minimumNumberOfInstancesUsedPerHour;
            return this;
        }

        public final String getMinimumNormalizedUnitsUsedPerHour() {
            return this.minimumNormalizedUnitsUsedPerHour;
        }

        public final void setMinimumNormalizedUnitsUsedPerHour(String minimumNormalizedUnitsUsedPerHour) {
            this.minimumNormalizedUnitsUsedPerHour = minimumNormalizedUnitsUsedPerHour;
        }

        @Override
        public final Builder minimumNormalizedUnitsUsedPerHour(String minimumNormalizedUnitsUsedPerHour) {
            this.minimumNormalizedUnitsUsedPerHour = minimumNormalizedUnitsUsedPerHour;
            return this;
        }

        public final String getMaximumNumberOfInstancesUsedPerHour() {
            return this.maximumNumberOfInstancesUsedPerHour;
        }

        public final void setMaximumNumberOfInstancesUsedPerHour(String maximumNumberOfInstancesUsedPerHour) {
            this.maximumNumberOfInstancesUsedPerHour = maximumNumberOfInstancesUsedPerHour;
        }

        @Override
        public final Builder maximumNumberOfInstancesUsedPerHour(String maximumNumberOfInstancesUsedPerHour) {
            this.maximumNumberOfInstancesUsedPerHour = maximumNumberOfInstancesUsedPerHour;
            return this;
        }

        public final String getMaximumNormalizedUnitsUsedPerHour() {
            return this.maximumNormalizedUnitsUsedPerHour;
        }

        public final void setMaximumNormalizedUnitsUsedPerHour(String maximumNormalizedUnitsUsedPerHour) {
            this.maximumNormalizedUnitsUsedPerHour = maximumNormalizedUnitsUsedPerHour;
        }

        @Override
        public final Builder maximumNormalizedUnitsUsedPerHour(String maximumNormalizedUnitsUsedPerHour) {
            this.maximumNormalizedUnitsUsedPerHour = maximumNormalizedUnitsUsedPerHour;
            return this;
        }

        public final String getAverageNumberOfInstancesUsedPerHour() {
            return this.averageNumberOfInstancesUsedPerHour;
        }

        public final void setAverageNumberOfInstancesUsedPerHour(String averageNumberOfInstancesUsedPerHour) {
            this.averageNumberOfInstancesUsedPerHour = averageNumberOfInstancesUsedPerHour;
        }

        @Override
        public final Builder averageNumberOfInstancesUsedPerHour(String averageNumberOfInstancesUsedPerHour) {
            this.averageNumberOfInstancesUsedPerHour = averageNumberOfInstancesUsedPerHour;
            return this;
        }

        public final String getAverageNormalizedUnitsUsedPerHour() {
            return this.averageNormalizedUnitsUsedPerHour;
        }

        public final void setAverageNormalizedUnitsUsedPerHour(String averageNormalizedUnitsUsedPerHour) {
            this.averageNormalizedUnitsUsedPerHour = averageNormalizedUnitsUsedPerHour;
        }

        @Override
        public final Builder averageNormalizedUnitsUsedPerHour(String averageNormalizedUnitsUsedPerHour) {
            this.averageNormalizedUnitsUsedPerHour = averageNormalizedUnitsUsedPerHour;
            return this;
        }

        public final String getAverageUtilization() {
            return this.averageUtilization;
        }

        public final void setAverageUtilization(String averageUtilization) {
            this.averageUtilization = averageUtilization;
        }

        @Override
        public final Builder averageUtilization(String averageUtilization) {
            this.averageUtilization = averageUtilization;
            return this;
        }

        public final String getEstimatedBreakEvenInMonths() {
            return this.estimatedBreakEvenInMonths;
        }

        public final void setEstimatedBreakEvenInMonths(String estimatedBreakEvenInMonths) {
            this.estimatedBreakEvenInMonths = estimatedBreakEvenInMonths;
        }

        @Override
        public final Builder estimatedBreakEvenInMonths(String estimatedBreakEvenInMonths) {
            this.estimatedBreakEvenInMonths = estimatedBreakEvenInMonths;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return this.estimatedMonthlySavingsAmount;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final String getEstimatedMonthlySavingsPercentage() {
            return this.estimatedMonthlySavingsPercentage;
        }

        public final void setEstimatedMonthlySavingsPercentage(String estimatedMonthlySavingsPercentage) {
            this.estimatedMonthlySavingsPercentage = estimatedMonthlySavingsPercentage;
        }

        @Override
        public final Builder estimatedMonthlySavingsPercentage(String estimatedMonthlySavingsPercentage) {
            this.estimatedMonthlySavingsPercentage = estimatedMonthlySavingsPercentage;
            return this;
        }

        public final String getEstimatedMonthlyOnDemandCost() {
            return this.estimatedMonthlyOnDemandCost;
        }

        public final void setEstimatedMonthlyOnDemandCost(String estimatedMonthlyOnDemandCost) {
            this.estimatedMonthlyOnDemandCost = estimatedMonthlyOnDemandCost;
        }

        @Override
        public final Builder estimatedMonthlyOnDemandCost(String estimatedMonthlyOnDemandCost) {
            this.estimatedMonthlyOnDemandCost = estimatedMonthlyOnDemandCost;
            return this;
        }

        public final String getEstimatedReservationCostForLookbackPeriod() {
            return this.estimatedReservationCostForLookbackPeriod;
        }

        public final void setEstimatedReservationCostForLookbackPeriod(String estimatedReservationCostForLookbackPeriod) {
            this.estimatedReservationCostForLookbackPeriod = estimatedReservationCostForLookbackPeriod;
        }

        @Override
        public final Builder estimatedReservationCostForLookbackPeriod(String estimatedReservationCostForLookbackPeriod) {
            this.estimatedReservationCostForLookbackPeriod = estimatedReservationCostForLookbackPeriod;
            return this;
        }

        public final String getUpfrontCost() {
            return this.upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getRecurringStandardMonthlyCost() {
            return this.recurringStandardMonthlyCost;
        }

        public final void setRecurringStandardMonthlyCost(String recurringStandardMonthlyCost) {
            this.recurringStandardMonthlyCost = recurringStandardMonthlyCost;
        }

        @Override
        public final Builder recurringStandardMonthlyCost(String recurringStandardMonthlyCost) {
            this.recurringStandardMonthlyCost = recurringStandardMonthlyCost;
            return this;
        }

        public final ReservedCapacityDetails.Builder getReservedCapacityDetails() {
            return this.reservedCapacityDetails != null ? this.reservedCapacityDetails.toBuilder() : null;
        }

        public final void setReservedCapacityDetails(ReservedCapacityDetails.BuilderImpl reservedCapacityDetails) {
            this.reservedCapacityDetails = reservedCapacityDetails != null ? reservedCapacityDetails.build() : null;
        }

        @Override
        public final Builder reservedCapacityDetails(ReservedCapacityDetails reservedCapacityDetails) {
            this.reservedCapacityDetails = reservedCapacityDetails;
            return this;
        }

        public final String getRecommendedNumberOfCapacityUnitsToPurchase() {
            return this.recommendedNumberOfCapacityUnitsToPurchase;
        }

        public final void setRecommendedNumberOfCapacityUnitsToPurchase(String recommendedNumberOfCapacityUnitsToPurchase) {
            this.recommendedNumberOfCapacityUnitsToPurchase = recommendedNumberOfCapacityUnitsToPurchase;
        }

        @Override
        public final Builder recommendedNumberOfCapacityUnitsToPurchase(String recommendedNumberOfCapacityUnitsToPurchase) {
            this.recommendedNumberOfCapacityUnitsToPurchase = recommendedNumberOfCapacityUnitsToPurchase;
            return this;
        }

        public final String getMinimumNumberOfCapacityUnitsUsedPerHour() {
            return this.minimumNumberOfCapacityUnitsUsedPerHour;
        }

        public final void setMinimumNumberOfCapacityUnitsUsedPerHour(String minimumNumberOfCapacityUnitsUsedPerHour) {
            this.minimumNumberOfCapacityUnitsUsedPerHour = minimumNumberOfCapacityUnitsUsedPerHour;
        }

        @Override
        public final Builder minimumNumberOfCapacityUnitsUsedPerHour(String minimumNumberOfCapacityUnitsUsedPerHour) {
            this.minimumNumberOfCapacityUnitsUsedPerHour = minimumNumberOfCapacityUnitsUsedPerHour;
            return this;
        }

        public final String getMaximumNumberOfCapacityUnitsUsedPerHour() {
            return this.maximumNumberOfCapacityUnitsUsedPerHour;
        }

        public final void setMaximumNumberOfCapacityUnitsUsedPerHour(String maximumNumberOfCapacityUnitsUsedPerHour) {
            this.maximumNumberOfCapacityUnitsUsedPerHour = maximumNumberOfCapacityUnitsUsedPerHour;
        }

        @Override
        public final Builder maximumNumberOfCapacityUnitsUsedPerHour(String maximumNumberOfCapacityUnitsUsedPerHour) {
            this.maximumNumberOfCapacityUnitsUsedPerHour = maximumNumberOfCapacityUnitsUsedPerHour;
            return this;
        }

        public final String getAverageNumberOfCapacityUnitsUsedPerHour() {
            return this.averageNumberOfCapacityUnitsUsedPerHour;
        }

        public final void setAverageNumberOfCapacityUnitsUsedPerHour(String averageNumberOfCapacityUnitsUsedPerHour) {
            this.averageNumberOfCapacityUnitsUsedPerHour = averageNumberOfCapacityUnitsUsedPerHour;
        }

        @Override
        public final Builder averageNumberOfCapacityUnitsUsedPerHour(String averageNumberOfCapacityUnitsUsedPerHour) {
            this.averageNumberOfCapacityUnitsUsedPerHour = averageNumberOfCapacityUnitsUsedPerHour;
            return this;
        }

        public ReservationPurchaseRecommendationDetail build() {
            return new ReservationPurchaseRecommendationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationPurchaseRecommendationDetail> {
        public Builder accountId(String var1);

        public Builder instanceDetails(InstanceDetails var1);

        default public Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return this.instanceDetails((InstanceDetails)((InstanceDetails.Builder)InstanceDetails.builder().applyMutation(instanceDetails)).build());
        }

        public Builder recommendedNumberOfInstancesToPurchase(String var1);

        public Builder recommendedNormalizedUnitsToPurchase(String var1);

        public Builder minimumNumberOfInstancesUsedPerHour(String var1);

        public Builder minimumNormalizedUnitsUsedPerHour(String var1);

        public Builder maximumNumberOfInstancesUsedPerHour(String var1);

        public Builder maximumNormalizedUnitsUsedPerHour(String var1);

        public Builder averageNumberOfInstancesUsedPerHour(String var1);

        public Builder averageNormalizedUnitsUsedPerHour(String var1);

        public Builder averageUtilization(String var1);

        public Builder estimatedBreakEvenInMonths(String var1);

        public Builder currencyCode(String var1);

        public Builder estimatedMonthlySavingsAmount(String var1);

        public Builder estimatedMonthlySavingsPercentage(String var1);

        public Builder estimatedMonthlyOnDemandCost(String var1);

        public Builder estimatedReservationCostForLookbackPeriod(String var1);

        public Builder upfrontCost(String var1);

        public Builder recurringStandardMonthlyCost(String var1);

        public Builder reservedCapacityDetails(ReservedCapacityDetails var1);

        default public Builder reservedCapacityDetails(Consumer<ReservedCapacityDetails.Builder> reservedCapacityDetails) {
            return this.reservedCapacityDetails((ReservedCapacityDetails)((ReservedCapacityDetails.Builder)ReservedCapacityDetails.builder().applyMutation(reservedCapacityDetails)).build());
        }

        public Builder recommendedNumberOfCapacityUnitsToPurchase(String var1);

        public Builder minimumNumberOfCapacityUnitsUsedPerHour(String var1);

        public Builder maximumNumberOfCapacityUnitsUsedPerHour(String var1);

        public Builder averageNumberOfCapacityUnitsUsedPerHour(String var1);
    }
}

