/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.GenerationStatus;
import software.amazon.awssdk.services.costexplorer.model.RecommendationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSavingsPlansPurchaseRecommendationGenerationRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, ListSavingsPlansPurchaseRecommendationGenerationRequest> {
    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationStatus").getter(ListSavingsPlansPurchaseRecommendationGenerationRequest.getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::generationStatusAsString)).setter(ListSavingsPlansPurchaseRecommendationGenerationRequest.setter(Builder::generationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStatus").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommendationIds").getter(ListSavingsPlansPurchaseRecommendationGenerationRequest.getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::recommendationIds)).setter(ListSavingsPlansPurchaseRecommendationGenerationRequest.setter(Builder::recommendationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(ListSavingsPlansPurchaseRecommendationGenerationRequest.getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::pageSize)).setter(ListSavingsPlansPurchaseRecommendationGenerationRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListSavingsPlansPurchaseRecommendationGenerationRequest.getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::nextPageToken)).setter(ListSavingsPlansPurchaseRecommendationGenerationRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_STATUS_FIELD, RECOMMENDATION_IDS_FIELD, PAGE_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSavingsPlansPurchaseRecommendationGenerationRequest.memberNameToFieldInitializer();
    private final String generationStatus;
    private final List<String> recommendationIds;
    private final Integer pageSize;
    private final String nextPageToken;

    private ListSavingsPlansPurchaseRecommendationGenerationRequest(BuilderImpl builder) {
        super(builder);
        this.generationStatus = builder.generationStatus;
        this.recommendationIds = builder.recommendationIds;
        this.pageSize = builder.pageSize;
        this.nextPageToken = builder.nextPageToken;
    }

    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(this.generationStatus);
    }

    public final String generationStatusAsString() {
        return this.generationStatus;
    }

    public final boolean hasRecommendationIds() {
        return this.recommendationIds != null && !(this.recommendationIds instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationIds() {
        return this.recommendationIds;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationIds() ? this.recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSavingsPlansPurchaseRecommendationGenerationRequest)) {
            return false;
        }
        ListSavingsPlansPurchaseRecommendationGenerationRequest other = (ListSavingsPlansPurchaseRecommendationGenerationRequest)((Object)obj);
        return Objects.equals(this.generationStatusAsString(), other.generationStatusAsString()) && this.hasRecommendationIds() == other.hasRecommendationIds() && Objects.equals(this.recommendationIds(), other.recommendationIds()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSavingsPlansPurchaseRecommendationGenerationRequest").add("GenerationStatus", (Object)this.generationStatusAsString()).add("RecommendationIds", this.hasRecommendationIds() ? this.recommendationIds() : null).add("PageSize", (Object)this.pageSize()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GenerationStatus": {
                return Optional.ofNullable(clazz.cast(this.generationStatusAsString()));
            }
            case "RecommendationIds": {
                return Optional.ofNullable(clazz.cast(this.recommendationIds()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GenerationStatus", GENERATION_STATUS_FIELD);
        map.put("RecommendationIds", RECOMMENDATION_IDS_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSavingsPlansPurchaseRecommendationGenerationRequest, T> g) {
        return obj -> g.apply((ListSavingsPlansPurchaseRecommendationGenerationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String generationStatus;
        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();
        private Integer pageSize;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSavingsPlansPurchaseRecommendationGenerationRequest model) {
            super(model);
            this.generationStatus(model.generationStatus);
            this.recommendationIds(model.recommendationIds);
            this.pageSize(model.pageSize);
            this.nextPageToken(model.nextPageToken);
        }

        public final String getGenerationStatus() {
            return this.generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (this.recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String ... recommendationIds) {
            this.recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSavingsPlansPurchaseRecommendationGenerationRequest build() {
            return new ListSavingsPlansPurchaseRecommendationGenerationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSavingsPlansPurchaseRecommendationGenerationRequest> {
        public Builder generationStatus(String var1);

        public Builder generationStatus(GenerationStatus var1);

        public Builder recommendationIds(Collection<String> var1);

        public Builder recommendationIds(String ... var1);

        public Builder pageSize(Integer var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

