/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostAllocationTagBackfillStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostAllocationTagBackfillRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostAllocationTagBackfillRequest> {
    private static final SdkField<String> BACKFILL_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackfillFrom").getter(CostAllocationTagBackfillRequest.getter(CostAllocationTagBackfillRequest::backfillFrom)).setter(CostAllocationTagBackfillRequest.setter(Builder::backfillFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillFrom").build()}).build();
    private static final SdkField<String> REQUESTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestedAt").getter(CostAllocationTagBackfillRequest.getter(CostAllocationTagBackfillRequest::requestedAt)).setter(CostAllocationTagBackfillRequest.setter(Builder::requestedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedAt").build()}).build();
    private static final SdkField<String> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompletedAt").getter(CostAllocationTagBackfillRequest.getter(CostAllocationTagBackfillRequest::completedAt)).setter(CostAllocationTagBackfillRequest.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build()}).build();
    private static final SdkField<String> BACKFILL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackfillStatus").getter(CostAllocationTagBackfillRequest.getter(CostAllocationTagBackfillRequest::backfillStatusAsString)).setter(CostAllocationTagBackfillRequest.setter(Builder::backfillStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillStatus").build()}).build();
    private static final SdkField<String> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedAt").getter(CostAllocationTagBackfillRequest.getter(CostAllocationTagBackfillRequest::lastUpdatedAt)).setter(CostAllocationTagBackfillRequest.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKFILL_FROM_FIELD, REQUESTED_AT_FIELD, COMPLETED_AT_FIELD, BACKFILL_STATUS_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CostAllocationTagBackfillRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backfillFrom;
    private final String requestedAt;
    private final String completedAt;
    private final String backfillStatus;
    private final String lastUpdatedAt;

    private CostAllocationTagBackfillRequest(BuilderImpl builder) {
        this.backfillFrom = builder.backfillFrom;
        this.requestedAt = builder.requestedAt;
        this.completedAt = builder.completedAt;
        this.backfillStatus = builder.backfillStatus;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String backfillFrom() {
        return this.backfillFrom;
    }

    public final String requestedAt() {
        return this.requestedAt;
    }

    public final String completedAt() {
        return this.completedAt;
    }

    public final CostAllocationTagBackfillStatus backfillStatus() {
        return CostAllocationTagBackfillStatus.fromValue(this.backfillStatus);
    }

    public final String backfillStatusAsString() {
        return this.backfillStatus;
    }

    public final String lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backfillFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.backfillStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostAllocationTagBackfillRequest)) {
            return false;
        }
        CostAllocationTagBackfillRequest other = (CostAllocationTagBackfillRequest)obj;
        return Objects.equals(this.backfillFrom(), other.backfillFrom()) && Objects.equals(this.requestedAt(), other.requestedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.backfillStatusAsString(), other.backfillStatusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CostAllocationTagBackfillRequest").add("BackfillFrom", (Object)this.backfillFrom()).add("RequestedAt", (Object)this.requestedAt()).add("CompletedAt", (Object)this.completedAt()).add("BackfillStatus", (Object)this.backfillStatusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackfillFrom": {
                return Optional.ofNullable(clazz.cast(this.backfillFrom()));
            }
            case "RequestedAt": {
                return Optional.ofNullable(clazz.cast(this.requestedAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "BackfillStatus": {
                return Optional.ofNullable(clazz.cast(this.backfillStatusAsString()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BackfillFrom", BACKFILL_FROM_FIELD);
        map.put("RequestedAt", REQUESTED_AT_FIELD);
        map.put("CompletedAt", COMPLETED_AT_FIELD);
        map.put("BackfillStatus", BACKFILL_STATUS_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostAllocationTagBackfillRequest, T> g) {
        return obj -> g.apply((CostAllocationTagBackfillRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backfillFrom;
        private String requestedAt;
        private String completedAt;
        private String backfillStatus;
        private String lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CostAllocationTagBackfillRequest model) {
            this.backfillFrom(model.backfillFrom);
            this.requestedAt(model.requestedAt);
            this.completedAt(model.completedAt);
            this.backfillStatus(model.backfillStatus);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBackfillFrom() {
            return this.backfillFrom;
        }

        public final void setBackfillFrom(String backfillFrom) {
            this.backfillFrom = backfillFrom;
        }

        @Override
        public final Builder backfillFrom(String backfillFrom) {
            this.backfillFrom = backfillFrom;
            return this;
        }

        public final String getRequestedAt() {
            return this.requestedAt;
        }

        public final void setRequestedAt(String requestedAt) {
            this.requestedAt = requestedAt;
        }

        @Override
        public final Builder requestedAt(String requestedAt) {
            this.requestedAt = requestedAt;
            return this;
        }

        public final String getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getBackfillStatus() {
            return this.backfillStatus;
        }

        public final void setBackfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
        }

        @Override
        public final Builder backfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
            return this;
        }

        @Override
        public final Builder backfillStatus(CostAllocationTagBackfillStatus backfillStatus) {
            this.backfillStatus(backfillStatus == null ? null : backfillStatus.toString());
            return this;
        }

        public final String getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(String lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(String lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public CostAllocationTagBackfillRequest build() {
            return new CostAllocationTagBackfillRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostAllocationTagBackfillRequest> {
        public Builder backfillFrom(String var1);

        public Builder requestedAt(String var1);

        public Builder completedAt(String var1);

        public Builder backfillStatus(String var1);

        public Builder backfillStatus(CostAllocationTagBackfillStatus var1);

        public Builder lastUpdatedAt(String var1);
    }
}

