/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.GenerationSummary;
import software.amazon.awssdk.services.costexplorer.model.GenerationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSavingsPlansPurchaseRecommendationGenerationResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, ListSavingsPlansPurchaseRecommendationGenerationResponse> {
    private static final SdkField<List<GenerationSummary>> GENERATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GenerationSummaryList").getter(ListSavingsPlansPurchaseRecommendationGenerationResponse.getter(ListSavingsPlansPurchaseRecommendationGenerationResponse::generationSummaryList)).setter(ListSavingsPlansPurchaseRecommendationGenerationResponse.setter(Builder::generationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GenerationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListSavingsPlansPurchaseRecommendationGenerationResponse.getter(ListSavingsPlansPurchaseRecommendationGenerationResponse::nextPageToken)).setter(ListSavingsPlansPurchaseRecommendationGenerationResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_SUMMARY_LIST_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GenerationSummaryList", GENERATION_SUMMARY_LIST_FIELD);
            this.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<GenerationSummary> generationSummaryList;
    private final String nextPageToken;

    private ListSavingsPlansPurchaseRecommendationGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.generationSummaryList = builder.generationSummaryList;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasGenerationSummaryList() {
        return this.generationSummaryList != null && !(this.generationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<GenerationSummary> generationSummaryList() {
        return this.generationSummaryList;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGenerationSummaryList() ? this.generationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSavingsPlansPurchaseRecommendationGenerationResponse)) {
            return false;
        }
        ListSavingsPlansPurchaseRecommendationGenerationResponse other = (ListSavingsPlansPurchaseRecommendationGenerationResponse)((Object)obj);
        return this.hasGenerationSummaryList() == other.hasGenerationSummaryList() && Objects.equals(this.generationSummaryList(), other.generationSummaryList()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSavingsPlansPurchaseRecommendationGenerationResponse").add("GenerationSummaryList", this.hasGenerationSummaryList() ? this.generationSummaryList() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GenerationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.generationSummaryList()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSavingsPlansPurchaseRecommendationGenerationResponse, T> g) {
        return obj -> g.apply((ListSavingsPlansPurchaseRecommendationGenerationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<GenerationSummary> generationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSavingsPlansPurchaseRecommendationGenerationResponse model) {
            super(model);
            this.generationSummaryList(model.generationSummaryList);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<GenerationSummary.Builder> getGenerationSummaryList() {
            List<GenerationSummary.Builder> result = GenerationSummaryListCopier.copyToBuilder(this.generationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGenerationSummaryList(Collection<GenerationSummary.BuilderImpl> generationSummaryList) {
            this.generationSummaryList = GenerationSummaryListCopier.copyFromBuilder(generationSummaryList);
        }

        @Override
        public final Builder generationSummaryList(Collection<GenerationSummary> generationSummaryList) {
            this.generationSummaryList = GenerationSummaryListCopier.copy(generationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generationSummaryList(GenerationSummary ... generationSummaryList) {
            this.generationSummaryList(Arrays.asList(generationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generationSummaryList(Consumer<GenerationSummary.Builder> ... generationSummaryList) {
            this.generationSummaryList(Stream.of(generationSummaryList).map(c -> (GenerationSummary)((GenerationSummary.Builder)GenerationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListSavingsPlansPurchaseRecommendationGenerationResponse build() {
            return new ListSavingsPlansPurchaseRecommendationGenerationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSavingsPlansPurchaseRecommendationGenerationResponse> {
        public Builder generationSummaryList(Collection<GenerationSummary> var1);

        public Builder generationSummaryList(GenerationSummary ... var1);

        public Builder generationSummaryList(Consumer<GenerationSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

