/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscription;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.ResourceTag;
import software.amazon.awssdk.services.costexplorer.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnomalySubscriptionRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, CreateAnomalySubscriptionRequest> {
    private static final SdkField<AnomalySubscription> ANOMALY_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalySubscription").getter(CreateAnomalySubscriptionRequest.getter(CreateAnomalySubscriptionRequest::anomalySubscription)).setter(CreateAnomalySubscriptionRequest.setter(Builder::anomalySubscription)).constructor(AnomalySubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalySubscription").build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(CreateAnomalySubscriptionRequest.getter(CreateAnomalySubscriptionRequest::resourceTags)).setter(CreateAnomalySubscriptionRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_SUBSCRIPTION_FIELD, RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AnomalySubscription", ANOMALY_SUBSCRIPTION_FIELD);
            this.put("ResourceTags", RESOURCE_TAGS_FIELD);
        }
    });
    private final AnomalySubscription anomalySubscription;
    private final List<ResourceTag> resourceTags;

    private CreateAnomalySubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.anomalySubscription = builder.anomalySubscription;
        this.resourceTags = builder.resourceTags;
    }

    public final AnomalySubscription anomalySubscription() {
        return this.anomalySubscription;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalySubscription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalySubscriptionRequest)) {
            return false;
        }
        CreateAnomalySubscriptionRequest other = (CreateAnomalySubscriptionRequest)((Object)obj);
        return Objects.equals(this.anomalySubscription(), other.anomalySubscription()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnomalySubscriptionRequest").add("AnomalySubscription", (Object)this.anomalySubscription()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalySubscription": {
                return Optional.ofNullable(clazz.cast(this.anomalySubscription()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalySubscriptionRequest, T> g) {
        return obj -> g.apply((CreateAnomalySubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private AnomalySubscription anomalySubscription;
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalySubscriptionRequest model) {
            super(model);
            this.anomalySubscription(model.anomalySubscription);
            this.resourceTags(model.resourceTags);
        }

        public final AnomalySubscription.Builder getAnomalySubscription() {
            return this.anomalySubscription != null ? this.anomalySubscription.toBuilder() : null;
        }

        public final void setAnomalySubscription(AnomalySubscription.BuilderImpl anomalySubscription) {
            this.anomalySubscription = anomalySubscription != null ? anomalySubscription.build() : null;
        }

        @Override
        public final Builder anomalySubscription(AnomalySubscription anomalySubscription) {
            this.anomalySubscription = anomalySubscription;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalySubscriptionRequest build() {
            return new CreateAnomalySubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnomalySubscriptionRequest> {
        public Builder anomalySubscription(AnomalySubscription var1);

        default public Builder anomalySubscription(Consumer<AnomalySubscription.Builder> anomalySubscription) {
            return this.anomalySubscription((AnomalySubscription)((AnomalySubscription.Builder)AnomalySubscription.builder().applyMutation(anomalySubscription)).build());
        }

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

