/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AccountScope;
import software.amazon.awssdk.services.costexplorer.model.AnalysisType;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlans;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansToAddCopier;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansToExcludeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansPurchaseAnalysisConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansPurchaseAnalysisConfiguration> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountScope").getter(SavingsPlansPurchaseAnalysisConfiguration.getter(SavingsPlansPurchaseAnalysisConfiguration::accountScopeAsString)).setter(SavingsPlansPurchaseAnalysisConfiguration.setter(Builder::accountScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(SavingsPlansPurchaseAnalysisConfiguration.getter(SavingsPlansPurchaseAnalysisConfiguration::accountId)).setter(SavingsPlansPurchaseAnalysisConfiguration.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisType").getter(SavingsPlansPurchaseAnalysisConfiguration.getter(SavingsPlansPurchaseAnalysisConfiguration::analysisTypeAsString)).setter(SavingsPlansPurchaseAnalysisConfiguration.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()}).build();
    private static final SdkField<List<SavingsPlans>> SAVINGS_PLANS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SavingsPlansToAdd").getter(SavingsPlansPurchaseAnalysisConfiguration.getter(SavingsPlansPurchaseAnalysisConfiguration::savingsPlansToAdd)).setter(SavingsPlansPurchaseAnalysisConfiguration.setter(Builder::savingsPlansToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlans::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAVINGS_PLANS_TO_EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SavingsPlansToExclude").getter(SavingsPlansPurchaseAnalysisConfiguration.getter(SavingsPlansPurchaseAnalysisConfiguration::savingsPlansToExclude)).setter(SavingsPlansPurchaseAnalysisConfiguration.setter(Builder::savingsPlansToExclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansToExclude").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DateInterval> LOOK_BACK_TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LookBackTimePeriod").getter(SavingsPlansPurchaseAnalysisConfiguration.getter(SavingsPlansPurchaseAnalysisConfiguration::lookBackTimePeriod)).setter(SavingsPlansPurchaseAnalysisConfiguration.setter(Builder::lookBackTimePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookBackTimePeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD, ACCOUNT_ID_FIELD, ANALYSIS_TYPE_FIELD, SAVINGS_PLANS_TO_ADD_FIELD, SAVINGS_PLANS_TO_EXCLUDE_FIELD, LOOK_BACK_TIME_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountScope", ACCOUNT_SCOPE_FIELD);
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("AnalysisType", ANALYSIS_TYPE_FIELD);
            this.put("SavingsPlansToAdd", SAVINGS_PLANS_TO_ADD_FIELD);
            this.put("SavingsPlansToExclude", SAVINGS_PLANS_TO_EXCLUDE_FIELD);
            this.put("LookBackTimePeriod", LOOK_BACK_TIME_PERIOD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountScope;
    private final String accountId;
    private final String analysisType;
    private final List<SavingsPlans> savingsPlansToAdd;
    private final List<String> savingsPlansToExclude;
    private final DateInterval lookBackTimePeriod;

    private SavingsPlansPurchaseAnalysisConfiguration(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.accountId = builder.accountId;
        this.analysisType = builder.analysisType;
        this.savingsPlansToAdd = builder.savingsPlansToAdd;
        this.savingsPlansToExclude = builder.savingsPlansToExclude;
        this.lookBackTimePeriod = builder.lookBackTimePeriod;
    }

    public final AccountScope accountScope() {
        return AccountScope.fromValue(this.accountScope);
    }

    public final String accountScopeAsString() {
        return this.accountScope;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    public final boolean hasSavingsPlansToAdd() {
        return this.savingsPlansToAdd != null && !(this.savingsPlansToAdd instanceof SdkAutoConstructList);
    }

    public final List<SavingsPlans> savingsPlansToAdd() {
        return this.savingsPlansToAdd;
    }

    public final boolean hasSavingsPlansToExclude() {
        return this.savingsPlansToExclude != null && !(this.savingsPlansToExclude instanceof SdkAutoConstructList);
    }

    public final List<String> savingsPlansToExclude() {
        return this.savingsPlansToExclude;
    }

    public final DateInterval lookBackTimePeriod() {
        return this.lookBackTimePeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSavingsPlansToAdd() ? this.savingsPlansToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSavingsPlansToExclude() ? this.savingsPlansToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackTimePeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseAnalysisConfiguration)) {
            return false;
        }
        SavingsPlansPurchaseAnalysisConfiguration other = (SavingsPlansPurchaseAnalysisConfiguration)obj;
        return Objects.equals(this.accountScopeAsString(), other.accountScopeAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString()) && this.hasSavingsPlansToAdd() == other.hasSavingsPlansToAdd() && Objects.equals(this.savingsPlansToAdd(), other.savingsPlansToAdd()) && this.hasSavingsPlansToExclude() == other.hasSavingsPlansToExclude() && Objects.equals(this.savingsPlansToExclude(), other.savingsPlansToExclude()) && Objects.equals(this.lookBackTimePeriod(), other.lookBackTimePeriod());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlansPurchaseAnalysisConfiguration").add("AccountScope", (Object)this.accountScopeAsString()).add("AccountId", (Object)this.accountId()).add("AnalysisType", (Object)this.analysisTypeAsString()).add("SavingsPlansToAdd", this.hasSavingsPlansToAdd() ? this.savingsPlansToAdd() : null).add("SavingsPlansToExclude", this.hasSavingsPlansToExclude() ? this.savingsPlansToExclude() : null).add("LookBackTimePeriod", (Object)this.lookBackTimePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScopeAsString()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AnalysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
            case "SavingsPlansToAdd": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansToAdd()));
            }
            case "SavingsPlansToExclude": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansToExclude()));
            }
            case "LookBackTimePeriod": {
                return Optional.ofNullable(clazz.cast(this.lookBackTimePeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseAnalysisConfiguration, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseAnalysisConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountScope;
        private String accountId;
        private String analysisType;
        private List<SavingsPlans> savingsPlansToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> savingsPlansToExclude = DefaultSdkAutoConstructList.getInstance();
        private DateInterval lookBackTimePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseAnalysisConfiguration model) {
            this.accountScope(model.accountScope);
            this.accountId(model.accountId);
            this.analysisType(model.analysisType);
            this.savingsPlansToAdd(model.savingsPlansToAdd);
            this.savingsPlansToExclude(model.savingsPlansToExclude);
            this.lookBackTimePeriod(model.lookBackTimePeriod);
        }

        public final String getAccountScope() {
            return this.accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final List<SavingsPlans.Builder> getSavingsPlansToAdd() {
            List<SavingsPlans.Builder> result = SavingsPlansToAddCopier.copyToBuilder(this.savingsPlansToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSavingsPlansToAdd(Collection<SavingsPlans.BuilderImpl> savingsPlansToAdd) {
            this.savingsPlansToAdd = SavingsPlansToAddCopier.copyFromBuilder(savingsPlansToAdd);
        }

        @Override
        public final Builder savingsPlansToAdd(Collection<SavingsPlans> savingsPlansToAdd) {
            this.savingsPlansToAdd = SavingsPlansToAddCopier.copy(savingsPlansToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansToAdd(SavingsPlans ... savingsPlansToAdd) {
            this.savingsPlansToAdd(Arrays.asList(savingsPlansToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansToAdd(Consumer<SavingsPlans.Builder> ... savingsPlansToAdd) {
            this.savingsPlansToAdd(Stream.of(savingsPlansToAdd).map(c -> (SavingsPlans)((SavingsPlans.Builder)SavingsPlans.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSavingsPlansToExclude() {
            if (this.savingsPlansToExclude instanceof SdkAutoConstructList) {
                return null;
            }
            return this.savingsPlansToExclude;
        }

        public final void setSavingsPlansToExclude(Collection<String> savingsPlansToExclude) {
            this.savingsPlansToExclude = SavingsPlansToExcludeCopier.copy(savingsPlansToExclude);
        }

        @Override
        public final Builder savingsPlansToExclude(Collection<String> savingsPlansToExclude) {
            this.savingsPlansToExclude = SavingsPlansToExcludeCopier.copy(savingsPlansToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansToExclude(String ... savingsPlansToExclude) {
            this.savingsPlansToExclude(Arrays.asList(savingsPlansToExclude));
            return this;
        }

        public final DateInterval.Builder getLookBackTimePeriod() {
            return this.lookBackTimePeriod != null ? this.lookBackTimePeriod.toBuilder() : null;
        }

        public final void setLookBackTimePeriod(DateInterval.BuilderImpl lookBackTimePeriod) {
            this.lookBackTimePeriod = lookBackTimePeriod != null ? lookBackTimePeriod.build() : null;
        }

        @Override
        public final Builder lookBackTimePeriod(DateInterval lookBackTimePeriod) {
            this.lookBackTimePeriod = lookBackTimePeriod;
            return this;
        }

        public SavingsPlansPurchaseAnalysisConfiguration build() {
            return new SavingsPlansPurchaseAnalysisConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansPurchaseAnalysisConfiguration> {
        public Builder accountScope(String var1);

        public Builder accountScope(AccountScope var1);

        public Builder accountId(String var1);

        public Builder analysisType(String var1);

        public Builder analysisType(AnalysisType var1);

        public Builder savingsPlansToAdd(Collection<SavingsPlans> var1);

        public Builder savingsPlansToAdd(SavingsPlans ... var1);

        public Builder savingsPlansToAdd(Consumer<SavingsPlans.Builder> ... var1);

        public Builder savingsPlansToExclude(Collection<String> var1);

        public Builder savingsPlansToExclude(String ... var1);

        public Builder lookBackTimePeriod(DateInterval var1);

        default public Builder lookBackTimePeriod(Consumer<DateInterval.Builder> lookBackTimePeriod) {
            return this.lookBackTimePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(lookBackTimePeriod)).build());
        }
    }
}

