/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansUtilization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansUtilization> {
    private static final SdkField<String> TOTAL_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalCommitment").getter(SavingsPlansUtilization.getter(SavingsPlansUtilization::totalCommitment)).setter(SavingsPlansUtilization.setter(Builder::totalCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCommitment").build()}).build();
    private static final SdkField<String> USED_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsedCommitment").getter(SavingsPlansUtilization.getter(SavingsPlansUtilization::usedCommitment)).setter(SavingsPlansUtilization.setter(Builder::usedCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedCommitment").build()}).build();
    private static final SdkField<String> UNUSED_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnusedCommitment").getter(SavingsPlansUtilization.getter(SavingsPlansUtilization::unusedCommitment)).setter(SavingsPlansUtilization.setter(Builder::unusedCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedCommitment").build()}).build();
    private static final SdkField<String> UTILIZATION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtilizationPercentage").getter(SavingsPlansUtilization.getter(SavingsPlansUtilization::utilizationPercentage)).setter(SavingsPlansUtilization.setter(Builder::utilizationPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COMMITMENT_FIELD, USED_COMMITMENT_FIELD, UNUSED_COMMITMENT_FIELD, UTILIZATION_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TotalCommitment", TOTAL_COMMITMENT_FIELD);
            this.put("UsedCommitment", USED_COMMITMENT_FIELD);
            this.put("UnusedCommitment", UNUSED_COMMITMENT_FIELD);
            this.put("UtilizationPercentage", UTILIZATION_PERCENTAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String totalCommitment;
    private final String usedCommitment;
    private final String unusedCommitment;
    private final String utilizationPercentage;

    private SavingsPlansUtilization(BuilderImpl builder) {
        this.totalCommitment = builder.totalCommitment;
        this.usedCommitment = builder.usedCommitment;
        this.unusedCommitment = builder.unusedCommitment;
        this.utilizationPercentage = builder.utilizationPercentage;
    }

    public final String totalCommitment() {
        return this.totalCommitment;
    }

    public final String usedCommitment() {
        return this.usedCommitment;
    }

    public final String unusedCommitment() {
        return this.unusedCommitment;
    }

    public final String utilizationPercentage() {
        return this.utilizationPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.usedCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilization)) {
            return false;
        }
        SavingsPlansUtilization other = (SavingsPlansUtilization)obj;
        return Objects.equals(this.totalCommitment(), other.totalCommitment()) && Objects.equals(this.usedCommitment(), other.usedCommitment()) && Objects.equals(this.unusedCommitment(), other.unusedCommitment()) && Objects.equals(this.utilizationPercentage(), other.utilizationPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlansUtilization").add("TotalCommitment", (Object)this.totalCommitment()).add("UsedCommitment", (Object)this.usedCommitment()).add("UnusedCommitment", (Object)this.unusedCommitment()).add("UtilizationPercentage", (Object)this.utilizationPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalCommitment": {
                return Optional.ofNullable(clazz.cast(this.totalCommitment()));
            }
            case "UsedCommitment": {
                return Optional.ofNullable(clazz.cast(this.usedCommitment()));
            }
            case "UnusedCommitment": {
                return Optional.ofNullable(clazz.cast(this.unusedCommitment()));
            }
            case "UtilizationPercentage": {
                return Optional.ofNullable(clazz.cast(this.utilizationPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilization, T> g) {
        return obj -> g.apply((SavingsPlansUtilization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String totalCommitment;
        private String usedCommitment;
        private String unusedCommitment;
        private String utilizationPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilization model) {
            this.totalCommitment(model.totalCommitment);
            this.usedCommitment(model.usedCommitment);
            this.unusedCommitment(model.unusedCommitment);
            this.utilizationPercentage(model.utilizationPercentage);
        }

        public final String getTotalCommitment() {
            return this.totalCommitment;
        }

        public final void setTotalCommitment(String totalCommitment) {
            this.totalCommitment = totalCommitment;
        }

        @Override
        public final Builder totalCommitment(String totalCommitment) {
            this.totalCommitment = totalCommitment;
            return this;
        }

        public final String getUsedCommitment() {
            return this.usedCommitment;
        }

        public final void setUsedCommitment(String usedCommitment) {
            this.usedCommitment = usedCommitment;
        }

        @Override
        public final Builder usedCommitment(String usedCommitment) {
            this.usedCommitment = usedCommitment;
            return this;
        }

        public final String getUnusedCommitment() {
            return this.unusedCommitment;
        }

        public final void setUnusedCommitment(String unusedCommitment) {
            this.unusedCommitment = unusedCommitment;
        }

        @Override
        public final Builder unusedCommitment(String unusedCommitment) {
            this.unusedCommitment = unusedCommitment;
            return this;
        }

        public final String getUtilizationPercentage() {
            return this.utilizationPercentage;
        }

        public final void setUtilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
        }

        @Override
        public final Builder utilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
            return this;
        }

        public SavingsPlansUtilization build() {
            return new SavingsPlansUtilization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansUtilization> {
        public Builder totalCommitment(String var1);

        public Builder usedCommitment(String var1);

        public Builder unusedCommitment(String var1);

        public Builder utilizationPercentage(String var1);
    }
}

