/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.PaymentOption;
import software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType;
import software.amazon.awssdk.services.costexplorer.model.TermInYears;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlans
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlans> {
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(SavingsPlans.getter(SavingsPlans::paymentOptionAsString)).setter(SavingsPlans.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SavingsPlansType").getter(SavingsPlans.getter(SavingsPlans::savingsPlansTypeAsString)).setter(SavingsPlans.setter(Builder::savingsPlansType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(SavingsPlans.getter(SavingsPlans::region)).setter(SavingsPlans.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(SavingsPlans.getter(SavingsPlans::instanceFamily)).setter(SavingsPlans.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").build()}).build();
    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermInYears").getter(SavingsPlans.getter(SavingsPlans::termInYearsAsString)).setter(SavingsPlans.setter(Builder::termInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()}).build();
    private static final SdkField<Double> SAVINGS_PLANS_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SavingsPlansCommitment").getter(SavingsPlans.getter(SavingsPlans::savingsPlansCommitment)).setter(SavingsPlans.setter(Builder::savingsPlansCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansCommitment").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingId").getter(SavingsPlans.getter(SavingsPlans::offeringId)).setter(SavingsPlans.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYMENT_OPTION_FIELD, SAVINGS_PLANS_TYPE_FIELD, REGION_FIELD, INSTANCE_FAMILY_FIELD, TERM_IN_YEARS_FIELD, SAVINGS_PLANS_COMMITMENT_FIELD, OFFERING_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PaymentOption", PAYMENT_OPTION_FIELD);
            this.put("SavingsPlansType", SAVINGS_PLANS_TYPE_FIELD);
            this.put("Region", REGION_FIELD);
            this.put("InstanceFamily", INSTANCE_FAMILY_FIELD);
            this.put("TermInYears", TERM_IN_YEARS_FIELD);
            this.put("SavingsPlansCommitment", SAVINGS_PLANS_COMMITMENT_FIELD);
            this.put("OfferingId", OFFERING_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String paymentOption;
    private final String savingsPlansType;
    private final String region;
    private final String instanceFamily;
    private final String termInYears;
    private final Double savingsPlansCommitment;
    private final String offeringId;

    private SavingsPlans(BuilderImpl builder) {
        this.paymentOption = builder.paymentOption;
        this.savingsPlansType = builder.savingsPlansType;
        this.region = builder.region;
        this.instanceFamily = builder.instanceFamily;
        this.termInYears = builder.termInYears;
        this.savingsPlansCommitment = builder.savingsPlansCommitment;
        this.offeringId = builder.offeringId;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(this.savingsPlansType);
    }

    public final String savingsPlansTypeAsString() {
        return this.savingsPlansType;
    }

    public final String region() {
        return this.region;
    }

    public final String instanceFamily() {
        return this.instanceFamily;
    }

    public final TermInYears termInYears() {
        return TermInYears.fromValue(this.termInYears);
    }

    public final String termInYearsAsString() {
        return this.termInYears;
    }

    public final Double savingsPlansCommitment() {
        return this.savingsPlansCommitment;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlans)) {
            return false;
        }
        SavingsPlans other = (SavingsPlans)obj;
        return Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.savingsPlansTypeAsString(), other.savingsPlansTypeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.instanceFamily(), other.instanceFamily()) && Objects.equals(this.termInYearsAsString(), other.termInYearsAsString()) && Objects.equals(this.savingsPlansCommitment(), other.savingsPlansCommitment()) && Objects.equals(this.offeringId(), other.offeringId());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlans").add("PaymentOption", (Object)this.paymentOptionAsString()).add("SavingsPlansType", (Object)this.savingsPlansTypeAsString()).add("Region", (Object)this.region()).add("InstanceFamily", (Object)this.instanceFamily()).add("TermInYears", (Object)this.termInYearsAsString()).add("SavingsPlansCommitment", (Object)this.savingsPlansCommitment()).add("OfferingId", (Object)this.offeringId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "SavingsPlansType": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
            case "TermInYears": {
                return Optional.ofNullable(clazz.cast(this.termInYearsAsString()));
            }
            case "SavingsPlansCommitment": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansCommitment()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlans, T> g) {
        return obj -> g.apply((SavingsPlans)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String paymentOption;
        private String savingsPlansType;
        private String region;
        private String instanceFamily;
        private String termInYears;
        private Double savingsPlansCommitment;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlans model) {
            this.paymentOption(model.paymentOption);
            this.savingsPlansType(model.savingsPlansType);
            this.region(model.region);
            this.instanceFamily(model.instanceFamily);
            this.termInYears(model.termInYears);
            this.savingsPlansCommitment(model.savingsPlansCommitment);
            this.offeringId(model.offeringId);
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getSavingsPlansType() {
            return this.savingsPlansType;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getTermInYears() {
            return this.termInYears;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final Double getSavingsPlansCommitment() {
            return this.savingsPlansCommitment;
        }

        public final void setSavingsPlansCommitment(Double savingsPlansCommitment) {
            this.savingsPlansCommitment = savingsPlansCommitment;
        }

        @Override
        public final Builder savingsPlansCommitment(Double savingsPlansCommitment) {
            this.savingsPlansCommitment = savingsPlansCommitment;
            return this;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public SavingsPlans build() {
            return new SavingsPlans(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlans> {
        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder savingsPlansType(String var1);

        public Builder savingsPlansType(SupportedSavingsPlansType var1);

        public Builder region(String var1);

        public Builder instanceFamily(String var1);

        public Builder termInYears(String var1);

        public Builder termInYears(TermInYears var1);

        public Builder savingsPlansCommitment(Double var1);

        public Builder offeringId(String var1);
    }
}

