/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.MonitorDimension;
import software.amazon.awssdk.services.costexplorer.model.MonitorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyMonitor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyMonitor> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorArn").getter(AnomalyMonitor.getter(AnomalyMonitor::monitorArn)).setter(AnomalyMonitor.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(AnomalyMonitor.getter(AnomalyMonitor::monitorName)).setter(AnomalyMonitor.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(AnomalyMonitor.getter(AnomalyMonitor::creationDate)).setter(AnomalyMonitor.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedDate").getter(AnomalyMonitor.getter(AnomalyMonitor::lastUpdatedDate)).setter(AnomalyMonitor.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()}).build();
    private static final SdkField<String> LAST_EVALUATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastEvaluatedDate").getter(AnomalyMonitor.getter(AnomalyMonitor::lastEvaluatedDate)).setter(AnomalyMonitor.setter(Builder::lastEvaluatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedDate").build()}).build();
    private static final SdkField<String> MONITOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorType").getter(AnomalyMonitor.getter(AnomalyMonitor::monitorTypeAsString)).setter(AnomalyMonitor.setter(Builder::monitorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorType").build()}).build();
    private static final SdkField<String> MONITOR_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorDimension").getter(AnomalyMonitor.getter(AnomalyMonitor::monitorDimensionAsString)).setter(AnomalyMonitor.setter(Builder::monitorDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorDimension").build()}).build();
    private static final SdkField<Expression> MONITOR_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitorSpecification").getter(AnomalyMonitor.getter(AnomalyMonitor::monitorSpecification)).setter(AnomalyMonitor.setter(Builder::monitorSpecification)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorSpecification").build()}).build();
    private static final SdkField<Integer> DIMENSIONAL_VALUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DimensionalValueCount").getter(AnomalyMonitor.getter(AnomalyMonitor::dimensionalValueCount)).setter(AnomalyMonitor.setter(Builder::dimensionalValueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionalValueCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD, MONITOR_NAME_FIELD, CREATION_DATE_FIELD, LAST_UPDATED_DATE_FIELD, LAST_EVALUATED_DATE_FIELD, MONITOR_TYPE_FIELD, MONITOR_DIMENSION_FIELD, MONITOR_SPECIFICATION_FIELD, DIMENSIONAL_VALUE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MonitorArn", MONITOR_ARN_FIELD);
            this.put("MonitorName", MONITOR_NAME_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("LastUpdatedDate", LAST_UPDATED_DATE_FIELD);
            this.put("LastEvaluatedDate", LAST_EVALUATED_DATE_FIELD);
            this.put("MonitorType", MONITOR_TYPE_FIELD);
            this.put("MonitorDimension", MONITOR_DIMENSION_FIELD);
            this.put("MonitorSpecification", MONITOR_SPECIFICATION_FIELD);
            this.put("DimensionalValueCount", DIMENSIONAL_VALUE_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String monitorArn;
    private final String monitorName;
    private final String creationDate;
    private final String lastUpdatedDate;
    private final String lastEvaluatedDate;
    private final String monitorType;
    private final String monitorDimension;
    private final Expression monitorSpecification;
    private final Integer dimensionalValueCount;

    private AnomalyMonitor(BuilderImpl builder) {
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.creationDate = builder.creationDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.lastEvaluatedDate = builder.lastEvaluatedDate;
        this.monitorType = builder.monitorType;
        this.monitorDimension = builder.monitorDimension;
        this.monitorSpecification = builder.monitorSpecification;
        this.dimensionalValueCount = builder.dimensionalValueCount;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final String lastEvaluatedDate() {
        return this.lastEvaluatedDate;
    }

    public final MonitorType monitorType() {
        return MonitorType.fromValue(this.monitorType);
    }

    public final String monitorTypeAsString() {
        return this.monitorType;
    }

    public final MonitorDimension monitorDimension() {
        return MonitorDimension.fromValue(this.monitorDimension);
    }

    public final String monitorDimensionAsString() {
        return this.monitorDimension;
    }

    public final Expression monitorSpecification() {
        return this.monitorSpecification;
    }

    public final Integer dimensionalValueCount() {
        return this.dimensionalValueCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionalValueCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyMonitor)) {
            return false;
        }
        AnomalyMonitor other = (AnomalyMonitor)obj;
        return Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.lastEvaluatedDate(), other.lastEvaluatedDate()) && Objects.equals(this.monitorTypeAsString(), other.monitorTypeAsString()) && Objects.equals(this.monitorDimensionAsString(), other.monitorDimensionAsString()) && Objects.equals(this.monitorSpecification(), other.monitorSpecification()) && Objects.equals(this.dimensionalValueCount(), other.dimensionalValueCount());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyMonitor").add("MonitorArn", (Object)this.monitorArn()).add("MonitorName", (Object)this.monitorName()).add("CreationDate", (Object)this.creationDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("LastEvaluatedDate", (Object)this.lastEvaluatedDate()).add("MonitorType", (Object)this.monitorTypeAsString()).add("MonitorDimension", (Object)this.monitorDimensionAsString()).add("MonitorSpecification", (Object)this.monitorSpecification()).add("DimensionalValueCount", (Object)this.dimensionalValueCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "LastEvaluatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedDate()));
            }
            case "MonitorType": {
                return Optional.ofNullable(clazz.cast(this.monitorTypeAsString()));
            }
            case "MonitorDimension": {
                return Optional.ofNullable(clazz.cast(this.monitorDimensionAsString()));
            }
            case "MonitorSpecification": {
                return Optional.ofNullable(clazz.cast(this.monitorSpecification()));
            }
            case "DimensionalValueCount": {
                return Optional.ofNullable(clazz.cast(this.dimensionalValueCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyMonitor, T> g) {
        return obj -> g.apply((AnomalyMonitor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitorArn;
        private String monitorName;
        private String creationDate;
        private String lastUpdatedDate;
        private String lastEvaluatedDate;
        private String monitorType;
        private String monitorDimension;
        private Expression monitorSpecification;
        private Integer dimensionalValueCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyMonitor model) {
            this.monitorArn(model.monitorArn);
            this.monitorName(model.monitorName);
            this.creationDate(model.creationDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.lastEvaluatedDate(model.lastEvaluatedDate);
            this.monitorType(model.monitorType);
            this.monitorDimension(model.monitorDimension);
            this.monitorSpecification(model.monitorSpecification);
            this.dimensionalValueCount(model.dimensionalValueCount);
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getLastEvaluatedDate() {
            return this.lastEvaluatedDate;
        }

        public final void setLastEvaluatedDate(String lastEvaluatedDate) {
            this.lastEvaluatedDate = lastEvaluatedDate;
        }

        @Override
        public final Builder lastEvaluatedDate(String lastEvaluatedDate) {
            this.lastEvaluatedDate = lastEvaluatedDate;
            return this;
        }

        public final String getMonitorType() {
            return this.monitorType;
        }

        public final void setMonitorType(String monitorType) {
            this.monitorType = monitorType;
        }

        @Override
        public final Builder monitorType(String monitorType) {
            this.monitorType = monitorType;
            return this;
        }

        @Override
        public final Builder monitorType(MonitorType monitorType) {
            this.monitorType(monitorType == null ? null : monitorType.toString());
            return this;
        }

        public final String getMonitorDimension() {
            return this.monitorDimension;
        }

        public final void setMonitorDimension(String monitorDimension) {
            this.monitorDimension = monitorDimension;
        }

        @Override
        public final Builder monitorDimension(String monitorDimension) {
            this.monitorDimension = monitorDimension;
            return this;
        }

        @Override
        public final Builder monitorDimension(MonitorDimension monitorDimension) {
            this.monitorDimension(monitorDimension == null ? null : monitorDimension.toString());
            return this;
        }

        public final Expression.Builder getMonitorSpecification() {
            return this.monitorSpecification != null ? this.monitorSpecification.toBuilder() : null;
        }

        public final void setMonitorSpecification(Expression.BuilderImpl monitorSpecification) {
            this.monitorSpecification = monitorSpecification != null ? monitorSpecification.build() : null;
        }

        @Override
        public final Builder monitorSpecification(Expression monitorSpecification) {
            this.monitorSpecification = monitorSpecification;
            return this;
        }

        public final Integer getDimensionalValueCount() {
            return this.dimensionalValueCount;
        }

        public final void setDimensionalValueCount(Integer dimensionalValueCount) {
            this.dimensionalValueCount = dimensionalValueCount;
        }

        @Override
        public final Builder dimensionalValueCount(Integer dimensionalValueCount) {
            this.dimensionalValueCount = dimensionalValueCount;
            return this;
        }

        public AnomalyMonitor build() {
            return new AnomalyMonitor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyMonitor> {
        public Builder monitorArn(String var1);

        public Builder monitorName(String var1);

        public Builder creationDate(String var1);

        public Builder lastUpdatedDate(String var1);

        public Builder lastEvaluatedDate(String var1);

        public Builder monitorType(String var1);

        public Builder monitorType(MonitorType var1);

        public Builder monitorDimension(String var1);

        public Builder monitorDimension(MonitorDimension var1);

        public Builder monitorSpecification(Expression var1);

        default public Builder monitorSpecification(Consumer<Expression.Builder> monitorSpecification) {
            return this.monitorSpecification((Expression)((Expression.Builder)Expression.builder().applyMutation(monitorSpecification)).build());
        }

        public Builder dimensionalValueCount(Integer var1);
    }
}

