/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.GenerationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GenerationSummary> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(GenerationSummary.getter(GenerationSummary::recommendationId)).setter(GenerationSummary.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationStatus").getter(GenerationSummary.getter(GenerationSummary::generationStatusAsString)).setter(GenerationSummary.setter(Builder::generationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStatus").build()}).build();
    private static final SdkField<String> GENERATION_STARTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationStartedTime").getter(GenerationSummary.getter(GenerationSummary::generationStartedTime)).setter(GenerationSummary.setter(Builder::generationStartedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStartedTime").build()}).build();
    private static final SdkField<String> GENERATION_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationCompletionTime").getter(GenerationSummary.getter(GenerationSummary::generationCompletionTime)).setter(GenerationSummary.setter(Builder::generationCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationCompletionTime").build()}).build();
    private static final SdkField<String> ESTIMATED_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedCompletionTime").getter(GenerationSummary.getter(GenerationSummary::estimatedCompletionTime)).setter(GenerationSummary.setter(Builder::estimatedCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCompletionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD, GENERATION_STATUS_FIELD, GENERATION_STARTED_TIME_FIELD, GENERATION_COMPLETION_TIME_FIELD, ESTIMATED_COMPLETION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recommendationId;
    private final String generationStatus;
    private final String generationStartedTime;
    private final String generationCompletionTime;
    private final String estimatedCompletionTime;

    private GenerationSummary(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.generationStatus = builder.generationStatus;
        this.generationStartedTime = builder.generationStartedTime;
        this.generationCompletionTime = builder.generationCompletionTime;
        this.estimatedCompletionTime = builder.estimatedCompletionTime;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(this.generationStatus);
    }

    public final String generationStatusAsString() {
        return this.generationStatus;
    }

    public final String generationStartedTime() {
        return this.generationStartedTime;
    }

    public final String generationCompletionTime() {
        return this.generationCompletionTime;
    }

    public final String estimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationStartedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCompletionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerationSummary)) {
            return false;
        }
        GenerationSummary other = (GenerationSummary)obj;
        return Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.generationStatusAsString(), other.generationStatusAsString()) && Objects.equals(this.generationStartedTime(), other.generationStartedTime()) && Objects.equals(this.generationCompletionTime(), other.generationCompletionTime()) && Objects.equals(this.estimatedCompletionTime(), other.estimatedCompletionTime());
    }

    public final String toString() {
        return ToString.builder((String)"GenerationSummary").add("RecommendationId", (Object)this.recommendationId()).add("GenerationStatus", (Object)this.generationStatusAsString()).add("GenerationStartedTime", (Object)this.generationStartedTime()).add("GenerationCompletionTime", (Object)this.generationCompletionTime()).add("EstimatedCompletionTime", (Object)this.estimatedCompletionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "GenerationStatus": {
                return Optional.ofNullable(clazz.cast(this.generationStatusAsString()));
            }
            case "GenerationStartedTime": {
                return Optional.ofNullable(clazz.cast(this.generationStartedTime()));
            }
            case "GenerationCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.generationCompletionTime()));
            }
            case "EstimatedCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.estimatedCompletionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerationSummary, T> g) {
        return obj -> g.apply((GenerationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationId;
        private String generationStatus;
        private String generationStartedTime;
        private String generationCompletionTime;
        private String estimatedCompletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerationSummary model) {
            this.recommendationId(model.recommendationId);
            this.generationStatus(model.generationStatus);
            this.generationStartedTime(model.generationStartedTime);
            this.generationCompletionTime(model.generationCompletionTime);
            this.estimatedCompletionTime(model.estimatedCompletionTime);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getGenerationStatus() {
            return this.generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final String getGenerationStartedTime() {
            return this.generationStartedTime;
        }

        public final void setGenerationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
        }

        @Override
        public final Builder generationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
            return this;
        }

        public final String getGenerationCompletionTime() {
            return this.generationCompletionTime;
        }

        public final void setGenerationCompletionTime(String generationCompletionTime) {
            this.generationCompletionTime = generationCompletionTime;
        }

        @Override
        public final Builder generationCompletionTime(String generationCompletionTime) {
            this.generationCompletionTime = generationCompletionTime;
            return this;
        }

        public final String getEstimatedCompletionTime() {
            return this.estimatedCompletionTime;
        }

        public final void setEstimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
        }

        @Override
        public final Builder estimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
            return this;
        }

        public GenerationSummary build() {
            return new GenerationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GenerationSummary> {
        public Builder recommendationId(String var1);

        public Builder generationStatus(String var1);

        public Builder generationStatus(GenerationStatus var1);

        public Builder generationStartedTime(String var1);

        public Builder generationCompletionTime(String var1);

        public Builder estimatedCompletionTime(String var1);
    }
}

