/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApproximateUsageRecordsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetApproximateUsageRecordsRequest.Builder, GetApproximateUsageRecordsRequest> {
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(GetApproximateUsageRecordsRequest::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<List<String>> SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Services")
            .getter(getter(GetApproximateUsageRecordsRequest::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPROXIMATION_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApproximationDimension")
            .getter(getter(GetApproximateUsageRecordsRequest::approximationDimensionAsString))
            .setter(setter(Builder::approximationDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximationDimension").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANULARITY_FIELD,
            SERVICES_FIELD, APPROXIMATION_DIMENSION_FIELD));

    private final String granularity;

    private final List<String> services;

    private final String approximationDimension;

    private GetApproximateUsageRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.granularity = builder.granularity;
        this.services = builder.services;
        this.approximationDimension = builder.approximationDimension;
    }

    /**
     * <p>
     * How granular you want the data to be. You can enable data at hourly or daily granularity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return How granular you want the data to be. You can enable data at hourly or daily granularity.
     * @see Granularity
     */
    public final Granularity granularity() {
        return Granularity.fromValue(granularity);
    }

    /**
     * <p>
     * How granular you want the data to be. You can enable data at hourly or daily granularity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return How granular you want the data to be. You can enable data at hourly or daily granularity.
     * @see Granularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The service metadata for the service or services you want to query. If not specified, all elements are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return The service metadata for the service or services you want to query. If not specified, all elements are
     *         returned.
     */
    public final List<String> services() {
        return services;
    }

    /**
     * <p>
     * The service to evaluate for the usage records. You can choose resource-level data at daily granularity, or hourly
     * granularity with or without resource-level data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approximationDimension} will return {@link ApproximationDimension#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #approximationDimensionAsString}.
     * </p>
     * 
     * @return The service to evaluate for the usage records. You can choose resource-level data at daily granularity,
     *         or hourly granularity with or without resource-level data.
     * @see ApproximationDimension
     */
    public final ApproximationDimension approximationDimension() {
        return ApproximationDimension.fromValue(approximationDimension);
    }

    /**
     * <p>
     * The service to evaluate for the usage records. You can choose resource-level data at daily granularity, or hourly
     * granularity with or without resource-level data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approximationDimension} will return {@link ApproximationDimension#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #approximationDimensionAsString}.
     * </p>
     * 
     * @return The service to evaluate for the usage records. You can choose resource-level data at daily granularity,
     *         or hourly granularity with or without resource-level data.
     * @see ApproximationDimension
     */
    public final String approximationDimensionAsString() {
        return approximationDimension;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(approximationDimensionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApproximateUsageRecordsRequest)) {
            return false;
        }
        GetApproximateUsageRecordsRequest other = (GetApproximateUsageRecordsRequest) obj;
        return Objects.equals(granularityAsString(), other.granularityAsString()) && hasServices() == other.hasServices()
                && Objects.equals(services(), other.services())
                && Objects.equals(approximationDimensionAsString(), other.approximationDimensionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApproximateUsageRecordsRequest").add("Granularity", granularityAsString())
                .add("Services", hasServices() ? services() : null)
                .add("ApproximationDimension", approximationDimensionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "ApproximationDimension":
            return Optional.ofNullable(clazz.cast(approximationDimensionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApproximateUsageRecordsRequest, T> g) {
        return obj -> g.apply((GetApproximateUsageRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApproximateUsageRecordsRequest> {
        /**
         * <p>
         * How granular you want the data to be. You can enable data at hourly or daily granularity.
         * </p>
         * 
         * @param granularity
         *        How granular you want the data to be. You can enable data at hourly or daily granularity.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * How granular you want the data to be. You can enable data at hourly or daily granularity.
         * </p>
         * 
         * @param granularity
         *        How granular you want the data to be. You can enable data at hourly or daily granularity.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(Granularity granularity);

        /**
         * <p>
         * The service metadata for the service or services you want to query. If not specified, all elements are
         * returned.
         * </p>
         * 
         * @param services
         *        The service metadata for the service or services you want to query. If not specified, all elements are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<String> services);

        /**
         * <p>
         * The service metadata for the service or services you want to query. If not specified, all elements are
         * returned.
         * </p>
         * 
         * @param services
         *        The service metadata for the service or services you want to query. If not specified, all elements are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(String... services);

        /**
         * <p>
         * The service to evaluate for the usage records. You can choose resource-level data at daily granularity, or
         * hourly granularity with or without resource-level data.
         * </p>
         * 
         * @param approximationDimension
         *        The service to evaluate for the usage records. You can choose resource-level data at daily
         *        granularity, or hourly granularity with or without resource-level data.
         * @see ApproximationDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApproximationDimension
         */
        Builder approximationDimension(String approximationDimension);

        /**
         * <p>
         * The service to evaluate for the usage records. You can choose resource-level data at daily granularity, or
         * hourly granularity with or without resource-level data.
         * </p>
         * 
         * @param approximationDimension
         *        The service to evaluate for the usage records. You can choose resource-level data at daily
         *        granularity, or hourly granularity with or without resource-level data.
         * @see ApproximationDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApproximationDimension
         */
        Builder approximationDimension(ApproximationDimension approximationDimension);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String granularity;

        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private String approximationDimension;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApproximateUsageRecordsRequest model) {
            super(model);
            granularity(model.granularity);
            services(model.services);
            approximationDimension(model.approximationDimension);
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Collection<String> getServices() {
            if (services instanceof SdkAutoConstructList) {
                return null;
            }
            return services;
        }

        public final void setServices(Collection<String> services) {
            this.services = UsageServicesCopier.copy(services);
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = UsageServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String... services) {
            services(Arrays.asList(services));
            return this;
        }

        public final String getApproximationDimension() {
            return approximationDimension;
        }

        public final void setApproximationDimension(String approximationDimension) {
            this.approximationDimension = approximationDimension;
        }

        @Override
        public final Builder approximationDimension(String approximationDimension) {
            this.approximationDimension = approximationDimension;
            return this;
        }

        @Override
        public final Builder approximationDimension(ApproximationDimension approximationDimension) {
            this.approximationDimension(approximationDimension == null ? null : approximationDimension.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApproximateUsageRecordsRequest build() {
            return new GetApproximateUsageRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
