/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.MonitorArnListCopier;
import software.amazon.awssdk.services.costexplorer.model.Subscriber;
import software.amazon.awssdk.services.costexplorer.model.SubscribersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnomalySubscriptionRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, UpdateAnomalySubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionArn").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::subscriptionArn)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::subscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::threshold)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Frequency").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::frequencyAsString)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<List<String>> MONITOR_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitorArnList").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::monitorArnList)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::monitorArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::subscribers)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionName").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::subscriptionName)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::subscriptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()}).build();
    private static final SdkField<Expression> THRESHOLD_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThresholdExpression").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::thresholdExpression)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::thresholdExpression)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD, THRESHOLD_FIELD, FREQUENCY_FIELD, MONITOR_ARN_LIST_FIELD, SUBSCRIBERS_FIELD, SUBSCRIPTION_NAME_FIELD, THRESHOLD_EXPRESSION_FIELD));
    private final String subscriptionArn;
    private final Double threshold;
    private final String frequency;
    private final List<String> monitorArnList;
    private final List<Subscriber> subscribers;
    private final String subscriptionName;
    private final Expression thresholdExpression;

    private UpdateAnomalySubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArn = builder.subscriptionArn;
        this.threshold = builder.threshold;
        this.frequency = builder.frequency;
        this.monitorArnList = builder.monitorArnList;
        this.subscribers = builder.subscribers;
        this.subscriptionName = builder.subscriptionName;
        this.thresholdExpression = builder.thresholdExpression;
    }

    public final String subscriptionArn() {
        return this.subscriptionArn;
    }

    @Deprecated
    public final Double threshold() {
        return this.threshold;
    }

    public final AnomalySubscriptionFrequency frequency() {
        return AnomalySubscriptionFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public final boolean hasMonitorArnList() {
        return this.monitorArnList != null && !(this.monitorArnList instanceof SdkAutoConstructList);
    }

    public final List<String> monitorArnList() {
        return this.monitorArnList;
    }

    public final boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public final List<Subscriber> subscribers() {
        return this.subscribers;
    }

    public final String subscriptionName() {
        return this.subscriptionName;
    }

    public final Expression thresholdExpression() {
        return this.thresholdExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitorArnList() ? this.monitorArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribers() ? this.subscribers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalySubscriptionRequest)) {
            return false;
        }
        UpdateAnomalySubscriptionRequest other = (UpdateAnomalySubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && this.hasMonitorArnList() == other.hasMonitorArnList() && Objects.equals(this.monitorArnList(), other.monitorArnList()) && this.hasSubscribers() == other.hasSubscribers() && Objects.equals(this.subscribers(), other.subscribers()) && Objects.equals(this.subscriptionName(), other.subscriptionName()) && Objects.equals(this.thresholdExpression(), other.thresholdExpression());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnomalySubscriptionRequest").add("SubscriptionArn", (Object)this.subscriptionArn()).add("Threshold", (Object)this.threshold()).add("Frequency", (Object)this.frequencyAsString()).add("MonitorArnList", this.hasMonitorArnList() ? this.monitorArnList() : null).add("Subscribers", this.hasSubscribers() ? this.subscribers() : null).add("SubscriptionName", (Object)this.subscriptionName()).add("ThresholdExpression", (Object)this.thresholdExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "MonitorArnList": {
                return Optional.ofNullable(clazz.cast(this.monitorArnList()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
            case "SubscriptionName": {
                return Optional.ofNullable(clazz.cast(this.subscriptionName()));
            }
            case "ThresholdExpression": {
                return Optional.ofNullable(clazz.cast(this.thresholdExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalySubscriptionRequest, T> g) {
        return obj -> g.apply((UpdateAnomalySubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private Double threshold;
        private String frequency;
        private List<String> monitorArnList = DefaultSdkAutoConstructList.getInstance();
        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();
        private String subscriptionName;
        private Expression thresholdExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalySubscriptionRequest model) {
            super(model);
            this.subscriptionArn(model.subscriptionArn);
            this.threshold(model.threshold);
            this.frequency(model.frequency);
            this.monitorArnList(model.monitorArnList);
            this.subscribers(model.subscribers);
            this.subscriptionName(model.subscriptionName);
            this.thresholdExpression(model.thresholdExpression);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        @Deprecated
        public final Double getThreshold() {
            return this.threshold;
        }

        @Deprecated
        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        @Deprecated
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AnomalySubscriptionFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final Collection<String> getMonitorArnList() {
            if (this.monitorArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.monitorArnList;
        }

        public final void setMonitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = MonitorArnListCopier.copy(monitorArnList);
        }

        @Override
        public final Builder monitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = MonitorArnListCopier.copy(monitorArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitorArnList(String ... monitorArnList) {
            this.monitorArnList(Arrays.asList(monitorArnList));
            return this;
        }

        public final List<Subscriber.Builder> getSubscribers() {
            List<Subscriber.Builder> result = SubscribersCopier.copyToBuilder(this.subscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder> ... subscribers) {
            this.subscribers(Stream.of(subscribers).map(c -> (Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final Expression.Builder getThresholdExpression() {
            return this.thresholdExpression != null ? this.thresholdExpression.toBuilder() : null;
        }

        public final void setThresholdExpression(Expression.BuilderImpl thresholdExpression) {
            this.thresholdExpression = thresholdExpression != null ? thresholdExpression.build() : null;
        }

        @Override
        public final Builder thresholdExpression(Expression thresholdExpression) {
            this.thresholdExpression = thresholdExpression;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalySubscriptionRequest build() {
            return new UpdateAnomalySubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnomalySubscriptionRequest> {
        public Builder subscriptionArn(String var1);

        @Deprecated
        public Builder threshold(Double var1);

        public Builder frequency(String var1);

        public Builder frequency(AnomalySubscriptionFrequency var1);

        public Builder monitorArnList(Collection<String> var1);

        public Builder monitorArnList(String ... var1);

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder subscribers(Consumer<Subscriber.Builder> ... var1);

        public Builder subscriptionName(String var1);

        public Builder thresholdExpression(Expression var1);

        default public Builder thresholdExpression(Consumer<Expression.Builder> thresholdExpression) {
            return this.thresholdExpression((Expression)((Expression.Builder)Expression.builder().applyMutation(thresholdExpression)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

