/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.AccountScope;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays;
import software.amazon.awssdk.services.costexplorer.model.PaymentOption;
import software.amazon.awssdk.services.costexplorer.model.ServiceSpecification;
import software.amazon.awssdk.services.costexplorer.model.TermInYears;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservationPurchaseRecommendationRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetReservationPurchaseRecommendationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::accountId)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::service)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::filter)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountScope").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::accountScopeAsString)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::accountScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()}).build();
    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackPeriodInDays").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::lookbackPeriodInDaysAsString)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build()}).build();
    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermInYears").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::termInYearsAsString)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::termInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::paymentOptionAsString)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<ServiceSpecification> SERVICE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceSpecification").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::serviceSpecification)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::serviceSpecification)).constructor(ServiceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecification").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::pageSize)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetReservationPurchaseRecommendationRequest.getter(GetReservationPurchaseRecommendationRequest::nextPageToken)).setter(GetReservationPurchaseRecommendationRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, SERVICE_FIELD, FILTER_FIELD, ACCOUNT_SCOPE_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, SERVICE_SPECIFICATION_FIELD, PAGE_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final String accountId;
    private final String service;
    private final Expression filter;
    private final String accountScope;
    private final String lookbackPeriodInDays;
    private final String termInYears;
    private final String paymentOption;
    private final ServiceSpecification serviceSpecification;
    private final Integer pageSize;
    private final String nextPageToken;

    private GetReservationPurchaseRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.service = builder.service;
        this.filter = builder.filter;
        this.accountScope = builder.accountScope;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.serviceSpecification = builder.serviceSpecification;
        this.pageSize = builder.pageSize;
        this.nextPageToken = builder.nextPageToken;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String service() {
        return this.service;
    }

    public final Expression filter() {
        return this.filter;
    }

    public final AccountScope accountScope() {
        return AccountScope.fromValue(this.accountScope);
    }

    public final String accountScopeAsString() {
        return this.accountScope;
    }

    public final LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(this.lookbackPeriodInDays);
    }

    public final String lookbackPeriodInDaysAsString() {
        return this.lookbackPeriodInDays;
    }

    public final TermInYears termInYears() {
        return TermInYears.fromValue(this.termInYears);
    }

    public final String termInYearsAsString() {
        return this.termInYears;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final ServiceSpecification serviceSpecification() {
        return this.serviceSpecification;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationPurchaseRecommendationRequest)) {
            return false;
        }
        GetReservationPurchaseRecommendationRequest other = (GetReservationPurchaseRecommendationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.accountScopeAsString(), other.accountScopeAsString()) && Objects.equals(this.lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString()) && Objects.equals(this.termInYearsAsString(), other.termInYearsAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.serviceSpecification(), other.serviceSpecification()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetReservationPurchaseRecommendationRequest").add("AccountId", (Object)this.accountId()).add("Service", (Object)this.service()).add("Filter", (Object)this.filter()).add("AccountScope", (Object)this.accountScopeAsString()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDaysAsString()).add("TermInYears", (Object)this.termInYearsAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("ServiceSpecification", (Object)this.serviceSpecification()).add("PageSize", (Object)this.pageSize()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScopeAsString()));
            }
            case "LookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDaysAsString()));
            }
            case "TermInYears": {
                return Optional.ofNullable(clazz.cast(this.termInYearsAsString()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "ServiceSpecification": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecification()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservationPurchaseRecommendationRequest, T> g) {
        return obj -> g.apply((GetReservationPurchaseRecommendationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String service;
        private Expression filter;
        private String accountScope;
        private String lookbackPeriodInDays;
        private String termInYears;
        private String paymentOption;
        private ServiceSpecification serviceSpecification;
        private Integer pageSize;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationPurchaseRecommendationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.service(model.service);
            this.filter(model.filter);
            this.accountScope(model.accountScope);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.termInYears(model.termInYears);
            this.paymentOption(model.paymentOption);
            this.serviceSpecification(model.serviceSpecification);
            this.pageSize(model.pageSize);
            this.nextPageToken(model.nextPageToken);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        @Transient
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final String getAccountScope() {
            return this.accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        @Transient
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        @Transient
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final String getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        @Transient
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        @Transient
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final String getTermInYears() {
            return this.termInYears;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        @Override
        @Transient
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        @Transient
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final ServiceSpecification.Builder getServiceSpecification() {
            return this.serviceSpecification != null ? this.serviceSpecification.toBuilder() : null;
        }

        public final void setServiceSpecification(ServiceSpecification.BuilderImpl serviceSpecification) {
            this.serviceSpecification = serviceSpecification != null ? serviceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceSpecification(ServiceSpecification serviceSpecification) {
            this.serviceSpecification = serviceSpecification;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        @Transient
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservationPurchaseRecommendationRequest build() {
            return new GetReservationPurchaseRecommendationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReservationPurchaseRecommendationRequest> {
        public Builder accountId(String var1);

        public Builder service(String var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder accountScope(String var1);

        public Builder accountScope(AccountScope var1);

        public Builder lookbackPeriodInDays(String var1);

        public Builder lookbackPeriodInDays(LookbackPeriodInDays var1);

        public Builder termInYears(String var1);

        public Builder termInYears(TermInYears var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder serviceSpecification(ServiceSpecification var1);

        default public Builder serviceSpecification(Consumer<ServiceSpecification.Builder> serviceSpecification) {
            return this.serviceSpecification((ServiceSpecification)((ServiceSpecification.Builder)ServiceSpecification.builder().applyMutation(serviceSpecification)).build());
        }

        public Builder pageSize(Integer var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

