/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency;
import software.amazon.awssdk.services.costexplorer.model.MonitorArnListCopier;
import software.amazon.awssdk.services.costexplorer.model.Subscriber;
import software.amazon.awssdk.services.costexplorer.model.SubscribersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalySubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalySubscription> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionArn").getter(AnomalySubscription.getter(AnomalySubscription::subscriptionArn)).setter(AnomalySubscription.setter(Builder::subscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AnomalySubscription.getter(AnomalySubscription::accountId)).setter(AnomalySubscription.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<List<String>> MONITOR_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitorArnList").getter(AnomalySubscription.getter(AnomalySubscription::monitorArnList)).setter(AnomalySubscription.setter(Builder::monitorArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(AnomalySubscription.getter(AnomalySubscription::subscribers)).setter(AnomalySubscription.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(AnomalySubscription.getter(AnomalySubscription::threshold)).setter(AnomalySubscription.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Frequency").getter(AnomalySubscription.getter(AnomalySubscription::frequencyAsString)).setter(AnomalySubscription.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionName").getter(AnomalySubscription.getter(AnomalySubscription::subscriptionName)).setter(AnomalySubscription.setter(Builder::subscriptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD, ACCOUNT_ID_FIELD, MONITOR_ARN_LIST_FIELD, SUBSCRIBERS_FIELD, THRESHOLD_FIELD, FREQUENCY_FIELD, SUBSCRIPTION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subscriptionArn;
    private final String accountId;
    private final List<String> monitorArnList;
    private final List<Subscriber> subscribers;
    private final Double threshold;
    private final String frequency;
    private final String subscriptionName;

    private AnomalySubscription(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
        this.accountId = builder.accountId;
        this.monitorArnList = builder.monitorArnList;
        this.subscribers = builder.subscribers;
        this.threshold = builder.threshold;
        this.frequency = builder.frequency;
        this.subscriptionName = builder.subscriptionName;
    }

    public final String subscriptionArn() {
        return this.subscriptionArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasMonitorArnList() {
        return this.monitorArnList != null && !(this.monitorArnList instanceof SdkAutoConstructList);
    }

    public final List<String> monitorArnList() {
        return this.monitorArnList;
    }

    public final boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public final List<Subscriber> subscribers() {
        return this.subscribers;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final AnomalySubscriptionFrequency frequency() {
        return AnomalySubscriptionFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public final String subscriptionName() {
        return this.subscriptionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitorArnList() ? this.monitorArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribers() ? this.subscribers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalySubscription)) {
            return false;
        }
        AnomalySubscription other = (AnomalySubscription)obj;
        return Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.accountId(), other.accountId()) && this.hasMonitorArnList() == other.hasMonitorArnList() && Objects.equals(this.monitorArnList(), other.monitorArnList()) && this.hasSubscribers() == other.hasSubscribers() && Objects.equals(this.subscribers(), other.subscribers()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.subscriptionName(), other.subscriptionName());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalySubscription").add("SubscriptionArn", (Object)this.subscriptionArn()).add("AccountId", (Object)this.accountId()).add("MonitorArnList", this.hasMonitorArnList() ? this.monitorArnList() : null).add("Subscribers", this.hasSubscribers() ? this.subscribers() : null).add("Threshold", (Object)this.threshold()).add("Frequency", (Object)this.frequencyAsString()).add("SubscriptionName", (Object)this.subscriptionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "MonitorArnList": {
                return Optional.ofNullable(clazz.cast(this.monitorArnList()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "SubscriptionName": {
                return Optional.ofNullable(clazz.cast(this.subscriptionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalySubscription, T> g) {
        return obj -> g.apply((AnomalySubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private String accountId;
        private List<String> monitorArnList = DefaultSdkAutoConstructList.getInstance();
        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();
        private Double threshold;
        private String frequency;
        private String subscriptionName;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalySubscription model) {
            this.subscriptionArn(model.subscriptionArn);
            this.accountId(model.accountId);
            this.monitorArnList(model.monitorArnList);
            this.subscribers(model.subscribers);
            this.threshold(model.threshold);
            this.frequency(model.frequency);
            this.subscriptionName(model.subscriptionName);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<String> getMonitorArnList() {
            if (this.monitorArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.monitorArnList;
        }

        @Override
        public final Builder monitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = MonitorArnListCopier.copy(monitorArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitorArnList(String ... monitorArnList) {
            this.monitorArnList(Arrays.asList(monitorArnList));
            return this;
        }

        public final void setMonitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = MonitorArnListCopier.copy(monitorArnList);
        }

        public final List<Subscriber.Builder> getSubscribers() {
            List<Subscriber.Builder> result = SubscribersCopier.copyToBuilder(this.subscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder> ... subscribers) {
            this.subscribers(Stream.of(subscribers).map(c -> (Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AnomalySubscriptionFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public AnomalySubscription build() {
            return new AnomalySubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalySubscription> {
        public Builder subscriptionArn(String var1);

        public Builder accountId(String var1);

        public Builder monitorArnList(Collection<String> var1);

        public Builder monitorArnList(String ... var1);

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder subscribers(Consumer<Subscriber.Builder> ... var1);

        public Builder threshold(Double var1);

        public Builder frequency(String var1);

        public Builder frequency(AnomalySubscriptionFrequency var1);

        public Builder subscriptionName(String var1);
    }
}

