/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationAggregates;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationsByTimeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSavingsPlansUtilizationResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetSavingsPlansUtilizationResponse> {
    private static final SdkField<List<SavingsPlansUtilizationByTime>> SAVINGS_PLANS_UTILIZATIONS_BY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SavingsPlansUtilizationsByTime").getter(GetSavingsPlansUtilizationResponse.getter(GetSavingsPlansUtilizationResponse::savingsPlansUtilizationsByTime)).setter(GetSavingsPlansUtilizationResponse.setter(Builder::savingsPlansUtilizationsByTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansUtilizationsByTime").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlansUtilizationByTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SavingsPlansUtilizationAggregates> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Total").getter(GetSavingsPlansUtilizationResponse.getter(GetSavingsPlansUtilizationResponse::total)).setter(GetSavingsPlansUtilizationResponse.setter(Builder::total)).constructor(SavingsPlansUtilizationAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_UTILIZATIONS_BY_TIME_FIELD, TOTAL_FIELD));
    private final List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime;
    private final SavingsPlansUtilizationAggregates total;

    private GetSavingsPlansUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlansUtilizationsByTime = builder.savingsPlansUtilizationsByTime;
        this.total = builder.total;
    }

    public final boolean hasSavingsPlansUtilizationsByTime() {
        return this.savingsPlansUtilizationsByTime != null && !(this.savingsPlansUtilizationsByTime instanceof SdkAutoConstructList);
    }

    public final List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime() {
        return this.savingsPlansUtilizationsByTime;
    }

    public final SavingsPlansUtilizationAggregates total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSavingsPlansUtilizationsByTime() ? this.savingsPlansUtilizationsByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationResponse)) {
            return false;
        }
        GetSavingsPlansUtilizationResponse other = (GetSavingsPlansUtilizationResponse)((Object)obj);
        return this.hasSavingsPlansUtilizationsByTime() == other.hasSavingsPlansUtilizationsByTime() && Objects.equals(this.savingsPlansUtilizationsByTime(), other.savingsPlansUtilizationsByTime()) && Objects.equals(this.total(), other.total());
    }

    public final String toString() {
        return ToString.builder((String)"GetSavingsPlansUtilizationResponse").add("SavingsPlansUtilizationsByTime", this.hasSavingsPlansUtilizationsByTime() ? this.savingsPlansUtilizationsByTime() : null).add("Total", (Object)this.total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SavingsPlansUtilizationsByTime": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansUtilizationsByTime()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationResponse, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime = DefaultSdkAutoConstructList.getInstance();
        private SavingsPlansUtilizationAggregates total;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationResponse model) {
            super(model);
            this.savingsPlansUtilizationsByTime(model.savingsPlansUtilizationsByTime);
            this.total(model.total);
        }

        public final Collection<SavingsPlansUtilizationByTime.Builder> getSavingsPlansUtilizationsByTime() {
            if (this.savingsPlansUtilizationsByTime instanceof SdkAutoConstructList) {
                return null;
            }
            return this.savingsPlansUtilizationsByTime != null ? (Collection)this.savingsPlansUtilizationsByTime.stream().map(SavingsPlansUtilizationByTime::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder savingsPlansUtilizationsByTime(Collection<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime = SavingsPlansUtilizationsByTimeCopier.copy(savingsPlansUtilizationsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationsByTime(SavingsPlansUtilizationByTime ... savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime(Arrays.asList(savingsPlansUtilizationsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationsByTime(Consumer<SavingsPlansUtilizationByTime.Builder> ... savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime(Stream.of(savingsPlansUtilizationsByTime).map(c -> (SavingsPlansUtilizationByTime)((SavingsPlansUtilizationByTime.Builder)SavingsPlansUtilizationByTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSavingsPlansUtilizationsByTime(Collection<SavingsPlansUtilizationByTime.BuilderImpl> savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime = SavingsPlansUtilizationsByTimeCopier.copyFromBuilder(savingsPlansUtilizationsByTime);
        }

        public final SavingsPlansUtilizationAggregates.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(SavingsPlansUtilizationAggregates total) {
            this.total = total;
            return this;
        }

        public final void setTotal(SavingsPlansUtilizationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public GetSavingsPlansUtilizationResponse build() {
            return new GetSavingsPlansUtilizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSavingsPlansUtilizationResponse> {
        public Builder savingsPlansUtilizationsByTime(Collection<SavingsPlansUtilizationByTime> var1);

        public Builder savingsPlansUtilizationsByTime(SavingsPlansUtilizationByTime ... var1);

        public Builder savingsPlansUtilizationsByTime(Consumer<SavingsPlansUtilizationByTime.Builder> ... var1);

        public Builder total(SavingsPlansUtilizationAggregates var1);

        default public Builder total(Consumer<SavingsPlansUtilizationAggregates.Builder> total) {
            return this.total((SavingsPlansUtilizationAggregates)((SavingsPlansUtilizationAggregates.Builder)SavingsPlansUtilizationAggregates.builder().applyMutation(total)).build());
        }
    }
}

