/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.ResourceDetails;
import software.amazon.awssdk.services.costexplorer.model.ResourceUtilization;
import software.amazon.awssdk.services.costexplorer.model.TagValues;
import software.amazon.awssdk.services.costexplorer.model.TagValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CurrentInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CurrentInstance> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(CurrentInstance.getter(CurrentInstance::resourceId)).setter(CurrentInstance.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceName").getter(CurrentInstance.getter(CurrentInstance::instanceName)).setter(CurrentInstance.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceName").build()}).build();
    private static final SdkField<List<TagValues>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CurrentInstance.getter(CurrentInstance::tags)).setter(CurrentInstance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(CurrentInstance.getter(CurrentInstance::resourceDetails)).setter(CurrentInstance.setter(Builder::resourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()}).build();
    private static final SdkField<ResourceUtilization> RESOURCE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceUtilization").getter(CurrentInstance.getter(CurrentInstance::resourceUtilization)).setter(CurrentInstance.setter(Builder::resourceUtilization)).constructor(ResourceUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUtilization").build()}).build();
    private static final SdkField<String> RESERVATION_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationCoveredHoursInLookbackPeriod").getter(CurrentInstance.getter(CurrentInstance::reservationCoveredHoursInLookbackPeriod)).setter(CurrentInstance.setter(Builder::reservationCoveredHoursInLookbackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationCoveredHoursInLookbackPeriod").build()}).build();
    private static final SdkField<String> SAVINGS_PLANS_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SavingsPlansCoveredHoursInLookbackPeriod").getter(CurrentInstance.getter(CurrentInstance::savingsPlansCoveredHoursInLookbackPeriod)).setter(CurrentInstance.setter(Builder::savingsPlansCoveredHoursInLookbackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansCoveredHoursInLookbackPeriod").build()}).build();
    private static final SdkField<String> ON_DEMAND_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnDemandHoursInLookbackPeriod").getter(CurrentInstance.getter(CurrentInstance::onDemandHoursInLookbackPeriod)).setter(CurrentInstance.setter(Builder::onDemandHoursInLookbackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandHoursInLookbackPeriod").build()}).build();
    private static final SdkField<String> TOTAL_RUNNING_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalRunningHoursInLookbackPeriod").getter(CurrentInstance.getter(CurrentInstance::totalRunningHoursInLookbackPeriod)).setter(CurrentInstance.setter(Builder::totalRunningHoursInLookbackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRunningHoursInLookbackPeriod").build()}).build();
    private static final SdkField<String> MONTHLY_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonthlyCost").getter(CurrentInstance.getter(CurrentInstance::monthlyCost)).setter(CurrentInstance.setter(Builder::monthlyCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyCost").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(CurrentInstance.getter(CurrentInstance::currencyCode)).setter(CurrentInstance.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, INSTANCE_NAME_FIELD, TAGS_FIELD, RESOURCE_DETAILS_FIELD, RESOURCE_UTILIZATION_FIELD, RESERVATION_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD, SAVINGS_PLANS_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD, ON_DEMAND_HOURS_IN_LOOKBACK_PERIOD_FIELD, TOTAL_RUNNING_HOURS_IN_LOOKBACK_PERIOD_FIELD, MONTHLY_COST_FIELD, CURRENCY_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String instanceName;
    private final List<TagValues> tags;
    private final ResourceDetails resourceDetails;
    private final ResourceUtilization resourceUtilization;
    private final String reservationCoveredHoursInLookbackPeriod;
    private final String savingsPlansCoveredHoursInLookbackPeriod;
    private final String onDemandHoursInLookbackPeriod;
    private final String totalRunningHoursInLookbackPeriod;
    private final String monthlyCost;
    private final String currencyCode;

    private CurrentInstance(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.instanceName = builder.instanceName;
        this.tags = builder.tags;
        this.resourceDetails = builder.resourceDetails;
        this.resourceUtilization = builder.resourceUtilization;
        this.reservationCoveredHoursInLookbackPeriod = builder.reservationCoveredHoursInLookbackPeriod;
        this.savingsPlansCoveredHoursInLookbackPeriod = builder.savingsPlansCoveredHoursInLookbackPeriod;
        this.onDemandHoursInLookbackPeriod = builder.onDemandHoursInLookbackPeriod;
        this.totalRunningHoursInLookbackPeriod = builder.totalRunningHoursInLookbackPeriod;
        this.monthlyCost = builder.monthlyCost;
        this.currencyCode = builder.currencyCode;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagValues> tags() {
        return this.tags;
    }

    public final ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public final ResourceUtilization resourceUtilization() {
        return this.resourceUtilization;
    }

    public final String reservationCoveredHoursInLookbackPeriod() {
        return this.reservationCoveredHoursInLookbackPeriod;
    }

    public final String savingsPlansCoveredHoursInLookbackPeriod() {
        return this.savingsPlansCoveredHoursInLookbackPeriod;
    }

    public final String onDemandHoursInLookbackPeriod() {
        return this.onDemandHoursInLookbackPeriod;
    }

    public final String totalRunningHoursInLookbackPeriod() {
        return this.totalRunningHoursInLookbackPeriod;
    }

    public final String monthlyCost() {
        return this.monthlyCost;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationCoveredHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansCoveredHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRunningHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentInstance)) {
            return false;
        }
        CurrentInstance other = (CurrentInstance)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.instanceName(), other.instanceName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.resourceUtilization(), other.resourceUtilization()) && Objects.equals(this.reservationCoveredHoursInLookbackPeriod(), other.reservationCoveredHoursInLookbackPeriod()) && Objects.equals(this.savingsPlansCoveredHoursInLookbackPeriod(), other.savingsPlansCoveredHoursInLookbackPeriod()) && Objects.equals(this.onDemandHoursInLookbackPeriod(), other.onDemandHoursInLookbackPeriod()) && Objects.equals(this.totalRunningHoursInLookbackPeriod(), other.totalRunningHoursInLookbackPeriod()) && Objects.equals(this.monthlyCost(), other.monthlyCost()) && Objects.equals(this.currencyCode(), other.currencyCode());
    }

    public final String toString() {
        return ToString.builder((String)"CurrentInstance").add("ResourceId", (Object)this.resourceId()).add("InstanceName", (Object)this.instanceName()).add("Tags", this.hasTags() ? this.tags() : null).add("ResourceDetails", (Object)this.resourceDetails()).add("ResourceUtilization", (Object)this.resourceUtilization()).add("ReservationCoveredHoursInLookbackPeriod", (Object)this.reservationCoveredHoursInLookbackPeriod()).add("SavingsPlansCoveredHoursInLookbackPeriod", (Object)this.savingsPlansCoveredHoursInLookbackPeriod()).add("OnDemandHoursInLookbackPeriod", (Object)this.onDemandHoursInLookbackPeriod()).add("TotalRunningHoursInLookbackPeriod", (Object)this.totalRunningHoursInLookbackPeriod()).add("MonthlyCost", (Object)this.monthlyCost()).add("CurrencyCode", (Object)this.currencyCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "InstanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "ResourceUtilization": {
                return Optional.ofNullable(clazz.cast(this.resourceUtilization()));
            }
            case "ReservationCoveredHoursInLookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.reservationCoveredHoursInLookbackPeriod()));
            }
            case "SavingsPlansCoveredHoursInLookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansCoveredHoursInLookbackPeriod()));
            }
            case "OnDemandHoursInLookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.onDemandHoursInLookbackPeriod()));
            }
            case "TotalRunningHoursInLookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.totalRunningHoursInLookbackPeriod()));
            }
            case "MonthlyCost": {
                return Optional.ofNullable(clazz.cast(this.monthlyCost()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CurrentInstance, T> g) {
        return obj -> g.apply((CurrentInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String instanceName;
        private List<TagValues> tags = DefaultSdkAutoConstructList.getInstance();
        private ResourceDetails resourceDetails;
        private ResourceUtilization resourceUtilization;
        private String reservationCoveredHoursInLookbackPeriod;
        private String savingsPlansCoveredHoursInLookbackPeriod;
        private String onDemandHoursInLookbackPeriod;
        private String totalRunningHoursInLookbackPeriod;
        private String monthlyCost;
        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentInstance model) {
            this.resourceId(model.resourceId);
            this.instanceName(model.instanceName);
            this.tags(model.tags);
            this.resourceDetails(model.resourceDetails);
            this.resourceUtilization(model.resourceUtilization);
            this.reservationCoveredHoursInLookbackPeriod(model.reservationCoveredHoursInLookbackPeriod);
            this.savingsPlansCoveredHoursInLookbackPeriod(model.savingsPlansCoveredHoursInLookbackPeriod);
            this.onDemandHoursInLookbackPeriod(model.onDemandHoursInLookbackPeriod);
            this.totalRunningHoursInLookbackPeriod(model.totalRunningHoursInLookbackPeriod);
            this.monthlyCost(model.monthlyCost);
            this.currencyCode(model.currencyCode);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final Collection<TagValues.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(TagValues::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagValues> tags) {
            this.tags = TagValuesListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagValues ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagValues.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagValues)((TagValues.Builder)TagValues.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagValues.BuilderImpl> tags) {
            this.tags = TagValuesListCopier.copyFromBuilder(tags);
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        public final ResourceUtilization.Builder getResourceUtilization() {
            return this.resourceUtilization != null ? this.resourceUtilization.toBuilder() : null;
        }

        @Override
        public final Builder resourceUtilization(ResourceUtilization resourceUtilization) {
            this.resourceUtilization = resourceUtilization;
            return this;
        }

        public final void setResourceUtilization(ResourceUtilization.BuilderImpl resourceUtilization) {
            this.resourceUtilization = resourceUtilization != null ? resourceUtilization.build() : null;
        }

        public final String getReservationCoveredHoursInLookbackPeriod() {
            return this.reservationCoveredHoursInLookbackPeriod;
        }

        @Override
        public final Builder reservationCoveredHoursInLookbackPeriod(String reservationCoveredHoursInLookbackPeriod) {
            this.reservationCoveredHoursInLookbackPeriod = reservationCoveredHoursInLookbackPeriod;
            return this;
        }

        public final void setReservationCoveredHoursInLookbackPeriod(String reservationCoveredHoursInLookbackPeriod) {
            this.reservationCoveredHoursInLookbackPeriod = reservationCoveredHoursInLookbackPeriod;
        }

        public final String getSavingsPlansCoveredHoursInLookbackPeriod() {
            return this.savingsPlansCoveredHoursInLookbackPeriod;
        }

        @Override
        public final Builder savingsPlansCoveredHoursInLookbackPeriod(String savingsPlansCoveredHoursInLookbackPeriod) {
            this.savingsPlansCoveredHoursInLookbackPeriod = savingsPlansCoveredHoursInLookbackPeriod;
            return this;
        }

        public final void setSavingsPlansCoveredHoursInLookbackPeriod(String savingsPlansCoveredHoursInLookbackPeriod) {
            this.savingsPlansCoveredHoursInLookbackPeriod = savingsPlansCoveredHoursInLookbackPeriod;
        }

        public final String getOnDemandHoursInLookbackPeriod() {
            return this.onDemandHoursInLookbackPeriod;
        }

        @Override
        public final Builder onDemandHoursInLookbackPeriod(String onDemandHoursInLookbackPeriod) {
            this.onDemandHoursInLookbackPeriod = onDemandHoursInLookbackPeriod;
            return this;
        }

        public final void setOnDemandHoursInLookbackPeriod(String onDemandHoursInLookbackPeriod) {
            this.onDemandHoursInLookbackPeriod = onDemandHoursInLookbackPeriod;
        }

        public final String getTotalRunningHoursInLookbackPeriod() {
            return this.totalRunningHoursInLookbackPeriod;
        }

        @Override
        public final Builder totalRunningHoursInLookbackPeriod(String totalRunningHoursInLookbackPeriod) {
            this.totalRunningHoursInLookbackPeriod = totalRunningHoursInLookbackPeriod;
            return this;
        }

        public final void setTotalRunningHoursInLookbackPeriod(String totalRunningHoursInLookbackPeriod) {
            this.totalRunningHoursInLookbackPeriod = totalRunningHoursInLookbackPeriod;
        }

        public final String getMonthlyCost() {
            return this.monthlyCost;
        }

        @Override
        public final Builder monthlyCost(String monthlyCost) {
            this.monthlyCost = monthlyCost;
            return this;
        }

        public final void setMonthlyCost(String monthlyCost) {
            this.monthlyCost = monthlyCost;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public CurrentInstance build() {
            return new CurrentInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CurrentInstance> {
        public Builder resourceId(String var1);

        public Builder instanceName(String var1);

        public Builder tags(Collection<TagValues> var1);

        public Builder tags(TagValues ... var1);

        public Builder tags(Consumer<TagValues.Builder> ... var1);

        public Builder resourceDetails(ResourceDetails var1);

        default public Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(resourceDetails)).build());
        }

        public Builder resourceUtilization(ResourceUtilization var1);

        default public Builder resourceUtilization(Consumer<ResourceUtilization.Builder> resourceUtilization) {
            return this.resourceUtilization((ResourceUtilization)((ResourceUtilization.Builder)ResourceUtilization.builder().applyMutation(resourceUtilization)).build());
        }

        public Builder reservationCoveredHoursInLookbackPeriod(String var1);

        public Builder savingsPlansCoveredHoursInLookbackPeriod(String var1);

        public Builder onDemandHoursInLookbackPeriod(String var1);

        public Builder totalRunningHoursInLookbackPeriod(String var1);

        public Builder monthlyCost(String var1);

        public Builder currencyCode(String var1);
    }
}

