/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnomalyMonitorRequest extends CostExplorerRequest implements
        ToCopyableBuilder<UpdateAnomalyMonitorRequest.Builder, UpdateAnomalyMonitorRequest> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(UpdateAnomalyMonitorRequest::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorName").getter(getter(UpdateAnomalyMonitorRequest::monitorName))
            .setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD,
            MONITOR_NAME_FIELD));

    private final String monitorArn;

    private final String monitorName;

    private UpdateAnomalyMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
    }

    /**
     * <p>
     * Cost anomaly monitor Amazon Resource Names (ARNs).
     * </p>
     * 
     * @return Cost anomaly monitor Amazon Resource Names (ARNs).
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The new name for the cost anomaly monitor.
     * </p>
     * 
     * @return The new name for the cost anomaly monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalyMonitorRequest)) {
            return false;
        }
        UpdateAnomalyMonitorRequest other = (UpdateAnomalyMonitorRequest) obj;
        return Objects.equals(monitorArn(), other.monitorArn()) && Objects.equals(monitorName(), other.monitorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnomalyMonitorRequest").add("MonitorArn", monitorArn()).add("MonitorName", monitorName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "MonitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalyMonitorRequest, T> g) {
        return obj -> g.apply((UpdateAnomalyMonitorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAnomalyMonitorRequest> {
        /**
         * <p>
         * Cost anomaly monitor Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param monitorArn
         *        Cost anomaly monitor Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The new name for the cost anomaly monitor.
         * </p>
         * 
         * @param monitorName
         *        The new name for the cost anomaly monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String monitorArn;

        private String monitorName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalyMonitorRequest model) {
            super(model);
            monitorArn(model.monitorArn);
            monitorName(model.monitorName);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        public final String getMonitorName() {
            return monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalyMonitorRequest build() {
            return new UpdateAnomalyMonitorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
