/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result that is associated with a time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultByTime implements SdkPojo, Serializable, ToCopyableBuilder<ResultByTime.Builder, ResultByTime> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(ResultByTime::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<Map<String, MetricValue>> TOTAL_FIELD = SdkField
            .<Map<String, MetricValue>> builder(MarshallingType.MAP)
            .memberName("Total")
            .getter(getter(ResultByTime::total))
            .setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MetricValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Group>> GROUPS_FIELD = SdkField
            .<List<Group>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(ResultByTime::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Group> builder(MarshallingType.SDK_POJO)
                                            .constructor(Group::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ESTIMATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Estimated").getter(getter(ResultByTime::estimated)).setter(setter(Builder::estimated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Estimated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            TOTAL_FIELD, GROUPS_FIELD, ESTIMATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final DateInterval timePeriod;

    private final Map<String, MetricValue> total;

    private final List<Group> groups;

    private final Boolean estimated;

    private ResultByTime(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.total = builder.total;
        this.groups = builder.groups;
        this.estimated = builder.estimated;
    }

    /**
     * <p>
     * The time period that the result covers.
     * </p>
     * 
     * @return The time period that the result covers.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * Returns true if the Total property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTotal() {
        return total != null && !(total instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The total amount of cost or usage accrued during the time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTotal()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The total amount of cost or usage accrued during the time period.
     */
    public final Map<String, MetricValue> total() {
        return total;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups that this time period includes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The groups that this time period includes.
     */
    public final List<Group> groups() {
        return groups;
    }

    /**
     * <p>
     * Whether the result is estimated.
     * </p>
     * 
     * @return Whether the result is estimated.
     */
    public final Boolean estimated() {
        return estimated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasTotal() ? total() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(estimated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultByTime)) {
            return false;
        }
        ResultByTime other = (ResultByTime) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && hasTotal() == other.hasTotal()
                && Objects.equals(total(), other.total()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && Objects.equals(estimated(), other.estimated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultByTime").add("TimePeriod", timePeriod()).add("Total", hasTotal() ? total() : null)
                .add("Groups", hasGroups() ? groups() : null).add("Estimated", estimated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Estimated":
            return Optional.ofNullable(clazz.cast(estimated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultByTime, T> g) {
        return obj -> g.apply((ResultByTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultByTime> {
        /**
         * <p>
         * The time period that the result covers.
         * </p>
         * 
         * @param timePeriod
         *        The time period that the result covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The time period that the result covers.
         * </p>
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The total amount of cost or usage accrued during the time period.
         * </p>
         * 
         * @param total
         *        The total amount of cost or usage accrued during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Map<String, MetricValue> total);

        /**
         * <p>
         * The groups that this time period includes.
         * </p>
         * 
         * @param groups
         *        The groups that this time period includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<Group> groups);

        /**
         * <p>
         * The groups that this time period includes.
         * </p>
         * 
         * @param groups
         *        The groups that this time period includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Group... groups);

        /**
         * <p>
         * The groups that this time period includes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Group>.Builder} avoiding the need to create
         * one manually via {@link List<Group>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Group>.Builder#build()} is called immediately and its result
         * is passed to {@link #groups(List<Group>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<Group>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<Group>)
         */
        Builder groups(Consumer<Group.Builder>... groups);

        /**
         * <p>
         * Whether the result is estimated.
         * </p>
         * 
         * @param estimated
         *        Whether the result is estimated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimated(Boolean estimated);
    }

    static final class BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private Map<String, MetricValue> total = DefaultSdkAutoConstructMap.getInstance();

        private List<Group> groups = DefaultSdkAutoConstructList.getInstance();

        private Boolean estimated;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultByTime model) {
            timePeriod(model.timePeriod);
            total(model.total);
            groups(model.groups);
            estimated(model.estimated);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final Map<String, MetricValue.Builder> getTotal() {
            if (total instanceof SdkAutoConstructMap) {
                return null;
            }
            return total != null ? CollectionUtils.mapValues(total, MetricValue::toBuilder) : null;
        }

        @Override
        public final Builder total(Map<String, MetricValue> total) {
            this.total = MetricsCopier.copy(total);
            return this;
        }

        public final void setTotal(Map<String, MetricValue.BuilderImpl> total) {
            this.total = MetricsCopier.copyFromBuilder(total);
        }

        public final Collection<Group.Builder> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups != null ? groups.stream().map(Group::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<Group> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Group... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<Group.Builder>... groups) {
            groups(Stream.of(groups).map(c -> Group.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<Group.BuilderImpl> groups) {
            this.groups = GroupsCopier.copyFromBuilder(groups);
        }

        public final Boolean getEstimated() {
            return estimated;
        }

        @Override
        public final Builder estimated(Boolean estimated) {
            this.estimated = estimated;
            return this;
        }

        public final void setEstimated(Boolean estimated) {
            this.estimated = estimated;
        }

        @Override
        public ResultByTime build() {
            return new ResultByTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
