/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resource utilization of current resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceUtilization.Builder, ResourceUtilization> {
    private static final SdkField<EC2ResourceUtilization> EC2_RESOURCE_UTILIZATION_FIELD = SdkField
            .<EC2ResourceUtilization> builder(MarshallingType.SDK_POJO).memberName("EC2ResourceUtilization")
            .getter(getter(ResourceUtilization::ec2ResourceUtilization)).setter(setter(Builder::ec2ResourceUtilization))
            .constructor(EC2ResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ResourceUtilization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EC2_RESOURCE_UTILIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final EC2ResourceUtilization ec2ResourceUtilization;

    private ResourceUtilization(BuilderImpl builder) {
        this.ec2ResourceUtilization = builder.ec2ResourceUtilization;
    }

    /**
     * <p>
     * Utilization of current Amazon EC2 instance.
     * </p>
     * 
     * @return Utilization of current Amazon EC2 instance.
     */
    public final EC2ResourceUtilization ec2ResourceUtilization() {
        return ec2ResourceUtilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2ResourceUtilization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceUtilization)) {
            return false;
        }
        ResourceUtilization other = (ResourceUtilization) obj;
        return Objects.equals(ec2ResourceUtilization(), other.ec2ResourceUtilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceUtilization").add("EC2ResourceUtilization", ec2ResourceUtilization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2ResourceUtilization":
            return Optional.ofNullable(clazz.cast(ec2ResourceUtilization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceUtilization, T> g) {
        return obj -> g.apply((ResourceUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceUtilization> {
        /**
         * <p>
         * Utilization of current Amazon EC2 instance.
         * </p>
         * 
         * @param ec2ResourceUtilization
         *        Utilization of current Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ResourceUtilization(EC2ResourceUtilization ec2ResourceUtilization);

        /**
         * <p>
         * Utilization of current Amazon EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2ResourceUtilization.Builder} avoiding the
         * need to create one manually via {@link EC2ResourceUtilization#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2ResourceUtilization.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2ResourceUtilization(EC2ResourceUtilization)}.
         * 
         * @param ec2ResourceUtilization
         *        a consumer that will call methods on {@link EC2ResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2ResourceUtilization(EC2ResourceUtilization)
         */
        default Builder ec2ResourceUtilization(Consumer<EC2ResourceUtilization.Builder> ec2ResourceUtilization) {
            return ec2ResourceUtilization(EC2ResourceUtilization.builder().applyMutation(ec2ResourceUtilization).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EC2ResourceUtilization ec2ResourceUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceUtilization model) {
            ec2ResourceUtilization(model.ec2ResourceUtilization);
        }

        public final EC2ResourceUtilization.Builder getEc2ResourceUtilization() {
            return ec2ResourceUtilization != null ? ec2ResourceUtilization.toBuilder() : null;
        }

        @Override
        public final Builder ec2ResourceUtilization(EC2ResourceUtilization ec2ResourceUtilization) {
            this.ec2ResourceUtilization = ec2ResourceUtilization;
            return this;
        }

        public final void setEc2ResourceUtilization(EC2ResourceUtilization.BuilderImpl ec2ResourceUtilization) {
            this.ec2ResourceUtilization = ec2ResourceUtilization != null ? ec2ResourceUtilization.build() : null;
        }

        @Override
        public ResourceUtilization build() {
            return new ResourceUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
