/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Amazon EC2 instances that AWS recommends that you purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2InstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2InstanceDetails.Builder, EC2InstanceDetails> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Family")
            .getter(getter(EC2InstanceDetails::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(EC2InstanceDetails::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(EC2InstanceDetails::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(EC2InstanceDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(EC2InstanceDetails::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(EC2InstanceDetails::tenancy)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CurrentGeneration").getter(getter(EC2InstanceDetails::currentGeneration))
            .setter(setter(Builder::currentGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()).build();

    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SizeFlexEligible").getter(getter(EC2InstanceDetails::sizeFlexEligible))
            .setter(setter(Builder::sizeFlexEligible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD,
            INSTANCE_TYPE_FIELD, REGION_FIELD, AVAILABILITY_ZONE_FIELD, PLATFORM_FIELD, TENANCY_FIELD, CURRENT_GENERATION_FIELD,
            SIZE_FLEX_ELIGIBLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String family;

    private final String instanceType;

    private final String region;

    private final String availabilityZone;

    private final String platform;

    private final String tenancy;

    private final Boolean currentGeneration;

    private final Boolean sizeFlexEligible;

    private EC2InstanceDetails(BuilderImpl builder) {
        this.family = builder.family;
        this.instanceType = builder.instanceType;
        this.region = builder.region;
        this.availabilityZone = builder.availabilityZone;
        this.platform = builder.platform;
        this.tenancy = builder.tenancy;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    /**
     * <p>
     * The instance family of the recommended reservation.
     * </p>
     * 
     * @return The instance family of the recommended reservation.
     */
    public final String family() {
        return family;
    }

    /**
     * <p>
     * The type of instance that AWS recommends.
     * </p>
     * 
     * @return The type of instance that AWS recommends.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The AWS Region of the recommended reservation.
     * </p>
     * 
     * @return The AWS Region of the recommended reservation.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The Availability Zone of the recommended reservation.
     * </p>
     * 
     * @return The Availability Zone of the recommended reservation.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The platform of the recommended reservation. The platform is the specific combination of operating system,
     * license model, and software on an instance.
     * </p>
     * 
     * @return The platform of the recommended reservation. The platform is the specific combination of operating
     *         system, license model, and software on an instance.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * Whether the recommended reservation is dedicated or shared.
     * </p>
     * 
     * @return Whether the recommended reservation is dedicated or shared.
     */
    public final String tenancy() {
        return tenancy;
    }

    /**
     * <p>
     * Whether the recommendation is for a current-generation instance.
     * </p>
     * 
     * @return Whether the recommendation is for a current-generation instance.
     */
    public final Boolean currentGeneration() {
        return currentGeneration;
    }

    /**
     * <p>
     * Whether the recommended reservation is size flexible.
     * </p>
     * 
     * @return Whether the recommended reservation is size flexible.
     */
    public final Boolean sizeFlexEligible() {
        return sizeFlexEligible;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(tenancy());
        hashCode = 31 * hashCode + Objects.hashCode(currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(sizeFlexEligible());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceDetails)) {
            return false;
        }
        EC2InstanceDetails other = (EC2InstanceDetails) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(region(), other.region()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(platform(), other.platform()) && Objects.equals(tenancy(), other.tenancy())
                && Objects.equals(currentGeneration(), other.currentGeneration())
                && Objects.equals(sizeFlexEligible(), other.sizeFlexEligible());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2InstanceDetails").add("Family", family()).add("InstanceType", instanceType())
                .add("Region", region()).add("AvailabilityZone", availabilityZone()).add("Platform", platform())
                .add("Tenancy", tenancy()).add("CurrentGeneration", currentGeneration())
                .add("SizeFlexEligible", sizeFlexEligible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Family":
            return Optional.ofNullable(clazz.cast(family()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancy()));
        case "CurrentGeneration":
            return Optional.ofNullable(clazz.cast(currentGeneration()));
        case "SizeFlexEligible":
            return Optional.ofNullable(clazz.cast(sizeFlexEligible()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceDetails, T> g) {
        return obj -> g.apply((EC2InstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2InstanceDetails> {
        /**
         * <p>
         * The instance family of the recommended reservation.
         * </p>
         * 
         * @param family
         *        The instance family of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The type of instance that AWS recommends.
         * </p>
         * 
         * @param instanceType
         *        The type of instance that AWS recommends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The AWS Region of the recommended reservation.
         * </p>
         * 
         * @param region
         *        The AWS Region of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The Availability Zone of the recommended reservation.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The platform of the recommended reservation. The platform is the specific combination of operating system,
         * license model, and software on an instance.
         * </p>
         * 
         * @param platform
         *        The platform of the recommended reservation. The platform is the specific combination of operating
         *        system, license model, and software on an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * Whether the recommended reservation is dedicated or shared.
         * </p>
         * 
         * @param tenancy
         *        Whether the recommended reservation is dedicated or shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Whether the recommendation is for a current-generation instance.
         * </p>
         * 
         * @param currentGeneration
         *        Whether the recommendation is for a current-generation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentGeneration(Boolean currentGeneration);

        /**
         * <p>
         * Whether the recommended reservation is size flexible.
         * </p>
         * 
         * @param sizeFlexEligible
         *        Whether the recommended reservation is size flexible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeFlexEligible(Boolean sizeFlexEligible);
    }

    static final class BuilderImpl implements Builder {
        private String family;

        private String instanceType;

        private String region;

        private String availabilityZone;

        private String platform;

        private String tenancy;

        private Boolean currentGeneration;

        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceDetails model) {
            family(model.family);
            instanceType(model.instanceType);
            region(model.region);
            availabilityZone(model.availabilityZone);
            platform(model.platform);
            tenancy(model.tenancy);
            currentGeneration(model.currentGeneration);
            sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getFamily() {
            return family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final Boolean getCurrentGeneration() {
            return currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        public final Boolean getSizeFlexEligible() {
            return sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        @Override
        public EC2InstanceDetails build() {
            return new EC2InstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
