/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatusListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostCategoryReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostCategoryReference> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CostCategoryArn").getter(CostCategoryReference.getter(CostCategoryReference::costCategoryArn)).setter(CostCategoryReference.setter(Builder::costCategoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CostCategoryReference.getter(CostCategoryReference::name)).setter(CostCategoryReference.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveStart").getter(CostCategoryReference.getter(CostCategoryReference::effectiveStart)).setter(CostCategoryReference.setter(Builder::effectiveStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()}).build();
    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveEnd").getter(CostCategoryReference.getter(CostCategoryReference::effectiveEnd)).setter(CostCategoryReference.setter(Builder::effectiveEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfRules").getter(CostCategoryReference.getter(CostCategoryReference::numberOfRules)).setter(CostCategoryReference.setter(Builder::numberOfRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfRules").build()}).build();
    private static final SdkField<List<CostCategoryProcessingStatus>> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessingStatus").getter(CostCategoryReference.getter(CostCategoryReference::processingStatus)).setter(CostCategoryReference.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryProcessingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(CostCategoryReference.getter(CostCategoryReference::values)).setter(CostCategoryReference.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD, NAME_FIELD, EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, NUMBER_OF_RULES_FIELD, PROCESSING_STATUS_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String costCategoryArn;
    private final String name;
    private final String effectiveStart;
    private final String effectiveEnd;
    private final Integer numberOfRules;
    private final List<CostCategoryProcessingStatus> processingStatus;
    private final List<String> values;

    private CostCategoryReference(BuilderImpl builder) {
        this.costCategoryArn = builder.costCategoryArn;
        this.name = builder.name;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.numberOfRules = builder.numberOfRules;
        this.processingStatus = builder.processingStatus;
        this.values = builder.values;
    }

    public String costCategoryArn() {
        return this.costCategoryArn;
    }

    public String name() {
        return this.name;
    }

    public String effectiveStart() {
        return this.effectiveStart;
    }

    public String effectiveEnd() {
        return this.effectiveEnd;
    }

    public Integer numberOfRules() {
        return this.numberOfRules;
    }

    public boolean hasProcessingStatus() {
        return this.processingStatus != null && !(this.processingStatus instanceof SdkAutoConstructList);
    }

    public List<CostCategoryProcessingStatus> processingStatus() {
        return this.processingStatus;
    }

    public boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryReference)) {
            return false;
        }
        CostCategoryReference other = (CostCategoryReference)obj;
        return Objects.equals(this.costCategoryArn(), other.costCategoryArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.effectiveStart(), other.effectiveStart()) && Objects.equals(this.effectiveEnd(), other.effectiveEnd()) && Objects.equals(this.numberOfRules(), other.numberOfRules()) && Objects.equals(this.processingStatus(), other.processingStatus()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"CostCategoryReference").add("CostCategoryArn", (Object)this.costCategoryArn()).add("Name", (Object)this.name()).add("EffectiveStart", (Object)this.effectiveStart()).add("EffectiveEnd", (Object)this.effectiveEnd()).add("NumberOfRules", (Object)this.numberOfRules()).add("ProcessingStatus", this.processingStatus()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostCategoryArn": {
                return Optional.ofNullable(clazz.cast(this.costCategoryArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EffectiveStart": {
                return Optional.ofNullable(clazz.cast(this.effectiveStart()));
            }
            case "EffectiveEnd": {
                return Optional.ofNullable(clazz.cast(this.effectiveEnd()));
            }
            case "NumberOfRules": {
                return Optional.ofNullable(clazz.cast(this.numberOfRules()));
            }
            case "ProcessingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatus()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryReference, T> g) {
        return obj -> g.apply((CostCategoryReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String costCategoryArn;
        private String name;
        private String effectiveStart;
        private String effectiveEnd;
        private Integer numberOfRules;
        private List<CostCategoryProcessingStatus> processingStatus = DefaultSdkAutoConstructList.getInstance();
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryReference model) {
            this.costCategoryArn(model.costCategoryArn);
            this.name(model.name);
            this.effectiveStart(model.effectiveStart);
            this.effectiveEnd(model.effectiveEnd);
            this.numberOfRules(model.numberOfRules);
            this.processingStatus(model.processingStatus);
            this.values(model.values);
        }

        public final String getCostCategoryArn() {
            return this.costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEffectiveStart() {
            return this.effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        public final String getEffectiveEnd() {
            return this.effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        public final Integer getNumberOfRules() {
            return this.numberOfRules;
        }

        @Override
        public final Builder numberOfRules(Integer numberOfRules) {
            this.numberOfRules = numberOfRules;
            return this;
        }

        public final void setNumberOfRules(Integer numberOfRules) {
            this.numberOfRules = numberOfRules;
        }

        public final Collection<CostCategoryProcessingStatus.Builder> getProcessingStatus() {
            return this.processingStatus != null ? (Collection)this.processingStatus.stream().map(CostCategoryProcessingStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processingStatus(Collection<CostCategoryProcessingStatus> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copy(processingStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(CostCategoryProcessingStatus ... processingStatus) {
            this.processingStatus(Arrays.asList(processingStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder> ... processingStatus) {
            this.processingStatus(Stream.of(processingStatus).map(c -> (CostCategoryProcessingStatus)((CostCategoryProcessingStatus.Builder)CostCategoryProcessingStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessingStatus(Collection<CostCategoryProcessingStatus.BuilderImpl> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copyFromBuilder(processingStatus);
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = CostCategoryValuesListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = CostCategoryValuesListCopier.copy(values);
        }

        public CostCategoryReference build() {
            return new CostCategoryReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostCategoryReference> {
        public Builder costCategoryArn(String var1);

        public Builder name(String var1);

        public Builder effectiveStart(String var1);

        public Builder effectiveEnd(String var1);

        public Builder numberOfRules(Integer var1);

        public Builder processingStatus(Collection<CostCategoryProcessingStatus> var1);

        public Builder processingStatus(CostCategoryProcessingStatus ... var1);

        public Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder> ... var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

