/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.ForecastResult;
import software.amazon.awssdk.services.costexplorer.model.ForecastResultsByTimeCopier;
import software.amazon.awssdk.services.costexplorer.model.MetricValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUsageForecastResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetUsageForecastResponse> {
    private static final SdkField<MetricValue> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Total").getter(GetUsageForecastResponse.getter(GetUsageForecastResponse::total)).setter(GetUsageForecastResponse.setter(Builder::total)).constructor(MetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final SdkField<List<ForecastResult>> FORECAST_RESULTS_BY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastResultsByTime").getter(GetUsageForecastResponse.getter(GetUsageForecastResponse::forecastResultsByTime)).setter(GetUsageForecastResponse.setter(Builder::forecastResultsByTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastResultsByTime").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ForecastResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, FORECAST_RESULTS_BY_TIME_FIELD));
    private final MetricValue total;
    private final List<ForecastResult> forecastResultsByTime;

    private GetUsageForecastResponse(BuilderImpl builder) {
        super(builder);
        this.total = builder.total;
        this.forecastResultsByTime = builder.forecastResultsByTime;
    }

    public final MetricValue total() {
        return this.total;
    }

    public final boolean hasForecastResultsByTime() {
        return this.forecastResultsByTime != null && !(this.forecastResultsByTime instanceof SdkAutoConstructList);
    }

    public final List<ForecastResult> forecastResultsByTime() {
        return this.forecastResultsByTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastResultsByTime() ? this.forecastResultsByTime() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageForecastResponse)) {
            return false;
        }
        GetUsageForecastResponse other = (GetUsageForecastResponse)((Object)obj);
        return Objects.equals(this.total(), other.total()) && this.hasForecastResultsByTime() == other.hasForecastResultsByTime() && Objects.equals(this.forecastResultsByTime(), other.forecastResultsByTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetUsageForecastResponse").add("Total", (Object)this.total()).add("ForecastResultsByTime", this.hasForecastResultsByTime() ? this.forecastResultsByTime() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "ForecastResultsByTime": {
                return Optional.ofNullable(clazz.cast(this.forecastResultsByTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageForecastResponse, T> g) {
        return obj -> g.apply((GetUsageForecastResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private MetricValue total;
        private List<ForecastResult> forecastResultsByTime = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageForecastResponse model) {
            super(model);
            this.total(model.total);
            this.forecastResultsByTime(model.forecastResultsByTime);
        }

        public final MetricValue.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(MetricValue total) {
            this.total = total;
            return this;
        }

        public final void setTotal(MetricValue.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public final Collection<ForecastResult.Builder> getForecastResultsByTime() {
            if (this.forecastResultsByTime instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastResultsByTime != null ? (Collection)this.forecastResultsByTime.stream().map(ForecastResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder forecastResultsByTime(Collection<ForecastResult> forecastResultsByTime) {
            this.forecastResultsByTime = ForecastResultsByTimeCopier.copy(forecastResultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastResultsByTime(ForecastResult ... forecastResultsByTime) {
            this.forecastResultsByTime(Arrays.asList(forecastResultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastResultsByTime(Consumer<ForecastResult.Builder> ... forecastResultsByTime) {
            this.forecastResultsByTime(Stream.of(forecastResultsByTime).map(c -> (ForecastResult)((ForecastResult.Builder)ForecastResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setForecastResultsByTime(Collection<ForecastResult.BuilderImpl> forecastResultsByTime) {
            this.forecastResultsByTime = ForecastResultsByTimeCopier.copyFromBuilder(forecastResultsByTime);
        }

        @Override
        public GetUsageForecastResponse build() {
            return new GetUsageForecastResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUsageForecastResponse> {
        public Builder total(MetricValue var1);

        default public Builder total(Consumer<MetricValue.Builder> total) {
            return this.total((MetricValue)((MetricValue.Builder)MetricValue.builder().applyMutation(total)).build());
        }

        public Builder forecastResultsByTime(Collection<ForecastResult> var1);

        public Builder forecastResultsByTime(ForecastResult ... var1);

        public Builder forecastResultsByTime(Consumer<ForecastResult.Builder> ... var1);
    }
}

