/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRule;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostCategory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostCategory> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CostCategoryArn").getter(CostCategory.getter(CostCategory::costCategoryArn)).setter(CostCategory.setter(Builder::costCategoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()}).build();
    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveStart").getter(CostCategory.getter(CostCategory::effectiveStart)).setter(CostCategory.setter(Builder::effectiveStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()}).build();
    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveEnd").getter(CostCategory.getter(CostCategory::effectiveEnd)).setter(CostCategory.setter(Builder::effectiveEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CostCategory.getter(CostCategory::name)).setter(CostCategory.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleVersion").getter(CostCategory.getter(CostCategory::ruleVersionAsString)).setter(CostCategory.setter(Builder::ruleVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()}).build();
    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(CostCategory.getter(CostCategory::rules)).setter(CostCategory.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD, EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, NAME_FIELD, RULE_VERSION_FIELD, RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String costCategoryArn;
    private final String effectiveStart;
    private final String effectiveEnd;
    private final String name;
    private final String ruleVersion;
    private final List<CostCategoryRule> rules;

    private CostCategory(BuilderImpl builder) {
        this.costCategoryArn = builder.costCategoryArn;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.name = builder.name;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
    }

    public String costCategoryArn() {
        return this.costCategoryArn;
    }

    public String effectiveStart() {
        return this.effectiveStart;
    }

    public String effectiveEnd() {
        return this.effectiveEnd;
    }

    public String name() {
        return this.name;
    }

    public CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(this.ruleVersion);
    }

    public String ruleVersionAsString() {
        return this.ruleVersion;
    }

    public boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public List<CostCategoryRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategory)) {
            return false;
        }
        CostCategory other = (CostCategory)obj;
        return Objects.equals(this.costCategoryArn(), other.costCategoryArn()) && Objects.equals(this.effectiveStart(), other.effectiveStart()) && Objects.equals(this.effectiveEnd(), other.effectiveEnd()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleVersionAsString(), other.ruleVersionAsString()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"CostCategory").add("CostCategoryArn", (Object)this.costCategoryArn()).add("EffectiveStart", (Object)this.effectiveStart()).add("EffectiveEnd", (Object)this.effectiveEnd()).add("Name", (Object)this.name()).add("RuleVersion", (Object)this.ruleVersionAsString()).add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostCategoryArn": {
                return Optional.ofNullable(clazz.cast(this.costCategoryArn()));
            }
            case "EffectiveStart": {
                return Optional.ofNullable(clazz.cast(this.effectiveStart()));
            }
            case "EffectiveEnd": {
                return Optional.ofNullable(clazz.cast(this.effectiveEnd()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleVersion": {
                return Optional.ofNullable(clazz.cast(this.ruleVersionAsString()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategory, T> g) {
        return obj -> g.apply((CostCategory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String costCategoryArn;
        private String effectiveStart;
        private String effectiveEnd;
        private String name;
        private String ruleVersion;
        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategory model) {
            this.costCategoryArn(model.costCategoryArn);
            this.effectiveStart(model.effectiveStart);
            this.effectiveEnd(model.effectiveEnd);
            this.name(model.name);
            this.ruleVersion(model.ruleVersion);
            this.rules(model.rules);
        }

        public final String getCostCategoryArn() {
            return this.costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getEffectiveStart() {
            return this.effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        public final String getEffectiveEnd() {
            return this.effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRuleVersion() {
            return this.ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        public final Collection<CostCategoryRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(CostCategoryRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (CostCategoryRule)((CostCategoryRule.Builder)CostCategoryRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        public CostCategory build() {
            return new CostCategory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostCategory> {
        public Builder costCategoryArn(String var1);

        public Builder effectiveStart(String var1);

        public Builder effectiveEnd(String var1);

        public Builder name(String var1);

        public Builder ruleVersion(String var1);

        public Builder ruleVersion(CostCategoryRuleVersion var1);

        public Builder rules(Collection<CostCategoryRule> var1);

        public Builder rules(CostCategoryRule ... var1);

        public Builder rules(Consumer<CostCategoryRule.Builder> ... var1);
    }
}

