/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RootCause
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RootCause> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RootCause.getter(RootCause::service)).setter(RootCause.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RootCause.getter(RootCause::region)).setter(RootCause.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> LINKED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RootCause.getter(RootCause::linkedAccount)).setter(RootCause.setter(Builder::linkedAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedAccount").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RootCause.getter(RootCause::usageType)).setter(RootCause.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, REGION_FIELD, LINKED_ACCOUNT_FIELD, USAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String service;
    private final String region;
    private final String linkedAccount;
    private final String usageType;

    private RootCause(BuilderImpl builder) {
        this.service = builder.service;
        this.region = builder.region;
        this.linkedAccount = builder.linkedAccount;
        this.usageType = builder.usageType;
    }

    public String service() {
        return this.service;
    }

    public String region() {
        return this.region;
    }

    public String linkedAccount() {
        return this.linkedAccount;
    }

    public String usageType() {
        return this.usageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RootCause)) {
            return false;
        }
        RootCause other = (RootCause)obj;
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.linkedAccount(), other.linkedAccount()) && Objects.equals(this.usageType(), other.usageType());
    }

    public String toString() {
        return ToString.builder((String)"RootCause").add("Service", (Object)this.service()).add("Region", (Object)this.region()).add("LinkedAccount", (Object)this.linkedAccount()).add("UsageType", (Object)this.usageType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "LinkedAccount": {
                return Optional.ofNullable(clazz.cast(this.linkedAccount()));
            }
            case "UsageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RootCause, T> g) {
        return obj -> g.apply((RootCause)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String service;
        private String region;
        private String linkedAccount;
        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(RootCause model) {
            this.service(model.service);
            this.region(model.region);
            this.linkedAccount(model.linkedAccount);
            this.usageType(model.usageType);
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLinkedAccount() {
            return this.linkedAccount;
        }

        @Override
        public final Builder linkedAccount(String linkedAccount) {
            this.linkedAccount = linkedAccount;
            return this;
        }

        public final void setLinkedAccount(String linkedAccount) {
            this.linkedAccount = linkedAccount;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        public RootCause build() {
            return new RootCause(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RootCause> {
        public Builder service(String var1);

        public Builder region(String var1);

        public Builder linkedAccount(String var1);

        public Builder usageType(String var1);
    }
}

