/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomalyFeedbackType;
import software.amazon.awssdk.services.costexplorer.model.AnomalyScore;
import software.amazon.awssdk.services.costexplorer.model.Impact;
import software.amazon.awssdk.services.costexplorer.model.RootCause;
import software.amazon.awssdk.services.costexplorer.model.RootCausesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Anomaly
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Anomaly> {
    private static final SdkField<String> ANOMALY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Anomaly.getter(Anomaly::anomalyId)).setter(Anomaly.setter(Builder::anomalyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyId").build()}).build();
    private static final SdkField<String> ANOMALY_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Anomaly.getter(Anomaly::anomalyStartDate)).setter(Anomaly.setter(Builder::anomalyStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyStartDate").build()}).build();
    private static final SdkField<String> ANOMALY_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Anomaly.getter(Anomaly::anomalyEndDate)).setter(Anomaly.setter(Builder::anomalyEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyEndDate").build()}).build();
    private static final SdkField<String> DIMENSION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Anomaly.getter(Anomaly::dimensionValue)).setter(Anomaly.setter(Builder::dimensionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValue").build()}).build();
    private static final SdkField<List<RootCause>> ROOT_CAUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Anomaly.getter(Anomaly::rootCauses)).setter(Anomaly.setter(Builder::rootCauses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootCauses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RootCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnomalyScore> ANOMALY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Anomaly.getter(Anomaly::anomalyScore)).setter(Anomaly.setter(Builder::anomalyScore)).constructor(AnomalyScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyScore").build()}).build();
    private static final SdkField<Impact> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Anomaly.getter(Anomaly::impact)).setter(Anomaly.setter(Builder::impact)).constructor(Impact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()}).build();
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Anomaly.getter(Anomaly::monitorArn)).setter(Anomaly.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<String> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Anomaly.getter(Anomaly::feedbackAsString)).setter(Anomaly.setter(Builder::feedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_ID_FIELD, ANOMALY_START_DATE_FIELD, ANOMALY_END_DATE_FIELD, DIMENSION_VALUE_FIELD, ROOT_CAUSES_FIELD, ANOMALY_SCORE_FIELD, IMPACT_FIELD, MONITOR_ARN_FIELD, FEEDBACK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String anomalyId;
    private final String anomalyStartDate;
    private final String anomalyEndDate;
    private final String dimensionValue;
    private final List<RootCause> rootCauses;
    private final AnomalyScore anomalyScore;
    private final Impact impact;
    private final String monitorArn;
    private final String feedback;

    private Anomaly(BuilderImpl builder) {
        this.anomalyId = builder.anomalyId;
        this.anomalyStartDate = builder.anomalyStartDate;
        this.anomalyEndDate = builder.anomalyEndDate;
        this.dimensionValue = builder.dimensionValue;
        this.rootCauses = builder.rootCauses;
        this.anomalyScore = builder.anomalyScore;
        this.impact = builder.impact;
        this.monitorArn = builder.monitorArn;
        this.feedback = builder.feedback;
    }

    public String anomalyId() {
        return this.anomalyId;
    }

    public String anomalyStartDate() {
        return this.anomalyStartDate;
    }

    public String anomalyEndDate() {
        return this.anomalyEndDate;
    }

    public String dimensionValue() {
        return this.dimensionValue;
    }

    public boolean hasRootCauses() {
        return this.rootCauses != null && !(this.rootCauses instanceof SdkAutoConstructList);
    }

    public List<RootCause> rootCauses() {
        return this.rootCauses;
    }

    public AnomalyScore anomalyScore() {
        return this.anomalyScore;
    }

    public Impact impact() {
        return this.impact;
    }

    public String monitorArn() {
        return this.monitorArn;
    }

    public AnomalyFeedbackType feedback() {
        return AnomalyFeedbackType.fromValue(this.feedback);
    }

    public String feedbackAsString() {
        return this.feedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootCauses());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.impact());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)obj;
        return Objects.equals(this.anomalyId(), other.anomalyId()) && Objects.equals(this.anomalyStartDate(), other.anomalyStartDate()) && Objects.equals(this.anomalyEndDate(), other.anomalyEndDate()) && Objects.equals(this.dimensionValue(), other.dimensionValue()) && Objects.equals(this.rootCauses(), other.rootCauses()) && Objects.equals(this.anomalyScore(), other.anomalyScore()) && Objects.equals(this.impact(), other.impact()) && Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.feedbackAsString(), other.feedbackAsString());
    }

    public String toString() {
        return ToString.builder((String)"Anomaly").add("AnomalyId", (Object)this.anomalyId()).add("AnomalyStartDate", (Object)this.anomalyStartDate()).add("AnomalyEndDate", (Object)this.anomalyEndDate()).add("DimensionValue", (Object)this.dimensionValue()).add("RootCauses", this.rootCauses()).add("AnomalyScore", (Object)this.anomalyScore()).add("Impact", (Object)this.impact()).add("MonitorArn", (Object)this.monitorArn()).add("Feedback", (Object)this.feedbackAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyId": {
                return Optional.ofNullable(clazz.cast(this.anomalyId()));
            }
            case "AnomalyStartDate": {
                return Optional.ofNullable(clazz.cast(this.anomalyStartDate()));
            }
            case "AnomalyEndDate": {
                return Optional.ofNullable(clazz.cast(this.anomalyEndDate()));
            }
            case "DimensionValue": {
                return Optional.ofNullable(clazz.cast(this.dimensionValue()));
            }
            case "RootCauses": {
                return Optional.ofNullable(clazz.cast(this.rootCauses()));
            }
            case "AnomalyScore": {
                return Optional.ofNullable(clazz.cast(this.anomalyScore()));
            }
            case "Impact": {
                return Optional.ofNullable(clazz.cast(this.impact()));
            }
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "Feedback": {
                return Optional.ofNullable(clazz.cast(this.feedbackAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Anomaly, T> g) {
        return obj -> g.apply((Anomaly)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anomalyId;
        private String anomalyStartDate;
        private String anomalyEndDate;
        private String dimensionValue;
        private List<RootCause> rootCauses = DefaultSdkAutoConstructList.getInstance();
        private AnomalyScore anomalyScore;
        private Impact impact;
        private String monitorArn;
        private String feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(Anomaly model) {
            this.anomalyId(model.anomalyId);
            this.anomalyStartDate(model.anomalyStartDate);
            this.anomalyEndDate(model.anomalyEndDate);
            this.dimensionValue(model.dimensionValue);
            this.rootCauses(model.rootCauses);
            this.anomalyScore(model.anomalyScore);
            this.impact(model.impact);
            this.monitorArn(model.monitorArn);
            this.feedback(model.feedback);
        }

        public final String getAnomalyId() {
            return this.anomalyId;
        }

        @Override
        public final Builder anomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
            return this;
        }

        public final void setAnomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
        }

        public final String getAnomalyStartDate() {
            return this.anomalyStartDate;
        }

        @Override
        public final Builder anomalyStartDate(String anomalyStartDate) {
            this.anomalyStartDate = anomalyStartDate;
            return this;
        }

        public final void setAnomalyStartDate(String anomalyStartDate) {
            this.anomalyStartDate = anomalyStartDate;
        }

        public final String getAnomalyEndDate() {
            return this.anomalyEndDate;
        }

        @Override
        public final Builder anomalyEndDate(String anomalyEndDate) {
            this.anomalyEndDate = anomalyEndDate;
            return this;
        }

        public final void setAnomalyEndDate(String anomalyEndDate) {
            this.anomalyEndDate = anomalyEndDate;
        }

        public final String getDimensionValue() {
            return this.dimensionValue;
        }

        @Override
        public final Builder dimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        public final void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        public final Collection<RootCause.Builder> getRootCauses() {
            return this.rootCauses != null ? (Collection)this.rootCauses.stream().map(RootCause::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rootCauses(Collection<RootCause> rootCauses) {
            this.rootCauses = RootCausesCopier.copy(rootCauses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootCauses(RootCause ... rootCauses) {
            this.rootCauses(Arrays.asList(rootCauses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootCauses(Consumer<RootCause.Builder> ... rootCauses) {
            this.rootCauses(Stream.of(rootCauses).map(c -> (RootCause)((RootCause.Builder)RootCause.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRootCauses(Collection<RootCause.BuilderImpl> rootCauses) {
            this.rootCauses = RootCausesCopier.copyFromBuilder(rootCauses);
        }

        public final AnomalyScore.Builder getAnomalyScore() {
            return this.anomalyScore != null ? this.anomalyScore.toBuilder() : null;
        }

        @Override
        public final Builder anomalyScore(AnomalyScore anomalyScore) {
            this.anomalyScore = anomalyScore;
            return this;
        }

        public final void setAnomalyScore(AnomalyScore.BuilderImpl anomalyScore) {
            this.anomalyScore = anomalyScore != null ? anomalyScore.build() : null;
        }

        public final Impact.Builder getImpact() {
            return this.impact != null ? this.impact.toBuilder() : null;
        }

        @Override
        public final Builder impact(Impact impact) {
            this.impact = impact;
            return this;
        }

        public final void setImpact(Impact.BuilderImpl impact) {
            this.impact = impact != null ? impact.build() : null;
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        public final String getFeedback() {
            return this.feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(AnomalyFeedbackType feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        public Anomaly build() {
            return new Anomaly(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Anomaly> {
        public Builder anomalyId(String var1);

        public Builder anomalyStartDate(String var1);

        public Builder anomalyEndDate(String var1);

        public Builder dimensionValue(String var1);

        public Builder rootCauses(Collection<RootCause> var1);

        public Builder rootCauses(RootCause ... var1);

        public Builder rootCauses(Consumer<RootCause.Builder> ... var1);

        public Builder anomalyScore(AnomalyScore var1);

        default public Builder anomalyScore(Consumer<AnomalyScore.Builder> anomalyScore) {
            return this.anomalyScore((AnomalyScore)((AnomalyScore.Builder)AnomalyScore.builder().applyMutation(anomalyScore)).build());
        }

        public Builder impact(Impact var1);

        default public Builder impact(Consumer<Impact.Builder> impact) {
            return this.impact((Impact)((Impact.Builder)Impact.builder().applyMutation(impact)).build());
        }

        public Builder monitorArn(String var1);

        public Builder feedback(String var1);

        public Builder feedback(AnomalyFeedbackType var1);
    }
}

