/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on recommended instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetInstance implements SdkPojo, Serializable, ToCopyableBuilder<TargetInstance.Builder, TargetInstance> {
    private static final SdkField<String> ESTIMATED_MONTHLY_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetInstance::estimatedMonthlyCost)).setter(setter(Builder::estimatedMonthlyCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlyCost").build())
            .build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetInstance::estimatedMonthlySavings)).setter(setter(Builder::estimatedMonthlySavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavings").build())
            .build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetInstance::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<Boolean> DEFAULT_TARGET_INSTANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TargetInstance::defaultTargetInstance)).setter(setter(Builder::defaultTargetInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTargetInstance").build())
            .build();

    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO).getter(getter(TargetInstance::resourceDetails))
            .setter(setter(Builder::resourceDetails)).constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()).build();

    private static final SdkField<ResourceUtilization> EXPECTED_RESOURCE_UTILIZATION_FIELD = SdkField
            .<ResourceUtilization> builder(MarshallingType.SDK_POJO)
            .getter(getter(TargetInstance::expectedResourceUtilization))
            .setter(setter(Builder::expectedResourceUtilization))
            .constructor(ResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedResourceUtilization")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_MONTHLY_COST_FIELD,
            ESTIMATED_MONTHLY_SAVINGS_FIELD, CURRENCY_CODE_FIELD, DEFAULT_TARGET_INSTANCE_FIELD, RESOURCE_DETAILS_FIELD,
            EXPECTED_RESOURCE_UTILIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String estimatedMonthlyCost;

    private final String estimatedMonthlySavings;

    private final String currencyCode;

    private final Boolean defaultTargetInstance;

    private final ResourceDetails resourceDetails;

    private final ResourceUtilization expectedResourceUtilization;

    private TargetInstance(BuilderImpl builder) {
        this.estimatedMonthlyCost = builder.estimatedMonthlyCost;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.currencyCode = builder.currencyCode;
        this.defaultTargetInstance = builder.defaultTargetInstance;
        this.resourceDetails = builder.resourceDetails;
        this.expectedResourceUtilization = builder.expectedResourceUtilization;
    }

    /**
     * <p>
     * Expected cost to operate this instance type on a monthly basis.
     * </p>
     * 
     * @return Expected cost to operate this instance type on a monthly basis.
     */
    public String estimatedMonthlyCost() {
        return estimatedMonthlyCost;
    }

    /**
     * <p>
     * Estimated savings resulting from modification, on a monthly basis.
     * </p>
     * 
     * @return Estimated savings resulting from modification, on a monthly basis.
     */
    public String estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to calculate the costs for this instance.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to calculate the costs for this instance.
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * Indicates whether or not this recommendation is the defaulted Amazon Web Services recommendation.
     * </p>
     * 
     * @return Indicates whether or not this recommendation is the defaulted Amazon Web Services recommendation.
     */
    public Boolean defaultTargetInstance() {
        return defaultTargetInstance;
    }

    /**
     * <p>
     * Details on the target instance type.
     * </p>
     * 
     * @return Details on the target instance type.
     */
    public ResourceDetails resourceDetails() {
        return resourceDetails;
    }

    /**
     * <p>
     * Expected utilization metrics for target instance type.
     * </p>
     * 
     * @return Expected utilization metrics for target instance type.
     */
    public ResourceUtilization expectedResourceUtilization() {
        return expectedResourceUtilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTargetInstance());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(expectedResourceUtilization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstance)) {
            return false;
        }
        TargetInstance other = (TargetInstance) obj;
        return Objects.equals(estimatedMonthlyCost(), other.estimatedMonthlyCost())
                && Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(defaultTargetInstance(), other.defaultTargetInstance())
                && Objects.equals(resourceDetails(), other.resourceDetails())
                && Objects.equals(expectedResourceUtilization(), other.expectedResourceUtilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetInstance").add("EstimatedMonthlyCost", estimatedMonthlyCost())
                .add("EstimatedMonthlySavings", estimatedMonthlySavings()).add("CurrencyCode", currencyCode())
                .add("DefaultTargetInstance", defaultTargetInstance()).add("ResourceDetails", resourceDetails())
                .add("ExpectedResourceUtilization", expectedResourceUtilization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EstimatedMonthlyCost":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyCost()));
        case "EstimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "DefaultTargetInstance":
            return Optional.ofNullable(clazz.cast(defaultTargetInstance()));
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        case "ExpectedResourceUtilization":
            return Optional.ofNullable(clazz.cast(expectedResourceUtilization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetInstance, T> g) {
        return obj -> g.apply((TargetInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetInstance> {
        /**
         * <p>
         * Expected cost to operate this instance type on a monthly basis.
         * </p>
         * 
         * @param estimatedMonthlyCost
         *        Expected cost to operate this instance type on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyCost(String estimatedMonthlyCost);

        /**
         * <p>
         * Estimated savings resulting from modification, on a monthly basis.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        Estimated savings resulting from modification, on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(String estimatedMonthlySavings);

        /**
         * <p>
         * The currency code that Amazon Web Services used to calculate the costs for this instance.
         * </p>
         * 
         * @param currencyCode
         *        The currency code that Amazon Web Services used to calculate the costs for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * Indicates whether or not this recommendation is the defaulted Amazon Web Services recommendation.
         * </p>
         * 
         * @param defaultTargetInstance
         *        Indicates whether or not this recommendation is the defaulted Amazon Web Services recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTargetInstance(Boolean defaultTargetInstance);

        /**
         * <p>
         * Details on the target instance type.
         * </p>
         * 
         * @param resourceDetails
         *        Details on the target instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(ResourceDetails resourceDetails);

        /**
         * <p>
         * Details on the target instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceDetails.Builder} avoiding the need to
         * create one manually via {@link ResourceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetails(ResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(ResourceDetails)
         */
        default Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return resourceDetails(ResourceDetails.builder().applyMutation(resourceDetails).build());
        }

        /**
         * <p>
         * Expected utilization metrics for target instance type.
         * </p>
         * 
         * @param expectedResourceUtilization
         *        Expected utilization metrics for target instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedResourceUtilization(ResourceUtilization expectedResourceUtilization);

        /**
         * <p>
         * Expected utilization metrics for target instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceUtilization.Builder} avoiding the need
         * to create one manually via {@link ResourceUtilization#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceUtilization.Builder#build()} is called immediately and
         * its result is passed to {@link #expectedResourceUtilization(ResourceUtilization)}.
         * 
         * @param expectedResourceUtilization
         *        a consumer that will call methods on {@link ResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedResourceUtilization(ResourceUtilization)
         */
        default Builder expectedResourceUtilization(Consumer<ResourceUtilization.Builder> expectedResourceUtilization) {
            return expectedResourceUtilization(ResourceUtilization.builder().applyMutation(expectedResourceUtilization).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String estimatedMonthlyCost;

        private String estimatedMonthlySavings;

        private String currencyCode;

        private Boolean defaultTargetInstance;

        private ResourceDetails resourceDetails;

        private ResourceUtilization expectedResourceUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstance model) {
            estimatedMonthlyCost(model.estimatedMonthlyCost);
            estimatedMonthlySavings(model.estimatedMonthlySavings);
            currencyCode(model.currencyCode);
            defaultTargetInstance(model.defaultTargetInstance);
            resourceDetails(model.resourceDetails);
            expectedResourceUtilization(model.expectedResourceUtilization);
        }

        public final String getEstimatedMonthlyCost() {
            return estimatedMonthlyCost;
        }

        @Override
        public final Builder estimatedMonthlyCost(String estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
            return this;
        }

        public final void setEstimatedMonthlyCost(String estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
        }

        public final String getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final void setEstimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Boolean getDefaultTargetInstance() {
            return defaultTargetInstance;
        }

        @Override
        public final Builder defaultTargetInstance(Boolean defaultTargetInstance) {
            this.defaultTargetInstance = defaultTargetInstance;
            return this;
        }

        public final void setDefaultTargetInstance(Boolean defaultTargetInstance) {
            this.defaultTargetInstance = defaultTargetInstance;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        public final ResourceUtilization.Builder getExpectedResourceUtilization() {
            return expectedResourceUtilization != null ? expectedResourceUtilization.toBuilder() : null;
        }

        @Override
        public final Builder expectedResourceUtilization(ResourceUtilization expectedResourceUtilization) {
            this.expectedResourceUtilization = expectedResourceUtilization;
            return this;
        }

        public final void setExpectedResourceUtilization(ResourceUtilization.BuilderImpl expectedResourceUtilization) {
            this.expectedResourceUtilization = expectedResourceUtilization != null ? expectedResourceUtilization.build() : null;
        }

        @Override
        public TargetInstance build() {
            return new TargetInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
