/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of savings you're accumulating, against the public On-Demand rate of the usage accrued in an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansSavings implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansSavings.Builder, SavingsPlansSavings> {
    private static final SdkField<String> NET_SAVINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansSavings::netSavings)).setter(setter(Builder::netSavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetSavings").build()).build();

    private static final SdkField<String> ON_DEMAND_COST_EQUIVALENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansSavings::onDemandCostEquivalent)).setter(setter(Builder::onDemandCostEquivalent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCostEquivalent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NET_SAVINGS_FIELD,
            ON_DEMAND_COST_EQUIVALENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String netSavings;

    private final String onDemandCostEquivalent;

    private SavingsPlansSavings(BuilderImpl builder) {
        this.netSavings = builder.netSavings;
        this.onDemandCostEquivalent = builder.onDemandCostEquivalent;
    }

    /**
     * <p>
     * The savings amount that you are accumulating for the usage that is covered by a Savings Plans, when compared to
     * the On-Demand equivalent of the same usage.
     * </p>
     * 
     * @return The savings amount that you are accumulating for the usage that is covered by a Savings Plans, when
     *         compared to the On-Demand equivalent of the same usage.
     */
    public String netSavings() {
        return netSavings;
    }

    /**
     * <p>
     * How much the amount that the usage would have cost if it was accrued at the On-Demand rate.
     * </p>
     * 
     * @return How much the amount that the usage would have cost if it was accrued at the On-Demand rate.
     */
    public String onDemandCostEquivalent() {
        return onDemandCostEquivalent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(netSavings());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandCostEquivalent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansSavings)) {
            return false;
        }
        SavingsPlansSavings other = (SavingsPlansSavings) obj;
        return Objects.equals(netSavings(), other.netSavings())
                && Objects.equals(onDemandCostEquivalent(), other.onDemandCostEquivalent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SavingsPlansSavings").add("NetSavings", netSavings())
                .add("OnDemandCostEquivalent", onDemandCostEquivalent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetSavings":
            return Optional.ofNullable(clazz.cast(netSavings()));
        case "OnDemandCostEquivalent":
            return Optional.ofNullable(clazz.cast(onDemandCostEquivalent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansSavings, T> g) {
        return obj -> g.apply((SavingsPlansSavings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansSavings> {
        /**
         * <p>
         * The savings amount that you are accumulating for the usage that is covered by a Savings Plans, when compared
         * to the On-Demand equivalent of the same usage.
         * </p>
         * 
         * @param netSavings
         *        The savings amount that you are accumulating for the usage that is covered by a Savings Plans, when
         *        compared to the On-Demand equivalent of the same usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netSavings(String netSavings);

        /**
         * <p>
         * How much the amount that the usage would have cost if it was accrued at the On-Demand rate.
         * </p>
         * 
         * @param onDemandCostEquivalent
         *        How much the amount that the usage would have cost if it was accrued at the On-Demand rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandCostEquivalent(String onDemandCostEquivalent);
    }

    static final class BuilderImpl implements Builder {
        private String netSavings;

        private String onDemandCostEquivalent;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansSavings model) {
            netSavings(model.netSavings);
            onDemandCostEquivalent(model.onDemandCostEquivalent);
        }

        public final String getNetSavings() {
            return netSavings;
        }

        @Override
        public final Builder netSavings(String netSavings) {
            this.netSavings = netSavings;
            return this;
        }

        public final void setNetSavings(String netSavings) {
            this.netSavings = netSavings;
        }

        public final String getOnDemandCostEquivalent() {
            return onDemandCostEquivalent;
        }

        @Override
        public final Builder onDemandCostEquivalent(String onDemandCostEquivalent) {
            this.onDemandCostEquivalent = onDemandCostEquivalent;
            return this;
        }

        public final void setOnDemandCostEquivalent(String onDemandCostEquivalent) {
            this.onDemandCostEquivalent = onDemandCostEquivalent;
        }

        @Override
        public SavingsPlansSavings build() {
            return new SavingsPlansSavings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
